/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.itext.extension.color;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractColorRegistry {
    private final Map<String, Color> colors = new HashMap<String, Color>();

    public Color getColor(String style) {
        Color color = this.colors.get(style);
        if (color == null) {
            color = this.internalCreateColor(style);
        }
        return color;
    }

    private synchronized Color internalCreateColor(String style) {
        Color color = this.colors.get(style);
        if (color != null) {
            return color;
        }
        color = this.createColor(style);
        if (color != null) {
            this.colors.put(style, color);
        }
        return color;
    }

    protected abstract Color createColor(String var1);
}

