/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import fr.ird.observe.application.web.configuration.ObserveWebApplicationConfig;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabase;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabaseRole;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabases;
import fr.ird.observe.application.web.configuration.user.ObserveWebUser;
import fr.ird.observe.application.web.configuration.user.ObserveWebUserPermission;
import fr.ird.observe.application.web.configuration.user.ObserveWebUsers;
import fr.ird.observe.application.web.security.ObserveWebSecurityAuthenticationTokenCache;
import fr.ird.observe.services.configuration.ObserveDataSourceConfiguration;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import fr.ird.observe.services.configuration.topia.ObserveDataSourceConfigurationTopiaPG;
import fr.ird.observe.services.runner.ObserveDataSourceConfigurationMainFactory;
import fr.ird.observe.services.security.BadObserveWebUserPasswordException;
import fr.ird.observe.services.security.InvalidAuthenticationTokenException;
import fr.ird.observe.services.security.UnknownObserveWebUserException;
import fr.ird.observe.services.security.UnknownObserveWebUserForDatabaseException;
import fr.ird.observe.services.security.UserLoginNotFoundException;
import fr.ird.observe.services.security.UserPasswordNotFoundException;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.version.Version;

public class ObserveWebSecurityApplicationContext
implements Closeable {
    private static final Log log = LogFactory.getLog(ObserveWebSecurityApplicationContext.class);
    protected final ObserveWebSecurityAuthenticationTokenCache authenticateCache;
    protected final ObserveDataSourceConfigurationMainFactory dataSourceConfigurationFactory;
    protected ImmutableMap<String, ObserveDataSourceConfiguration> dataSourceConfigurationCache;
    protected String defaultDatabaseName;
    protected ObserveWebDatabases<?> databases;
    protected ObserveWebUsers<?> users;

    public ObserveWebSecurityApplicationContext(ObserveWebApplicationConfig configuration) {
        this.authenticateCache = new ObserveWebSecurityAuthenticationTokenCache(configuration.getSessionMaximumSize(), configuration.getSessionExpirationDelay());
        this.dataSourceConfigurationFactory = new ObserveDataSourceConfigurationMainFactory();
    }

    public synchronized void init(ObserveWebDatabases<?> databases, ObserveWebUsers<?> users, Version modelVersion) {
        this.databases = databases;
        this.users = users;
        this.authenticateCache.removeAllAuthenticationTokens();
        ObserveWebDatabase defaultDatabase = databases.getDefaultDatabase();
        Objects.requireNonNull(defaultDatabase);
        this.defaultDatabaseName = defaultDatabase.getName();
        ImmutableMap.Builder dataSourceConfigurationsCacheBuilder = new ImmutableMap.Builder();
        for (ObserveWebUser observeWebUser : users.getUsers()) {
            for (ObserveWebUserPermission observeWebUserPermission : observeWebUser.getPermissions()) {
                String databaseName = observeWebUserPermission.getDatabase();
                Optional optionalDatabase = databases.getDatabaseByName(databaseName);
                Preconditions.checkArgument((boolean)optionalDatabase.isPresent());
                ObserveWebDatabase database = (ObserveWebDatabase)optionalDatabase.get();
                String role = observeWebUserPermission.getRole();
                Optional optionalDatabaseRole = database.getDatabaseRoleByLogin(role);
                Preconditions.checkArgument((boolean)optionalDatabaseRole.isPresent());
                ObserveWebDatabaseRole databaseRole = (ObserveWebDatabaseRole)optionalDatabaseRole.get();
                String jdbcUrl = database.getUrl();
                String login = databaseRole.getLogin();
                String password = databaseRole.getPassword();
                String userKey = this.getUserKey(observeWebUser.getLogin(), databaseName);
                ObserveDataSourceConfigurationTopiaPG configuration = this.dataSourceConfigurationFactory.createObserveDataSourceConfigurationTopiaPG(userKey, jdbcUrl, login, password.toCharArray(), true, true, true, modelVersion);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Creates data source configuration for userKey %s : %s", userKey, configuration));
                }
                dataSourceConfigurationsCacheBuilder.put((Object)userKey, (Object)configuration);
            }
        }
        this.dataSourceConfigurationCache = dataSourceConfigurationsCacheBuilder.build();
    }

    public ObserveDataSourceConfiguration getDataSourceConfiguration(String userLogin, Optional<String> optionalDatabaseName) throws UnknownObserveWebUserForDatabaseException {
        ObserveDataSourceConfiguration dataSourceConfiguration;
        String databaseName = optionalDatabaseName.isPresent() ? optionalDatabaseName.get() : this.defaultDatabaseName;
        String userKey = this.getUserKey(userLogin, databaseName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Try to find data source configuration for: " + userKey));
        }
        if ((dataSourceConfiguration = (ObserveDataSourceConfiguration)this.dataSourceConfigurationCache.get((Object)userKey)) == null) {
            throw new UnknownObserveWebUserForDatabaseException(databaseName, userLogin);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use database configuration: " + dataSourceConfiguration));
        }
        return dataSourceConfiguration;
    }

    public String registerDataSourceConfiguration(ObserveDataSourceConfigurationAndConnection configurationAndConnection) {
        return this.authenticateCache.registerDataSourceConfiguration(configurationAndConnection);
    }

    public ObserveDataSourceConfiguration getDataSourceConfiguration(String userLogin, String userPassword, Optional<String> optionalDatabaseName) {
        if (Strings.isNullOrEmpty((String)userLogin)) {
            throw new UserLoginNotFoundException();
        }
        if (Strings.isNullOrEmpty((String)userPassword)) {
            throw new UserPasswordNotFoundException();
        }
        Optional optionalUser = this.users.getUserByLogin(userLogin);
        if (!optionalUser.isPresent()) {
            throw new UnknownObserveWebUserException(userLogin);
        }
        ObserveWebUser user = (ObserveWebUser)optionalUser.get();
        if (!Objects.equals(user.getPassword(), userPassword)) {
            throw new BadObserveWebUserPasswordException(userLogin, userPassword);
        }
        return this.getDataSourceConfiguration(userLogin, optionalDatabaseName);
    }

    public ObserveDataSourceConfigurationAndConnection getDataSourceConfigurationAndConnection(String authenticationToken) {
        ObserveDataSourceConfigurationAndConnection configurationAndConnection = this.authenticateCache.getDataSourceConfigurationAndConnectionIfPresent(authenticationToken);
        if (configurationAndConnection == null) {
            throw new InvalidAuthenticationTokenException(authenticationToken);
        }
        return configurationAndConnection;
    }

    public void invalidateAuthenticationToken(String authenticationToken) {
        this.authenticateCache.removeAuthenticationToken(authenticationToken);
    }

    public ImmutableMap<String, ObserveDataSourceConfigurationAndConnection> getConfigurationByAuthenticationToken() {
        return ImmutableMap.copyOf((Map)this.authenticateCache.getAuthenticationTokenCache().asMap());
    }

    @Override
    public void close() {
        this.authenticateCache.close();
    }

    protected String getUserKey(String userLogin, String databaseName) {
        return userLogin + "--" + databaseName;
    }
}

