/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web;

import com.google.common.base.Preconditions;
import fr.ird.observe.application.web.ObserveWebApplicationListener;
import fr.ird.observe.application.web.configuration.ObserveWebApplicationConfiguration;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabaseException;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabaseRoleException;
import fr.ird.observe.application.web.configuration.db.InvalidObserveWebDatabasesException;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabases;
import fr.ird.observe.application.web.configuration.db.ObserveWebDatabasesHelper;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUserException;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUserPermissionException;
import fr.ird.observe.application.web.configuration.user.InvalidObserveWebUsersException;
import fr.ird.observe.application.web.configuration.user.ObserveWebUsers;
import fr.ird.observe.application.web.configuration.user.ObserveWebUsersHelper;
import fr.ird.observe.application.web.security.ObserveWebSecurityApplicationContext;
import fr.ird.observe.services.ObserveService;
import fr.ird.observe.services.ObserveServiceFactory;
import fr.ird.observe.services.ObserveServiceInitializer;
import fr.ird.observe.services.dto.gson.ObserveDtoGsonSupplier;
import fr.ird.observe.services.runner.ObserveServiceMainFactory;
import java.io.Closeable;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.debux.webmotion.server.call.HttpContext;
import org.nuiton.version.Version;

public class ObserveWebApplicationContext
implements Closeable {
    public static final String APPLICATION_CONTEXT_PARAMETER = ObserveWebApplicationContext.class.getName();
    public static final String MISSING_APPLICATION_CONTEXT = ObserveWebApplicationContext.class.getSimpleName() + " not found. You probably forgot to register " + ObserveWebApplicationListener.class.getName() + " in your web.xml";
    protected ObserveDtoGsonSupplier gsonSupplier;
    protected ObserveWebApplicationConfiguration applicationConfiguration;
    protected ObserveServiceFactory mainServiceFactory;
    protected ObserveWebDatabases databases;
    protected ObserveWebUsers users;
    protected ObserveWebSecurityApplicationContext securityApplicationContext;

    public static ObserveWebApplicationContext getApplicationContext(HttpContext context) {
        ServletContext servletContext = context.getServletContext();
        ObserveWebApplicationContext result = (ObserveWebApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)MISSING_APPLICATION_CONTEXT);
        return result;
    }

    public void init() throws InvalidObserveWebDatabaseException, InvalidObserveWebDatabasesException, InvalidObserveWebDatabaseRoleException, InvalidObserveWebUserPermissionException, InvalidObserveWebUsersException, InvalidObserveWebUserException {
        this.applicationConfiguration = new ObserveWebApplicationConfiguration();
        this.applicationConfiguration.init(new String[0]);
        ObserveWebDatabasesHelper databasesHelper = new ObserveWebDatabasesHelper();
        this.databases = databasesHelper.load(this.applicationConfiguration.getDatabasesConfigurationFile());
        ObserveWebUsersHelper usersHelper = new ObserveWebUsersHelper();
        this.users = usersHelper.load(this.databases, this.applicationConfiguration.getUsersConfigurationFile());
        this.securityApplicationContext = new ObserveWebSecurityApplicationContext(this.applicationConfiguration);
        Version modelVersion = this.applicationConfiguration.getModelVersion();
        this.securityApplicationContext.init(this.databases, this.users, modelVersion);
        this.mainServiceFactory = ObserveServiceMainFactory.get();
        boolean devMode = this.applicationConfiguration.isDevMode();
        this.gsonSupplier = new ObserveDtoGsonSupplier(devMode);
    }

    public void reloadConfiguration() throws InvalidObserveWebUserPermissionException, InvalidObserveWebUsersException, InvalidObserveWebUserException, InvalidObserveWebDatabaseException, InvalidObserveWebDatabasesException, InvalidObserveWebDatabaseRoleException {
        ObserveWebDatabasesHelper databasesHelper = new ObserveWebDatabasesHelper();
        this.databases = databasesHelper.load(this.applicationConfiguration.getDatabasesConfigurationFile());
        ObserveWebUsersHelper usersHelper = new ObserveWebUsersHelper();
        this.users = usersHelper.load(this.databases, this.applicationConfiguration.getUsersConfigurationFile());
        Version modelVersion = this.applicationConfiguration.getModelVersion();
        this.securityApplicationContext.init(this.databases, this.users, modelVersion);
    }

    @Override
    public void close() throws IOException {
        this.securityApplicationContext.close();
        this.mainServiceFactory.close();
    }

    public ObserveDtoGsonSupplier getGsonSupplier() {
        return this.gsonSupplier;
    }

    public ObserveWebApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public ObserveWebSecurityApplicationContext getSecurityApplicationContext() {
        return this.securityApplicationContext;
    }

    public ObserveWebDatabases getDatabases() {
        return this.databases;
    }

    public ObserveWebUsers getUsers() {
        return this.users;
    }

    public <S extends ObserveService> S newService(ObserveServiceInitializer observeServiceInitializer, Class<S> serviceType) {
        return (S)this.mainServiceFactory.newService(observeServiceInitializer, serviceType);
    }
}

