/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Search.java 164 2011-05-13 13:12:11Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-client/src/main/java/fr/inra/refcomp/client/user/Search.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.http.client.URL;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.RefComp;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.constants.Unauthorized;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Unit;
import java.util.List;
import org.nuiton.web.gwt.misc.LoaderNotification;

/**
 * User: couteau
 * Date: 3 nov. 2010
 */
public class Search extends Composite {

    protected final StorageServiceAsync service = GWT.create(StorageService.class);

    @UiTemplate("Search.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Search> {
    }

    protected static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    TextBox searchBox;

    @UiField
    SimplePanel departmentLabelDiv;

    @UiField
    FlowPanel departmentListDiv;

    @UiField
    SimplePanel catiLabelDiv;

    @UiField
    FlowPanel catiListDiv;

    @UiField
    SimplePanel unitLabelDiv;

    @UiField
    FlowPanel unitListDiv;

    @UiField
    SimplePanel frequencyLabelDiv;

    @UiField
    FlowPanel frequencyListDiv;

    @UiField
    ListBox catiList;

    @UiField
    ListBox departmentList;

    @UiField
    ListBox unitList;

    @UiField
    ListBox frequencyList;

    @UiField
    RadioButton radioAgent;

    @UiField
    RadioButton radioSkill;

    @UiField
    Label noResultLabel;

    @UiField
    Button advancedSearch;

    protected boolean filterVisible = false;

    public Search() {
        initWidget(binder.createAndBindUi(this));

        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                RefComp.logOut();
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new Unauthorized());
                LoaderNotification.closeLoader();
            }

            @Override
            public void onSuccess(Boolean isLoggedIn) {
                if (!isLoggedIn) {
                    RefComp.logOut();
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                    LoaderNotification.closeLoader();
                } else {
                    //Init not visible list boxes while the user does nothing
                    service.getCatis(new RefcompCallBack<List<Cati>>() {
                        @Override
                        public void onSuccess(List<Cati> result) {
                            catiList.addItem("", "");
                            for (Cati cati : result) {
                                catiList.addItem(cati.getName(), cati.getWikittyId());
                            }
                        }
                    });

                    service.getDepartments(new RefcompCallBack<List<Department>>() {
                        @Override
                        public void onSuccess(List<Department> result) {
                            departmentList.addItem("", "");
                            for (Department department : result) {
                                departmentList.addItem(department.getName(),
                                        department.getWikittyId());
                            }
                        }
                    });

                    service.getUnits(new RefcompCallBack<List<Unit>>() {
                        @Override
                        public void onSuccess(List<Unit> result) {
                            unitList.addItem("", "");
                            for (Unit unit : result) {
                                unitList.addItem(unit.getName(), unit.getWikittyId());
                            }
                        }
                    });

                    service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
                        @Override
                        public void onSuccess(List<Frequency> result) {
                            frequencyList.addItem("", "");
                            for (Frequency frequency : result) {
                                frequencyList.addItem(frequency.getName(),
                                        frequency.getWikittyId());
                            }
                        }
                    });
                }
            }
        });

    }

    public Search(final String search, final String cati,
                  final String department, final String unit,
                  final String frequency, final Boolean noResult) {

        initWidget(binder.createAndBindUi(this));

        service.isLoggedIn(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                RefComp.logOut();
                RootPanel content = RootPanel.get("content");
                content.clear();
                content.add(new Unauthorized());
                LoaderNotification.closeLoader();
            }

            @Override
            public void onSuccess(Boolean isLoggedIn) {
                if (!isLoggedIn) {
                    RefComp.logOut();
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                    LoaderNotification.closeLoader();
                } else {
                    if (noResult) {
                        noResultLabel.setVisible(true);
                    }

                    searchBox.setText(search);

                    service.getCatis(new RefcompCallBack<List<Cati>>() {
                        @Override
                        public void onSuccess(List<Cati> result) {
                            catiList.addItem("");
                            for (Cati cati : result) {
                                catiList.addItem(cati.getName(), cati.getWikittyId());
                            }

                            if (cati != null && !"null".equals(cati)) {
                                for (int i = 0; i < catiList.getItemCount(); i++) {
                                    if (cati.equals(catiList.getValue(i))) {
                                        catiList.setSelectedIndex(i);
                                    }
                                }

                                setFilterVisible(true);
                            }
                        }
                    });

                    service.getDepartments(new RefcompCallBack<List<Department>>() {
                        @Override
                        public void onSuccess(List<Department> result) {
                            departmentList.addItem("");
                            for (Department department : result) {
                                departmentList.addItem(department.getName(),
                                        department.getWikittyId());
                            }

                            if (department != null && !"null".equals(department)) {
                                for (int i = 0; i < departmentList.getItemCount(); i++) {
                                    if (department.equals(departmentList.getValue(i))) {
                                        departmentList.setSelectedIndex(i);
                                    }
                                }

                                setFilterVisible(true);
                            }
                        }
                    });

                    service.getUnits(new RefcompCallBack<List<Unit>>() {
                        @Override
                        public void onSuccess(List<Unit> result) {
                            unitList.addItem("");
                            for (Unit unit : result) {
                                unitList.addItem(unit.getName(), unit.getWikittyId());
                            }

                            if (unit != null && !"null".equals(unit)) {
                                for (int i = 0; i < unitList.getItemCount(); i++) {
                                    if (unit.equals(unitList.getValue(i))) {
                                        unitList.setSelectedIndex(i);
                                    }
                                }

                                setFilterVisible(true);
                            }
                        }
                    });

                    service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
                        @Override
                        public void onSuccess(List<Frequency> result) {
                            frequencyList.addItem("");
                            for (Frequency frequency : result) {
                                frequencyList.addItem(frequency.getName(),
                                        frequency.getWikittyId());
                            }

                            if (frequency != null && !"null".equals(frequency)) {
                                for (int i = 0; i < frequencyList.getItemCount(); i++) {
                                    if (frequency.equals(frequencyList.getValue(i))) {
                                        frequencyList.setSelectedIndex(i);
                                    }
                                }

                                setFilterVisible(true);
                            }

                            LoaderNotification.closeLoader();
                        }
                    });
                }
            }
        });



    }

    protected void setFilterVisible(boolean visible) {
        departmentLabelDiv.setVisible(visible);
        departmentListDiv.setVisible(visible);
        catiLabelDiv.setVisible(visible);
        catiListDiv.setVisible(visible);
        unitLabelDiv.setVisible(visible);
        unitListDiv.setVisible(visible);
        frequencyLabelDiv.setVisible(visible);
        frequencyListDiv.setVisible(visible);

        filterVisible = visible;

        RefcompMessages messages = GWT.create(RefcompMessages.class);

        if (visible) {
            Element search = Document.get().getElementById("search");
            search.setClassName("rechercheavance clearfix");
            advancedSearch.setHTML(messages.maskAvancedSearch());
        } else {
            Element search = Document.get().getElementById("search");
            search.setClassName("recherche clearfix");
            advancedSearch.setHTML(messages.avancedSearch());
        }
    }

    /**
     * Manage the display/hide of advanced search panel
     * @param event the click on advanced button event
     */
    @UiHandler("advancedSearch")
    void expandAdvancedSearch(ClickEvent event) {
        setFilterVisible(!filterVisible);
    }

    /**
     * Submit search when ENTER pressed when typing in search box
     * @param event the key pressed event
     */
    @UiHandler("searchBox")
    void pressKey(KeyPressEvent event) {
        if ((event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) ||
                (event.getNativeEvent().getCharCode() == KeyCodes.KEY_ENTER)) {
            doClickSubmit(null);
        }
    }

    @UiHandler("radioSkill")
    void selectSkill(ClickEvent event) {
        if(radioSkill.getValue()) {
            frequencyList.setEnabled(true);
        }
    }

    @UiHandler("radioAgent")
    void selectAgent(ClickEvent event) {
        if(radioAgent.getValue()) {
            frequencyList.setEnabled(false);
        }
    }

    /**
     * Submit the form
     * @param event the click submit button event
     */
    @UiHandler("buttonSearch")
    void doClickSubmit(ClickEvent event) {

        String catiFilter = null;
        String departmentFilter = null;
        String frequencyFilter = null;
        String unitFilter = null;

        if (filterVisible){
            catiFilter = catiList.getValue(catiList.getSelectedIndex());
        }

        if (filterVisible){
            departmentFilter = departmentList.getValue(departmentList.getSelectedIndex());
        }

        if (filterVisible){
            unitFilter = unitList.getValue(unitList.getSelectedIndex());
        }

        if (filterVisible){
            frequencyFilter = frequencyList.getValue(frequencyList.getSelectedIndex());
        }

        if (radioSkill.getValue()) {
            History.newItem("searchSkills?search="+ URL.encodeQueryString(searchBox.getValue())+
                    "&cati=" + catiFilter +
                    "&department=" + departmentFilter +
                    "&unit=" + unitFilter +
                    "&frequency=" + frequencyFilter);
        }

        if (radioAgent.getValue()) {
            History.newItem("searchUsers?search=" + URL.encodeQueryString(searchBox.getValue()) +
                    "&cati=" + catiFilter +
                    "&department=" + departmentFilter +
                    "&unit=" + unitFilter);
        }
    }
}
