/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: StorageService.java 164 2011-05-13 13:12:11Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/client/services/StorageService.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.services;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import fr.inra.refcomp.entities.Agent;
import fr.inra.refcomp.entities.AgentSkill;
import fr.inra.refcomp.entities.EntitiesList;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.entities.Department;
import fr.inra.refcomp.entities.Frequency;
import fr.inra.refcomp.entities.Unit;
import fr.inra.refcomp.entities.User;
import fr.inra.refcomp.services.AlreadyExistingException;
import fr.inra.refcomp.services.InvalidEntityException;
import fr.inra.refcomp.services.UsedException;
import java.util.List;
import fr.inra.refcomp.entities.Skill;
import java.util.Map;

/**
 * User: couteau
 * Date: 30 nov. 2010
 */
@RemoteServiceRelativePath("storage")
public interface StorageService extends RemoteService{

    List<Cati> getCatis();

    Cati saveCati(Cati cati) throws AlreadyExistingException,
            InvalidEntityException;

    Cati createCati();

    Cati getCati(String id);

    void deleteCati(Cati cati);

    List<Frequency> getFrequencies();

    Frequency saveFrequency(Frequency frequency)
            throws AlreadyExistingException, InvalidEntityException;

    Frequency createFrequency();

    Frequency getFrequency(String id);

    void deleteFrequency(Frequency frequency, boolean force)
            throws UsedException;

    List<User> getUsers();

    User saveUser(User user, String context)
            throws AlreadyExistingException, InvalidEntityException;

    User createUser();

    User getUser(String id);

    Agent getAgent(String id);

    EntitiesList getAgentAndDependencies(String id);

    Agent setAgent(User user);

    void unsetAgent(String id);

    Agent saveAgent(Agent agent, String context)
            throws AlreadyExistingException, InvalidEntityException;

    void deleteUser(User user);

    Boolean login(String login, String password);

    void logout();

    List<Skill> getChildrenSkill(String id);

    Skill saveSkill(Skill skill)
            throws AlreadyExistingException, InvalidEntityException;

    Skill createSkill(String parentId);

    Skill getSkill(String id);

    void deleteSkill(Skill skill) throws UsedException;

    Unit saveUnit(Unit unit)
            throws AlreadyExistingException, InvalidEntityException;

    Unit saveUnit(Unit unit, List<String> departments)
            throws AlreadyExistingException, InvalidEntityException;

    Unit createUnit();

    Unit getUnit(String id);

    void deleteUnit(Unit unit);

    List<Unit> getUnits();

    List<Unit> getUnits(String id);

    Department saveDepartment(Department department)
            throws AlreadyExistingException, InvalidEntityException;

    Department saveDepartment(Department department, List<String> units)
            throws AlreadyExistingException, InvalidEntityException;

    Department createDepartment();

    Department getDepartment(String id);

    void deleteDepartment(Department department);

    List<Department> getDepartments();

    List<Department> getDepartments(String id);

    String getAdminEmail();

    Boolean isAdmin();

    Boolean isAdmin(String id);

    Boolean isAgent();

    Boolean isLoggedIn();

    void adminCreationIfDoNotExist();

    EntitiesList getSkills();

    EntitiesList getSkills(String agentId);

    AgentSkill addSkill();

    EntitiesList addSkill(Skill skill, String frequencyId);

    void removeSkill(String skillId);

    EntitiesList saveMySkills(List<AgentSkill> skills)
            throws InvalidEntityException;

    AgentSkill getAgentSkill(String skillId);

    User getLoggedInUser();

    Agent getLoggedInAgent();

    void setAdmin(String agentId, boolean admin);


    EntitiesList searchUser(String search, String cati, String department,
                               String unit, String frequency);

    EntitiesList searchSkill(String search, String cati, String department,
                               String unit, String frequency);

    String getPath(String id);

    void setPrivateSkills(List<String> ids);

    void setPublicSkills(List<String> ids);

    boolean moveSkill(String destination, String node);

    boolean sendPassword(String userId);

    Map<String,Skill> getRootSkill(List<String> skills);

    List<Skill> getAllSkills();
}
