/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: HistoryUtil.java 173 2011-05-27 08:32:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/client/constants/HistoryUtil.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * User: couteau
 * Date: 16/02/11
 */
public class HistoryUtil {

    public static Map<String,String> parseHistoryToken(String token) {
        String parametersLine = token.substring(token.lastIndexOf("?") + 1);

        Map<String,String> tokenParameters = new HashMap<String, String>();

        String[] parameters = parametersLine.split("&");
        for(String parameter:parameters) {
            String[] values = parameter.split("=");
            if (values.length == 2) {
                tokenParameters.put(values[0],values[1]);
            } else {
                tokenParameters.put(values[0],null);
            }
        }

        return tokenParameters;
    }
}
