/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminUnits.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-0.1/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/units/AdminUnits.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.units;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Unit;
import java.util.List;

/**
 * User: couteau
 * Date: 2 déc. 2010
 */
public class AdminUnits extends Composite {

    private static final StorageServiceAsync service = GWT.create(StorageService.class);

    @UiTemplate("AdminUnits.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminUnits> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    Form form;

    @UiField
    static ListBox unitList;

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {

        service.createUnit(new RefcompCallBack<Unit>() {
            @Override
            public void onSuccess(Unit result) {
                form.setContent(result, true);
            }
        });
    }

    public AdminUnits() {
        initWidget(binder.createAndBindUi(this));

        AdminUtil.checkAdmin();
        refresh();

        //Init the form panel
        UnitForm unitForm = new UnitForm();
        form.setContentPanel(unitForm);

        unitList.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                String beanId = unitList.getValue(unitList.getSelectedIndex());

                service.getUnit(beanId, new RefcompCallBack<Unit>() {
                    @Override
                    public void onSuccess(Unit result) {
                        form.setContent(result, false);
                    }
                });

            }
        });
    }

    public static void refresh(){
        service.getUnits(new RefcompCallBack<List<Unit>>() {
            @Override
            public void onSuccess(List<Unit> result) {
                unitList.clear();
                for (Unit unit : result) {
                    String text = unit.getName();
                    String fullName = unit.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    unitList.addItem(text, unit.getWikittyId());
                }
            }
        });
    }

}
