/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.ui.pages.RoadMap;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;

import java.util.Calendar;

/**
 * Created: 8 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: Footer.java 1208 2011-04-15 09:56:08Z bleny $
 */
public class Footer {

    @Inject
    private PageRenderLinkSource pageRender;

    @Parameter
    @Property
    private ConnectedUser connectedUser;    

    public String getVersion() {
        return WaoProperty.APP_VERSION.getValue();
    }

    public int getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(Calendar.YEAR);
    }
}
