/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

/*
 * Permet d'attacher un évènement à l'appui sur la touche entrée
 */
$.fn.enterKey = function (fnc) {
    return this.each(function () {
        $(this).keypress(function (e) {
            var keycode = e.keyCode || e.which;
            if (keycode === 13) {
                e.preventDefault();
                fnc.call(this, arguments);
            }
        })
    })
}

/*
 * Sur un élément permet d'ajouter et de retirer full-view et compact-view
 * ou l'inverse selon la valeur de l'argument.
 */
$.fn.toggleCompactFullView = function (fullView) {
    return this.each(function () {
        if (fullView) {
            $(this).addClass('full-view').removeClass('compact-view');
        } else {
            $(this).addClass('compact-view').removeClass('full-view');
        }
    })
}

var FilterModel = function (filterValuesUrl) {

    var self = this;

    this.filterValues = {};
    this.filterValuesUrl = filterValuesUrl;

    this.setFilterValues = function (filterValues) {
        this.filterValues = filterValues;
        $(this).trigger('updated');
    };

    this.updateFilterValues = function(filter) {
        var successCallback = function (data) {
            self.setFilterValues(data.filterValues)
        };
        WAO.get(this.filterValuesUrl, filter, successCallback);
    }

};

var FilterView = function (filterModel, $filtersForm) {

    var self = this;

    this.model = filterModel;
    this.$filtersForm = $filtersForm;
    this.$selects = $filtersForm.find('select');
    this.$inputs = $filtersForm.find('input');

    this.getFilter = function () {
        var filter = WAO.toData(this.$filtersForm);
        return filter;
    };

    /* On va regarder les filterValues dans le modèle et ajouter toutes les options nécessaires */
    this.refreshFilterValues = function() {
        // store options selected by user to re-select them after update
        var filter = this.getFilter();
        var filterValues = this.model.filterValues;
        this.$selects.each(function (index, select) {
            var $select = $(select).empty();
            // FIXME brendan 26/03/14 should be data-binding but freemarker break the template :-(
            var binding = $select.attr('databinding');
            var options = WAO.getNestedPropertyValue(binding, filterValues);
            $.each(options, function (index, option) {
                var optionHtml = '<option value="' + option.value + '">' + option.label + '</option>';
                $select.append(optionHtml);
            });
        });
        this.selectOptions(filter);
        this.$filtersForm.effect('highlight', 'slow');
    };

    /* On prend un filter en paramètre et on va sélectionner les options correspondantes */
    this.selectOptions = function (filter) {
        this.$selects.each(function (index, select) {
            var $select = $(select);
            $select.find('option:selected').prop('selected', false);
            var name = $select.prop('name');
            var selectedOptions = filter[name];
            $.each(selectedOptions, function (index, selectedOption) {
                $select.find('option[value="' + selectedOption + '"]').prop('selected', 'selected');
            });
        });
        this.$inputs.each(function (index, input) {
            var $input = $(input);
            var parameterName = $input.prop('name');
            var parameterValue = filter[parameterName];
            $input.prop('value', parameterValue);
            if ($input.attr('type') === 'checkbox') {
                $input.prop('checked', parameterValue);
            }
        });
    };

    this.lock = function () {
        if ( ! this.$spinner) {
            this.$spinner = this.$filtersForm.spin();
        } else {
            this.$spinner.spin();
        }
        this.$inputs.attr('disabled', 'disabled');
        this.$selects.attr('disabled', 'disabled');
    };

    this.unlock = function () {
        this.$spinner.spin(false);
        this.$inputs.removeAttr('disabled');
        this.$selects.removeAttr('disabled');
    };

    $(this.model).on('updated', function () {
        self.refreshFilterValues();
        self.unlock();
    });

};

var FilterController = function (filterValuesUrl, $filtersForm) {

    var self = this;

    this.model = new FilterModel(filterValuesUrl);
    this.view = new FilterView(this.model, $filtersForm);

    this.updateFilterValues = function () {
        this.view.lock();
        var filter = this.view.getFilter();
        this.model.updateFilterValues(filter);
    };

    this.init = function () {

        var markChange = function () {
            $(this).data('value-changed', true);
        };
        var updateFilterValuesIfValueChanged = function () {
            if ($(this).data('value-changed')) {
                $(this).data('value-changed', false);
                self.updateFilterValues();
            }
        };

        this.view.$selects.change(markChange);
        this.view.$inputs.change(markChange);

        this.view.$selects.blur(updateFilterValuesIfValueChanged);
        this.view.$selects.on('select2-blur', updateFilterValuesIfValueChanged);
        this.view.$inputs.blur(updateFilterValuesIfValueChanged);
        this.view.$selects.mouseleave(updateFilterValuesIfValueChanged);
        this.view.$inputs.mouseleave(updateFilterValuesIfValueChanged);

        this.initialFilter = this.view.getFilter();
    };

    this.reset = function () {
        this.view.selectOptions(this.initialFilter);
        this.updateFilterValues();
    }

};

var Notifications = function () {

    this.$notifications = $('#notifications');

    this.info = function (message) {
        this._notify('info', message);
    };

    this.warn = function (message) {
        this._notify('warn', message);
    };

    this.error = function (message) {
        this._notify('error', message);
    };

    this.success = function (message) {
        this._notify('success', message);
    };

    this._notify = function (level, message) {
        var cssClasses = 'alert alert-' + level;
        if (level === 'warn') {
            cssClasses = 'alert';
        }
        var html = '<div class="' + cssClasses + '">'
                 + '    <button type="button" class="close" data-dismiss="alert">×</button>'
                 + '    ' + message
                 + '</div>';
        this.$notifications.append(html);
    }

};

var FilterModel2 = function (filterMappings, filter, filterValuesUrl) {

    var self = this;

    this.filterMappings = filterMappings;
    this.filter = filter;
    this.filterValuesUrl = filterValuesUrl;

    this.updateOptions = function (oneFilterModel) {

//        var filter = $.extend({}, self.filter);
//        // on lance la recherche mais on ne prend pas en compte le critère qu'on est en train de modifier comme un filtre
//        delete filter[oneFilterModel.filterMapping.filterName];
//        delete filter['filled'];
//
//        var data = {};
//        $.each(filter, function (key,value) {
//            data['filter.' + key] = value;
//        });

        var filter = WAO.toData($('.filters-form'));
        // on lance la recherche mais on ne prend pas en compte le critère qu'on est en train de modifier comme un filtre
        delete filter['filter.' + oneFilterModel.filterMapping.filterName];

        var successCallback = function (data) {
            var options = WAO.getNestedPropertyValue(oneFilterModel.filterMapping.filterValuesField, data.filterValues);
            oneFilterModel.setOptions(options);
        }

        var data = $.extend({}, filter, { filterValuesField: oneFilterModel.filterMapping.filterValuesField });

        WAO.get(this.filterValuesUrl, data, successCallback);
    };

    this.onSelectedOptionsUpdated = function (oneFilterModel) {
        var filterValues = [];
        $.each(oneFilterModel.selectedOptions, function (index, selectedOption) {
            filterValues.push(selectedOption.value);
        });
        this.filter[oneFilterModel.filterMapping.filterName] = filterValues;
    };

    this.setFilter = function (filter) {
        this.filter = filter;
        $(self).trigger('filter-updated', [ this.filter ]);
    };

    this.init = function () {

    }

};

var FilterView2 = function (filterModel, $filtersForm) {

    var self = this;

    this.model = filterModel;
    this.$filtersForm = $filtersForm;

    this.init = function () {

    }

};


var FilterController2 = function (filterMappings, filter,  filterValuesUrl, $filtersForm) {

    var self = this;

    this.model = new FilterModel2(filterMappings, filter, filterValuesUrl);
    this.view = new FilterView2(this.model, $filtersForm);
    this.oneFilterControllers = [];

    this.init = function () {

        this.model.init();
        this.view.init();

        $.each(this.model.filterMappings, function (index, filterMapping) {

            var oneFilterController = new OneFilterController(filterMapping, self.model, self);
            oneFilterController.init();
            self.oneFilterControllers.push(oneFilterController);

            self.view.$filtersForm.append(oneFilterController.view.$container);

            $(oneFilterController.model).on('selected-options-updated', function (event, oneFilterModel) {
                self.model.onSelectedOptionsUpdated(oneFilterModel);
            });

            $(self.model).on('filter-updated', function (event, filter) {
                oneFilterController.model.onFilterUpdated(filter);
            });

        });

        $(this.model).trigger('filter-updated', [ this.model.filter ]);

    };

    this.onOpen = function (openedOneFilterController) {
        $.each(this.oneFilterControllers, function (index, oneFilterController) {
            if (oneFilterController != openedOneFilterController) {
                oneFilterController.close();
            }
        });
    }

};

var OneFilterModel = function (filterMapping, filterModel) {

    var self = this;

    this.filterMapping = filterMapping;
    this.options = [];
    this.selectedOptions = [];
    this.filterModel = filterModel;

    this.updateOptions = function () {
        this.filterModel.updateOptions(self);
    };

    this.setOptions = function (options) {
        this.options = options;
        $(self).trigger('options-updated', [ self ]);
    };

    this.setSelectedOptions = function (selectedOptions) {
        this.selectedOptions = selectedOptions;
        $(self).trigger('selected-options-updated', [ self ]);
    };

    this.onFilterUpdated = function (filter) {
        var selectedOptions = [];
        var filterValues = WAO.getNestedPropertyValue(this.filterMapping.filterName, filter);
        if (filterValues) {
            this.updateOptions();
            // XXX brendan 19/05/14 on a pas encore le label, ce sera mis à jour par le updateOptions
            $.each(filterValues, function (index, filterValue) {
                selectedOptions.push({
                    value: filterValue,
                    label: ''
                });
            });
        }
        this.selectedOptions = selectedOptions;
        $(self).trigger('selected-options-updated2', [ self ]);
    };

    this.init = function () {
        //this.onFilterUpdated();
    }

};

var OneFilterView = function (oneFilterModel) {

    var self = this;

    this.model = oneFilterModel;
    this.useSelect2 = true;

    this.init = function () {

        var html = '<div class="control-group">'
                 + '    <label class="control-label">'
                 + '        ' + this.model.filterMapping.filterLabel
                 + '        <button type="button" class="btn btn-link open-button">'
                 + '             <i class="fa fa-edit"></i>'
                 + '        </button>'
                 + '    </label>'
                 + '    <div class="controls">'
                 + '        <span class="selected-options-container"></span>'
                 + '        <span class="select-container">'
                 + '            <select name="filter.' + this.model.filterMapping.filterName + '" multiple="multiple" class="input-large">'
                 + '            </select>'
                 + '            <button type="button" class="btn btn-link close-button">'
                 + '                <i class="fa fa-check"></i>'
                 + '            </button>'
                 + '        </span>'
                 + '    </div>'
                 + '</div>'
                 ;

        this.$container = $(html);

        this.$selectContainer = this.$container.find('.select-container');
        this.$select = this.$container.find('select');

        this.$selectedOptionsContainer = this.$container.find('.selected-options-container');

        this.$openButton = this.$container.find('button.open-button');
        this.$closeButton = this.$container.find('button.close-button');

        this.updateSelectedOptions();

        $(this.model).on('options-updated', function () {
            self.updateOptions();
        });

        $(this.model).on('selected-options-updated2', function () {
            self.updateSelectedOptions();
        });

        this.hide();
    };

    this.show = function () {
        this.$selectedOptionsContainer.hide();
        this.$openButton.hide();
        this.$selectContainer.show();
        if (this.useSelect2) {
            var select2Options = {};
            if (this.model.filterMapping.minimumInputLength) {
               select2Options['minimumInputLength'] = this.model.filterMapping.minimumInputLength;
            }
            this.$select.select2(select2Options);
        }
    };

    this.hide = function () {
        if (this.useSelect2) {
            this.$select.select2('destroy');
        }
        this.$selectedOptionsContainer.show();
        this.$openButton.show();
        this.$selectContainer.hide();
    };

    this.lockSelection = function () {
        if ( ! this.$spinner) {
            this.$spinner = this.$container.spin();
        } else {
            this.$spinner.spin();
        }
        if (this.useSelect2) {
            this.$select.select2('readonly', true);
        } else {
            this.$select.attr('readonly', 'readonly');
        }
    };

    this.unlockSelection = function () {
        if (this.$spinner) {
            this.$spinner.spin(false);
        }
        if (this.useSelect2) {
            this.$select.select2('readonly', false);
            this.$select.select2('open');
        } else {
            this.$select.removeAttr('readonly');
        }
    };

    this.updateOptions = function () {
        self.$select.empty();
        $.each(this.model.options, function (index, option) {
            var optionHtml = '<option value="' + option.value + '">' + option.label + '</option>';
            self.$select.append(optionHtml);
        });
        if (this.useSelect2) {
            var val = [];
            $.each(this.model.selectedOptions, function (index, selectedOption) {
                val.push(selectedOption.value);
            });
            this.$select.val(val).trigger('change');
        }
        this.updateSelectedOptions();
        this.unlockSelection();
    };

    this.updateSelectedOptions = function () {
        var selectedOptions = self.model.selectedOptions;
        self.$selectedOptionsContainer.empty();
        if (selectedOptions.length === 0) {
            self.$selectedOptionsContainer.append("Pas de filtrage");
            self.$container.removeClass("active-filter");
        } else {
            self.$container.addClass("active-filter");
            var $ul = $('<ul></ul>');
            $.each(selectedOptions, function (index, selectedOption) {
                $ul.append('<li>' + selectedOption.label + '</li>');
            });
            self.$selectedOptionsContainer.append($ul);
        }
    }

};

var OneFilterController = function (filterMapping, filterModel, filterController) {

    var self = this;

    this.model = new OneFilterModel(filterMapping, filterModel);
    this.view = new OneFilterView(this.model);
    this.filterController = filterController;

    this.init = function () {

        this.model.init();
        this.view.init();

        this.view.$select.change(function () {
            var val = self.view.$select.val();
            var selectedOptions = [];
            $.each(self.model.options, function (index, option) {
                if ($.inArray(option.value, val) !== -1) {
                    selectedOptions.push(option);
                }
            });
            self.model.setSelectedOptions(selectedOptions);
        });

        this.view.$closeButton.click(function () {
            self.close();
        });

        this.view.$openButton.click(function () {
            self.open();
        });

    };

    this.open = function () {
        this.filterController.onOpen(this);
        this.model.updateOptions();
        this.view.show();
        this.view.lockSelection();
    };

    this.close = function () {
        this.view.updateSelectedOptions();
        this.view.hide();
    }

};


var Wao = function (newWaoCookie) {

    var self = this;

    this.notifications = new Notifications();
    this.cookie = null;
    this.newWaoCookie = newWaoCookie;

    this.getNestedPropertyValue = function(path, data) {
        return path.split('.').reduce(function(prev, prop){
            return prev && prev[prop]
        }, data)
    };

    this.get = function (url, data, successCallback) {
        $.get(url, data, successCallback);
    };

    this.post = function (url, data, successCallback) {
        $.post(url, data, successCallback);
    };

    this.toData = function ($form) {
        var data = {};
        $form.find('input:not(.select2-input), textarea').each(function (index, input) {
            var $input = $(input);
            var parameterName = $input.prop('name');
            if (parameterName.indexOf('__') === 0) {
                return;
            }
            var parameterValue;
            if ($input.attr('type') === 'checkbox') {
                parameterValue = $input.prop('checked');
            } else {
                parameterValue = $input.prop('value');
            }
            data[parameterName] = parameterValue;
        });
        $form.find('select').each(function (index, select) {
            var $select = $(select);
            var parameterName = $select.prop('name');
            if (parameterName.indexOf('__') === 0) {
                return;
            }
            var parameterValues = [];
            $select.find('option:selected').each(function (index, option) {
                parameterValues.push($(option).prop('value'));
            });
            data[parameterName] = parameterValues;
        });
        return data;
    };

    this.getCookie = function () {
        if (self.cookie === null) {
            // on charge le cookie, s'il n'est pas définit, on en crée un avec les valeur par défaut
            self.cookie = $.cookie('wao') || this.newWaoCookie();
        }
        return self.cookie;
    };

    this.saveCookie = function () {
        if (self.cookie !== null) {
            $.cookie('wao', self.cookie);
        }
    }

};
