<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
<head>
    <title>
        <s:if test="updateContactCommand.creation">
            <s:text name="wao.ui.contact.creation"/>
        </s:if>
        <s:else>
            <s:text name="wao.ui.contact.edition"/>
        </s:else>
    </title>
    <script>

        $(document).ready(function () {

            <s:if test="updateContactCommand.contact.obsProgram.obsMer">
                var $mammalsCaptureCheckbox = $('#mammalsCaptureCheckbox');
                var $mammalsInfo = $('#mammalsInfo');

                var showHideMammalsInfo = function () {
                    if ($mammalsCaptureCheckbox.prop('checked')) {
                        $mammalsInfo.show();
                    } else {
                        $mammalsInfo.hide();
                    }
                };

                $mammalsCaptureCheckbox.change(showHideMammalsInfo);
                showHideMammalsInfo();

                var $contactStateMotif = $('#contactStateMotif');
                var $contactStateSelect = $('select[name="updateContactCommand.contact.contactState"]');
                var $contactStateMotifSelect = $('select[name="updateContactCommand.contactStateMotifId"]');

                var showHideContactStateMotif = function () {
                    var contactState = $contactStateSelect.val();
                    if (contactState === 'CONTACT_REFUSED' || contactState === 'CONTACT_DEFINITELY_REFUSED') {
                        $contactStateMotif.show();
                    } else {
                        $contactStateMotifSelect.val('');
                        $contactStateMotif.hide();
                    }
                };

                $contactStateSelect.change(showHideContactStateMotif);
                showHideContactStateMotif();

            </s:if>

            $('input.date').datetimepicker({
                minView: 2,
                <s:if test="localeFrench">
                    language: 'fr',
                    format: 'dd/mm/yyyy'
                </s:if>
                <s:else>
                    language: 'en',
                    format: 'yyyy-mm-dd'
                </s:else>
            });

            $('input.date-time').datetimepicker({
                <s:if test="localeFrench">
                    language: 'fr',
                    format: 'dd/mm/yyyy hh:ii'
                </s:if>
                <s:else>
                    language: 'en',
                    format: 'yyyy-mm-dd hh:ii'
                </s:else>
            });

            $('#delete-contact-link').click(function (e) {
                if ( ! confirm("<s:text name="wao.ui.action.deleteContact.confirm"/>")) {
                    e.preventDefault();
                }
            });

        });

    </script>
    <content tag="mainClass">form</content>
</head>

    <div class="form-wrapper">
        <h1>
            <s:if test="updateContactCommand.creation">
                <s:text name="wao.ui.contact.creation"/>
            </s:if>
            <s:else>
                <s:text name="wao.ui.contact.edition"/>
            </s:else>
        </h1>

        <aside class="well">

            <h2><s:text name="wao.ui.misc.information"/></h2>

            <s:text name="wao.ui.form.Contact.contactCreatedOn">
                <s:param value="%{formatDate(updateContactCommand.contact.creationDate)}"/>
            </s:text>

            <h3><s:text name="wao.ui.field.Contact.boat"/></h3>

            <table class="table">
                <tbody>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.Boat.name"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.boat.name"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.Boat.registrationCode"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.boat.registrationCode"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.Boat.districtCode"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.boat.districtCode"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.Boat.boatLength"/>
                        </th>
                        <td>
                            <s:property value="%{'' + updateContactCommand.contact.boat.boatLength}"/> cm.
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.Boat.buildYear"/>
                        </th>
                        <td>
                            <s:property value="%{'' + updateContactCommand.contact.boat.buildYear}"/>
                        </td>
                    </tr>
                </tbody>
            </table>

            <h3><s:text name="wao.ui.field.Contact.sampleRow"/></h3>

            <table class="table">
                <tbody>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.SampleRow.code"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.sampleRow.code"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.SampleRow.profession"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.sampleRow.professionDescription"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.SampleRow.programName"/>
                        </th>
                        <td>
                            <s:property value="updateContactCommand.contact.sampleRow.programName"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.SampleRow.periodBegin"/>
                        </th>
                        <td>
                            <s:property value="%{formatMonth(updateContactCommand.contact.sampleRow.periodBegin)}"/>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <s:text name="wao.ui.field.SampleRow.periodEnd"/>
                        </th>
                        <td>
                            <s:property value="%{formatMonth(updateContactCommand.contact.sampleRow.periodEnd)}"/>
                        </td>
                    </tr>
                </tbody>
            </table>

        </aside>

        <s:form>

            <s:set name="editObservationReport"
                   value="%{authenticatedWaoUser.isAuthorizedToEditObservationReport(updateContactCommand.contact)}"/>

            <s:hidden name="contactId" value="%{contactId}"/>

            <s:hidden name="returnToPageNumber" value="%{returnToPageNumber}"/>

            <%--Do not remove the id (use by contacts page)--%>
            <fieldset id="coordinatorOrObserverFocus">
                <legend><s:text name="wao.ui.misc.observers"/></legend>

                <s:select name="updateContactCommand.mainObserverId"
                          value="%{updateContactCommand.mainObserverId}"
                          label="%{getText('wao.ui.field.Contact.mainObserver')}"
                          list="observers"
                          emptyOption="true"
                          disabled="%{!#editObservationReport}"
                          cssClass="input-large"
                          />

                <s:select name="updateContactCommand.secondaryObserverIds"
                          value="%{updateContactCommand.secondaryObserverIds}"
                          label="%{getText('wao.ui.field.Contact.secondaryObservers')}"
                          list="observers"
                          multiple="true"
                          disabled="%{!#editObservationReport}"
                          cssClass="input-xlarge"
                          />

            </fieldset>

            <fieldset>
                <legend><s:text name="wao.ui.misc.observationReport"/></legend>

                <s:textfield name="updateContactCommand.contact.observationBeginDate"
                             label="%{getText('wao.ui.field.Contact.beginDate')}"
                             placeholder="%{getDateTimePlaceholder()}"
                             disabled="%{!#editObservationReport}"
                             cssClass="date-time"/>

                <s:textfield name="updateContactCommand.contact.observationEndDate"
                             label="%{getText('wao.ui.field.Contact.endDate')}"
                             placeholder="%{getDateTimePlaceholder()}"
                             disabled="%{!#editObservationReport}"
                             cssClass="date-time"/>

                <s:select name="updateContactCommand.contact.contactState"
                          label="%{getText('wao.ui.field.Contact.contactState')}"
                          requiredLabel="true"
                          list="contactStates"
                          disabled="%{!#editObservationReport}"/>

                <s:if test="updateContactCommand.contact.obsProgram.obsVente">

                    <s:select name="updateContactCommand.terrestrialLocationId"
                              value="%{updateContactCommand.terrestrialLocationId}"
                              label="%{getText('wao.ui.field.Contact.terrestrialLocation')}"
                              list="terrestrialLocations"
                              emptyOption="true"
                              disabled="%{!#editObservationReport}"
                              cssClass="input-xxlarge"
                              />

                    <s:select name="updateContactCommand.contact.samplingStrategy"
                              label="%{getText('wao.ui.field.Contact.samplingStrategy')}"
                              list="samplingStrategies"
                              emptyOption="true"
                              disabled="%{!#editObservationReport}"/>

                    <s:checkbox name="updateContactCommand.contact.completeSampling"
                                label="%{getText('wao.ui.field.Contact.completeSampling')}"
                                disabled="%{!#editObservationReport}"/>

                </s:if>

                <s:if test="updateContactCommand.contact.obsProgram.obsMer">

                    <div id="contactStateMotif">
                        <s:select name="updateContactCommand.contactStateMotifId"
                                  value="%{updateContactCommand.contactStateMotifId}"
                                  label="%{getText('wao.ui.field.Contact.contactStateMotif')}"
                                  list="contactStateMotives"
                                  emptyOption="true"
                                  disabled="%{!#editObservationReport}"/>
                    </div>

                    <s:checkbox name="updateContactCommand.contact.mammalsObservation"
                                label="%{getText('wao.ui.field.Contact.mammalsObservation')}"
                                disabled="%{!#editObservationReport}"/>

                    <s:checkbox name="updateContactCommand.contact.mammalsCapture"
                                id="mammalsCaptureCheckbox"
                                label="%{getText('wao.ui.field.Contact.mammalsCapture')}"
                                disabled="%{!#editObservationReport}"/>

                    <div id="mammalsInfo">
                        <s:textarea name="updateContactCommand.mammalsInfo"
                                    label="%{getText('wao.ui.field.Contact.mammalsInfo')}"
                                    disabled="%{!#editObservationReport}"/>
                        <div class="alert">
                            <s:text name="wao.ui.page.ContactForm.mammalsInfo.disclaimer"/>
                        </div>
                    </div>

                </s:if>

                <s:textfield name="updateContactCommand.contact.dataInputDate"
                             label="%{getText('wao.ui.field.Contact.dataInputDate')}"
                             placeholder="%{getDatePlaceholder()}"
                             disabled="%{!#editObservationReport}"
                             cssClass="date"/>

                <s:if test="updateContactCommand.contact.obsProgram.obsMer">

                    <s:select name="updateContactCommand.contact.observedDataControl"
                              label="%{getText('wao.ui.field.Contact.observedDataControl')}"
                              list="observedDataControls"
                              emptyOption="true"
                              disabled="%{!#editObservationReport || !authenticatedWaoUser.coordinator}"/>

                    <s:textfield name="updateContactCommand.contact.restitution"
                                 label="%{getText('wao.ui.field.Contact.restitution')}"
                                 placeholder="%{getDatePlaceholder()}"
                                 disabled="%{!#editObservationReport}"
                                 cssClass="date"/>

                </s:if>

                <s:textarea name="updateContactCommand.contact.comment"
                            label="%{getText('wao.ui.field.Contact.comment')}"
                            placeholder="%{getText('wao.ui.misc.noComment')}"
                            disabled="%{!#editObservationReport || !authenticatedWaoUser.observer}"/>

                <s:textarea name="updateContactCommand.contact.commentCoordinator"
                            label="%{getText('wao.ui.field.Contact.commentCoordinator')}"
                            placeholder="%{getText('wao.ui.misc.noComment')}"
                            disabled="%{!#editObservationReport || !authenticatedWaoUser.coordinator}"/>

            </fieldset>

            <%--Do not remove the id (use by contacts page)--%>
            <fieldset id="adminFocus">
                <legend><s:text name="wao.ui.form.programEvaluation"/></legend>

                <s:if test="updateContactCommand.contact.obsProgram.obsMer">
                    <s:if test="authenticatedWaoUser.authorizedToDisplayContactDataReliability">
                        <s:select name="updateContactCommand.contact.dataReliability"
                                  label="%{getText('wao.ui.field.Contact.dataReliability')}"
                                  list="dataReliabilities"
                                  emptyOption="true"
                                  disabled="%{!authenticatedWaoUser.isAuthorizedToEditContactDataReliability(updateContactCommand.contact)}"/>
                    </s:if>
                </s:if>

                <s:textarea name="updateContactCommand.contact.commentAdmin"
                            label="%{getText('wao.ui.field.Contact.commentAdmin')}"
                            placeholder="%{getText('wao.ui.misc.noComment')}"
                            disabled="%{!authenticatedWaoUser.admin}"/>
            </fieldset>

            <div class="form-actions">
                <s:url action="contacts" id="contactsUrl">
                    <s:param name="pageNumber" value="returnToPageNumber"/>
                </s:url>
                <s:a href="%{contactsUrl}" cssClass="btn">
                    <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.cancel"/>
                </s:a>
                <s:if test="authenticatedWaoUser.isAuthorizedToEditContact(updateContactCommand.contact)">
                    <s:submit type="button" cssClass="btn">
                        <i class="icon-hdd"></i> <s:text name="wao.ui.action.save"/>
                    </s:submit>
                </s:if>

                <s:if test=" ! updateContactCommand.creation && authenticatedWaoUser.isAuthorizedToDeleteContact(updateContactCommand.contact)">
                    <s:url action="delete-contact" id="deleteContactUrl">
                        <s:param name="contactId" value="contactId"/>
                    </s:url>
                    <s:a href="%{deleteContactUrl}" cssClass="btn pull-right" id="delete-contact-link">
                        <i class="icon-trash"></i> <s:text name="wao.ui.action.deleteContact"/>
                    </s:a>
                </s:if>
            </div>

        </s:form>
    </div>
</html>

