<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib  prefix="s" uri="/struts-tags" %>
<%@taglib prefix="sj" uri="/struts-jquery-tags" %>

<html>
    <head>
        <title>
            <s:text name="wao.ui.form.authentication.title" />
        </title>
        <script>
            $(document).ready(function () {
                $('input[name="login"]').focus();
            });
        </script>
    </head>
    <body>

        <h1>
            <s:text name="wao.ui.form.authentication.title" />
        </h1>

        <s:form action="login" namespace="/authentication" method="POST" cssClass="form-horizontal">

            <fieldset>

                <s:if test="credentialsAsked">

                    <s:textfield name="login"
                                 label="%{getText('wao.ui.field.WaoUser.login')}"/>

                    <s:password name="password"
                                label="%{getText('wao.ui.field.WaoUser.password')}"/>

                </s:if>
                <s:else>

                    <s:hidden name="login" label="%{login}"/>

                    <s:hidden name="password" value="%{password}"/>

                </s:else>

                <s:if test="userProfileAsked">

                    <s:radio name="userProfileId" list="userProfiles" label="%{getText('wao.ui.form.authentication.chooseUserProfile')}" />

                </s:if>

                <s:if test="acceptCguAsked">

                    <s:checkbox name="cguAccepted" label="%{getText('wao.ui.form.authentication.acceptCgu')}" />

                </s:if>

            </fieldset>

            <div class="form-actions">
                <s:submit type="button" cssClass="btn btn-primary">
                    <s:text name="wao.ui.form.authentication.action.submit"/>
                </s:submit>

                <s:url namespace="/authentication" action="login!input" id="cancelUrl"/>
                <s:a href="%{cancelUrl}" cssClass="btn">
                    <s:text name="wao.ui.action.cancel"/>
                </s:a>
            </div>

        </s:form>

        <s:if test="acceptCguAsked">

            <article id="cgu">
                <h2>CONDITIONS D’UTILISATION DU PORTAIL WAO (web applicatif obsmer)</h2>
                <p>La base de données WAO est accessible via l’adresse internet suivante : http://www.ifremer.fr/wao/ (le « Portail »).</p>
                <p>Les données et informations qui composent le Portail, quelle que soit leur forme, et notamment mais non exclusivement, les données nominatives et techniques, (ci-après communément et indistinctement désignées sous le terme  « Données»), sont soumises aux présentes conditions d’utilisation.</p>
                <p>Le titulaire (le « Titulaire ») du log in et du mot de passe accepte expressément et sans réserve les présentes conditions d’utilisation par le simple fait d’utiliser le log in et le mot de passe et d’accéder aux Données.</p>
                <p>Le log in et le mot de passe sont strictement personnels et confidentiels.  Ils ne peuvent être communiqués à un tiers sans l’accord préalable, exprès et écrit de la direction des pêches maritimes et de l’aquaculture (DPMA) et de l’Institut français de recherche pour l’exploitation de la mer (IFREMER). Sauf accord préalable et exprès de la DPMA et de l’IFREMER, seul le Titulaire est fondé à accéder aux Données, à l’exclusion de toute autre personne..</p>
                <h3>ARTICLE 1 – PROPRIETE DES DONNEES</h3>
                <p>Les Données sont la propriété exclusive de la DPMA et de l’IFREMER.</p>
                <p>La divulgation des Données au Titulaire ne saurait, en aucun cas, être interprétée comme lui conférant, de manière expresse ou implicite un droit quelconque sur ces Donnéesappartenant  conjointement à la DPMA et/ou à l’IFREMER.</p>
                <h3>ARTICLE 2 – CONDITION D’UTILISATION DES DONNEES</h3>
                <p>Les Données ne pourront être consultées et utilisées que dans le cadre du programme Obsmer (le « Programme Obsmer ») et dans les strictes limites suivantes :</p>
                <p>Appui des observateurs des bureaux d’études mandatés par le MAAPRAT auprès des professionnels susceptibles d’embarquer un observateur scientifique</p>
                <p>Appui auprès des professionnels pour la mise en conformité vis-à-vis des obligations administratives nécessaires pour l’embarquement d’un observateur scientifique (note de service DPMA/DAM 2307 du 20 octobre 2008)</p>
                <p>Les Données consultables par le Titulaire sont strictement dédiées au Programme Obsmer  de sorte qu’en dehors de la DPMA, de l’IFREMER, des bureaux d’étude en charge de la réalisation du Programme Obsmer et du Titulaire, aucune autre personne n’a accès aux Données.</p>
                <p>Par conséquent, en cas de constat d’une utilisation des Données dans un domaine autre que le Programme Obsmer, la DPMA et l’IFREMER se réservent le droit de suspendre, sans formalité préalable, le log in et le mot de passe du Titulaire.</p>
                <p>Cette suspension est non exclusive d’éventuelles actions destinées à réparer le préjudice subi par la DPMA et l’IFREMER.</p>
                <p>Les Parties conviennent d’ores et déjà qu’en cas de contestation ou de litige, les données de connexion feront foi.</p>
                <h3>ARTICLE 3 - INTERDICTION D’EXTRACTION OU DE DUPPLICATION DES DONNEES EN DEHORS DU PROGRAMME OBSMER</h3>
                <p>Sauf dans le cadre du Programme Obsmer et dans les conditions de l’article 2 des présentes conditions d’utilisation des Données, le Titulaire ne pourra en aucun cas procéder à une extraction ou duplication des Données sans autorisation écrite et préalable de la DPMA et de l’IFREMER.</p>
                <p>Le Titulaire s’interdit également de communiquer, revendre tout ou partie des Données auxquelles il a accès via le Portail.</p>
                <p>A ce titre, le Titulaire ne procédera pas, notamment, à des copier / coller et / ou toute autre action ayant pour effet de permettre l’extraction ou la duplication de tout ou partie des Données.</p>
                <h3>ARTICLE 4 – PERTE DU LOG IN ET DU MOT DE PASSE</h3>
                <p>En cas de perte du log in et / ou du mot de passe, le Titulaire s’engage à prévenir la DPMA et l’IFREMER dans les plus brefs délais afin que ceux-ci soient désactivés. Il sera attribué au Titulaire un nouveau log in et un nouveau mot de passe.</p>
                <h3>ARTICLE 5 - INFORMATIQUES ET LIBERTES</h3>
                <p>Certaines des Données sont des données à caractère personnel ayant fait l’objet d’une déclaration auprès de la Commission National Informatique et Libertés.</p>
                <p>Le Titulaire consulte et utilise les Données dans le respect de la loi n°78-17 du 6 janvier 1978 modifiée dite loi Informatique et Libertés.</p>
                <h3>ARTICLE 6 - CONFIDENTIALITE</h3>
                <p>Le Titulaire gardera confidentiel les Données qu’il consultera.</p>
                <p>Le Titulaire traitera les Données avec le même degré de précaution et de protection que celui qu’il accorde à ses propres informations confidentielles de même importance.</p>
                <p>Le Titulaire conservera de manière confidentielle, pour une durée de trente (30) ans à compter de la dernière consultation du Portail, les Données disponibles depuis la base de données WAO et s'abstiendra de les divulguer sauf à des employés ou à des préposés responsables qui, astreints au secret professionnel, en auront besoin pour l’accomplissement de leur mission au titre du Programme Obsmer.</p>
                <p>Le Titulaire informera par écrit la DPMA et l’IFREMER de toute perte de document ou d’objet contenant des Données.</p>
                <p>La DPMA et l’IFREMER pourront exiger, à tout moment et sous quelque forme que ce soit, que tous les documents portant des Données soient impérativement restitués ou détruits par le Titulaire.</p>
                <h3>ARTICLE 7 - LIMITATION DE RESPONSABILITE</h3>
                <p>La DPMA et l’IFREMER ne garantissent en rien que les Données seront exempts d’erreurs. Par conséquent, la DPMA et l’IFREMER déclinent toute responsabilité quant à l’utilisation qui en est faite et qui s’effectue sous la seule, pleine et entière responsabilité du Titulaire.</p>
                <p>Par conséquent, le Titulaire ne pourra en aucun cas mettre en cause la responsabilité de la DPMA et de l’IFREMER en raison d’un préjudice subi par le Titulaire du fait de l’utilisation des Données, quel qu’il soit et quel qu’en soit la cause, que le préjudice ait été prévisible ou non.</p>
                <p>En outre, la DPMA et l’IFREMER déclinent toute responsabilité sur l’utilisation du site internet et ne garantissent en rien que le site soit exempt de virus, bugs…</p>
            </article>

        </s:if>

    </body>
</html>
