/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action.authentication;

import com.google.common.collect.Iterables;
import fr.ifremer.wao.entity.ObsProgram;
import fr.ifremer.wao.entity.UserProfile;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.services.AuthenticatedWaoUser;
import fr.ifremer.wao.services.service.administration.InactiveWaoUserException;
import fr.ifremer.wao.services.service.administration.NoRoleAttributedException;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.services.service.administration.WrongCredentialsException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name="success", type="redirectAction", params={"namespace", "/${obsProgram.name().toLowerCase()}", "actionName", "news"})})
public class LoginAction
extends WaoJspActionSupport {
    private static final long serialVersionUID = 1L;
    protected transient WaoUsersService service;
    protected boolean credentialsAsked = true;
    protected String login;
    protected String password;
    protected String userProfileId;
    protected boolean userProfileAsked;
    protected Map<String, String> userProfiles;
    protected boolean acceptCguAsked;
    protected boolean cguAccepted;
    protected ObsProgram obsProgram;
    protected WaoUser waoUser;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setUserProfileId(String userProfileId) {
        this.userProfileId = userProfileId;
    }

    public void setCguAccepted(boolean cguAccepted) {
        this.cguAccepted = cguAccepted;
    }

    public void validate() {
        try {
            this.waoUser = this.service.authenticate(this.login, this.password);
            this.credentialsAsked = false;
            if (this.cguAccepted) {
                this.service.acceptCgu(this.waoUser);
            }
            if (this.waoUser.getCguAccepted() == null) {
                this.acceptCguAsked = true;
                this.addFieldError("cguAccepted", this.t("wao.ui.form.authentication.error.userMustAcceptCgu", new Object[0]));
            }
            if (this.waoUser.getUserProfile().size() == 1) {
                this.userProfileId = ((UserProfile)Iterables.getOnlyElement((Iterable)this.waoUser.getUserProfile())).getTopiaId();
            } else {
                this.userProfileAsked = true;
                this.userProfiles = new HashMap();
                for (UserProfile userProfile : this.waoUser.getUserProfile()) {
                    String label = this.t(userProfile.getUserRole().getI18nKey(), new Object[0]);
                    label = label + " " + this.t(userProfile.getObsProgram().getI18nKey(), new Object[0]);
                    if (BooleanUtils.isTrue((Boolean)userProfile.isReadOnly())) {
                        label = label + " (" + this.t("wao.ui.form.readOnly", new Object[0]) + ")";
                    }
                    this.userProfiles.put(userProfile.getTopiaId(), label);
                }
            }
        }
        catch (WrongCredentialsException e) {
            this.addFieldError("login", this.t("wao.ui.form.authentication.error.wrongCredentials", new Object[0]));
        }
        catch (NoRoleAttributedException e) {
            this.addFieldError("login", this.t("wao.ui.form.authentication.error.noRoleAttributed", new Object[0]));
        }
        catch (InactiveWaoUserException e) {
            this.addFieldError("login", this.t("wao.ui.form.authentication.error.inactiveWaoUser", new Object[0]));
        }
    }

    public String execute() {
        if (StringUtils.isNotBlank((CharSequence)this.userProfileId)) {
            UserProfile userProfile = this.waoUser.getUserProfileByTopiaId(this.userProfileId);
            AuthenticatedWaoUser authenticatedWaoUser = new AuthenticatedWaoUser(this.waoUser, userProfile);
            this.session.setAuthenticatedWaoUser(authenticatedWaoUser);
            this.obsProgram = userProfile.getObsProgram();
            return "success";
        }
        return "input";
    }

    public String getPassword() {
        return this.password;
    }

    public String getLogin() {
        return this.login;
    }

    public String getUserProfileId() {
        return this.userProfileId;
    }

    public boolean isUserProfileAsked() {
        return this.userProfileAsked;
    }

    public ObsProgram getObsProgram() {
        return this.obsProgram;
    }

    public boolean isAcceptCguAsked() {
        return this.acceptCguAsked;
    }

    public boolean isCguAccepted() {
        return this.cguAccepted;
    }

    public Map<String, String> getUserProfiles() {
        return this.userProfiles;
    }

    public boolean isCredentialsAsked() {
        return this.credentialsAsked;
    }
}

