/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action.administration;

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.services.service.administration.CompaniesService;
import fr.ifremer.wao.services.service.administration.CompanyNameMustBeUniqueException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name="success", type="redirectAction", params={"actionName", "companies"})})
public class EditCompanyAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected transient CompaniesService service;
    protected String companyId;
    protected Company company;

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public void setService(CompaniesService service) {
        this.service = service;
    }

    public void prepare() {
        this.company = StringUtils.isEmpty((CharSequence)this.companyId) ? this.service.newCompany() : this.service.getCompany(this.companyId);
    }

    public void validate() {
        try {
            this.service.preValidate(this.company);
        }
        catch (CompanyNameMustBeUniqueException e) {
            this.addFieldError("company.name", this.t("wao.ui.form.Company.error.nameMustBeUnique", new Object[0]));
        }
    }

    public String execute() {
        this.service.save(this.company);
        this.session.addMessage(this.t("wao.ui.action.save.success", new Object[0]));
        return "success";
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public Company getCompany() {
        return this.company;
    }
}

