/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.MoreObjects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.BoatsFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.BoatsFilterValues;
import fr.ifremer.wao.services.service.BoatsList;
import fr.ifremer.wao.services.service.BoatsService;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.services.service.administration.CompaniesService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class BoatsAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BoatsAction.class);
    protected transient BoatsService service;
    protected transient CompaniesService companiesService;
    protected transient SamplingPlanService samplingPlanService;
    protected int pageNumber;
    protected long firstRangePage;
    protected long lastRangePage;
    protected BoatsFilter filter;
    protected BoatsList boatList;
    protected String startBoatSelectionForSampleRowId;
    protected SampleRow startBoatSelectionForSampleRow;

    public void setService(BoatsService service) {
        this.service = service;
    }

    public BoatsFilter getFilter() {
        if (this.filter == null) {
            this.prepare();
        }
        return this.filter;
    }

    public List<Boat> getBoats() {
        return this.boatList.getBoats().getElements();
    }

    public BoatsFilterValues getFilterValues() {
        return this.boatList.getFilterValues();
    }

    public PaginationResult<Boat> getPagination() {
        return this.boatList.getBoats();
    }

    public void setStartBoatSelectionForSampleRowId(String startBoatSelectionForSampleRowId) {
        this.startBoatSelectionForSampleRowId = startBoatSelectionForSampleRowId;
    }

    public void setSamplingPlanService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    public void setCompaniesService(CompaniesService companiesService) {
        this.companiesService = companiesService;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void prepare() {
        if (this.filter == null) {
            this.filter = this.service.newBoatsFilter(this.getAuthenticatedWaoUser());
        }
        if (StringUtils.isNotBlank((CharSequence)this.startBoatSelectionForSampleRowId)) {
            this.session.setStartBoatSelectionForSampleRowId(this.startBoatSelectionForSampleRowId);
            if (log.isInfoEnabled()) {
                log.info((Object)("user " + this.getAuthenticatedWaoUser().getWaoUser() + " is starting to select a boat for sample row " + this.startBoatSelectionForSampleRowId));
            }
        }
        if (this.session.getStartBoatSelectionForSampleRowId() != null) {
            this.startBoatSelectionForSampleRow = this.samplingPlanService.getSampleRow(this.session.getStartBoatSelectionForSampleRowId());
        }
    }

    public String execute() {
        this.filter = (BoatsFilter)MoreObjects.firstNonNull((Object)this.session.getBoatsFilter(), (Object)this.filter);
        return this.applyFilter();
    }

    public String resetFilter() {
        this.filter = this.service.newBoatsFilter(this.getAuthenticatedWaoUser());
        return this.applyFilter();
    }

    public String applyFilter() {
        this.getSession().setBoatsFilter(this.filter);
        PaginationParameter pager = this.service.newBoatsPaginationParameter(this.pageNumber, 25);
        this.boatList = this.service.getBoatsList(this.getAuthenticatedWaoUser(), this.filter, pager);
        this.firstRangePage = this.getPaginationFirstPage(this.boatList.getBoats(), 10);
        this.lastRangePage = this.getPaginationLastPage(this.boatList.getBoats(), 10, this.firstRangePage);
        return "success";
    }

    public SampleRow getStartBoatSelectionForSampleRow() {
        return this.startBoatSelectionForSampleRow;
    }

    public List<Company> getAllCompanies() {
        return this.companiesService.getAllCompanies();
    }

    public long getFirstRangePage() {
        return this.firstRangePage;
    }

    public long getLastRangePage() {
        return this.lastRangePage;
    }
}

