/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web;

import com.google.common.collect.ImmutableMap;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.entity.ObsProgram;
import fr.ifremer.wao.services.AuthenticatedWaoUser;
import fr.ifremer.wao.web.WaoActionSupport;
import fr.ifremer.wao.web.WaoSession;
import fr.ifremer.wao.web.action.AbstractSamplingPlanAction;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.util.pagination.PaginationResult;

public class WaoJspActionSupport
extends WaoActionSupport {
    private static final long serialVersionUID = 1L;

    protected WaoSession getSession() {
        return this.session;
    }

    public String getInstanceDisclaimer() {
        return this.applicationConfig.getInstanceDisclaimer();
    }

    public AuthenticatedWaoUser getAuthenticatedWaoUser() {
        return this.getSession().getAuthenticatedWaoUser();
    }

    public ObsProgram getObsProgram() {
        return this.getAuthenticatedWaoUser().getObsProgram();
    }

    public boolean isObsMer() {
        return this.getObsProgram().isObsMer();
    }

    public boolean isObsVente() {
        return this.getObsProgram().isObsVente();
    }

    public String getText(Enum<?> enumeration) {
        return this.getText(enumeration.getClass().getSimpleName() + "." + enumeration.name());
    }

    public String getText(String aTextName, String defaultValue) {
        String text = super.getText(aTextName, defaultValue);
        if ("invalid.fieldvalue.filter.periodFrom".equals(aTextName)) {
            text = this instanceof AbstractSamplingPlanAction ? this.getText("wao.ui.invalidMonthFormat") : this.getText("wao.ui.invalidDateFormat");
        }
        return text;
    }

    public String formatMonth(Date date) {
        return date == null ? "" : WaoUtils.formatMonth((Locale)this.getLocale(), (Date)date);
    }

    public String formatDate(Date date) {
        return date == null ? "" : WaoUtils.formatDate((Locale)this.getLocale(), (Date)date);
    }

    public String formatDateMonth(Date date) {
        return date == null ? "" : WaoUtils.formatDateMonth((Locale)this.getLocale(), (Date)date);
    }

    public String formatDateYear(Date date) {
        return date == null ? "" : WaoUtils.formatDateYear((Locale)this.getLocale(), (Date)date);
    }

    public String formatDateTime(Date date) {
        return date == null ? "" : WaoUtils.formatDateTime((Locale)this.getLocale(), (Date)date);
    }

    public boolean isGoogleAnalyticsEnabled() {
        return this.applicationConfig.isGoogleAnalyticsEnabled();
    }

    public String getPaginationUrl(String fullUrl) {
        String paginationUrl = fullUrl.replaceAll("pageNumber=([^&])+[&]*", "");
        if (!(paginationUrl = paginationUrl.replaceAll("&amp;&amp;", "&amp;")).contains("?")) {
            paginationUrl = paginationUrl + "?";
        } else if (!paginationUrl.endsWith("?")) {
            paginationUrl = paginationUrl + "&";
        }
        paginationUrl = paginationUrl + "pageNumber=";
        return paginationUrl;
    }

    public String getOneYearAgoDatePlaceHolder() {
        return this.formatDate(DateUtils.addYears((Date)this.getNow(), (int)-1));
    }

    protected Date getNow() {
        return new Date();
    }

    protected long getPaginationFirstPage(PaginationResult<?> paginationResult, int rangeSize) {
        int pageIndex = paginationResult.getCurrentPage().getPageNumber();
        long result = pageIndex;
        long pagesNumber = paginationResult.getPageCount();
        if (pagesNumber <= (long)rangeSize || pageIndex < rangeSize) {
            return 1L;
        }
        if (pagesNumber - (long)pageIndex < (long)rangeSize) {
            result = pagesNumber - (long)rangeSize;
            if (result < 1L) {
                result = 1L;
            }
            return result;
        }
        if (pageIndex >= rangeSize) {
            result = pageIndex - rangeSize / 2;
        }
        return result;
    }

    protected long getPaginationLastPage(PaginationResult<?> paginationResult, int rangeSize, long firstPagination) {
        long result = firstPagination + (long)rangeSize;
        if (result > (long)paginationResult.getPageCount()) {
            result = paginationResult.getPageCount();
        }
        return result;
    }

    public boolean isLocaleFrench() {
        return WaoUtils.isFrench((Locale)this.getLocale());
    }

    protected boolean isSamplingPlanFullViewByDefault() {
        boolean fullView = this.getAuthenticatedWaoUser().isAdmin() || this.getAuthenticatedWaoUser().isProfessional();
        return fullView;
    }

    public boolean isContactsListFullViewByDefault() {
        boolean fullView = this.getAuthenticatedWaoUser().isAdmin() || this.getAuthenticatedWaoUser().isProfessional();
        return fullView;
    }

    public ImmutableMap<String, Object> getDefaultCookie() {
        return ImmutableMap.of((Object)"version", (Object)"4.2", (Object)"samplingPlanFullView", (Object)this.isSamplingPlanFullViewByDefault(), (Object)"contactsListFullView", (Object)this.isContactsListFullViewByDefault(), (Object)"samplingPlanDaysView", (Object)false);
    }
}

