/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web;

import com.google.common.cache.Cache;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ElligibleBoat;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.BoatsFilterValues;
import fr.ifremer.wao.services.service.BoatsFilterValuesCacheKey;
import fr.ifremer.wao.services.service.SamplingPlan;
import fr.ifremer.wao.services.service.SamplingPlanCacheKey;
import fr.ifremer.wao.services.service.Synthesis;
import fr.ifremer.wao.services.service.SynthesisCacheKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.event.TopiaEntityEvent;
import org.nuiton.topia.persistence.event.TopiaEntityListener;
import org.nuiton.topia.persistence.event.TopiaTransactionEvent;
import org.nuiton.topia.persistence.event.TopiaTransactionListener;

public class CacheInvalidationTopiaListener
implements TopiaEntityListener,
TopiaTransactionListener {
    private static final Log log = LogFactory.getLog(CacheInvalidationTopiaListener.class);
    protected Cache<SamplingPlanCacheKey, SamplingPlan> samplingPlansCache;
    protected Cache<BoatsFilterValuesCacheKey, BoatsFilterValues> boatsFilterValuesCache;
    protected Cache<SynthesisCacheKey, Synthesis> synthesesCache;
    protected Set<String> dirtySampleRowIds = new HashSet();
    protected Set<String> dirtyBoatIds = new HashSet();
    protected Set<String> dirtyContactIds = new HashSet();
    protected boolean invalidateAllSampleRows = false;
    protected boolean invalidateAllBoats = false;
    protected boolean invalidateAllContacts = false;
    @Deprecated
    protected boolean boatsFilterValuesCacheInvalidationEnabled = false;

    public CacheInvalidationTopiaListener(Cache<SamplingPlanCacheKey, SamplingPlan> samplingPlansCache, Cache<BoatsFilterValuesCacheKey, BoatsFilterValues> boatsFilterValuesCache, Cache<SynthesisCacheKey, Synthesis> synthesesCache) {
        this.samplingPlansCache = samplingPlansCache;
        this.boatsFilterValuesCache = boatsFilterValuesCache;
        this.synthesesCache = synthesesCache;
    }

    public void create(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        if (entity instanceof SampleRow) {
            this.invalidateAllSampleRows = true;
        } else if (entity instanceof ElligibleBoat) {
            ElligibleBoat elligibleBoat = (ElligibleBoat)entity;
            this.dirtyBoatIds.add(elligibleBoat.getBoat().getTopiaId());
        } else if (entity instanceof Boat) {
            this.invalidateAllBoats = true;
        } else if (entity instanceof Contact) {
            Contact contact = (Contact)entity;
            this.dirtyBoatIds.add(contact.getBoat().getTopiaId());
            this.dirtySampleRowIds.add(contact.getSampleRow().getTopiaId());
            this.invalidateAllContacts = true;
        }
    }

    public void load(TopiaEntityEvent event) {
    }

    public void update(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        if (entity instanceof SampleRow) {
            this.dirtySampleRowIds.add(entity.getTopiaId());
        } else if (entity instanceof ElligibleBoat) {
            ElligibleBoat elligibleBoat = (ElligibleBoat)entity;
            this.dirtyBoatIds.add(elligibleBoat.getBoat().getTopiaId());
        } else if (entity instanceof Boat) {
            this.dirtyBoatIds.add(entity.getTopiaId());
        } else if (entity instanceof Contact) {
            Contact contact = (Contact)entity;
            this.dirtyBoatIds.add(contact.getBoat().getTopiaId());
            this.dirtySampleRowIds.add(contact.getSampleRow().getTopiaId());
            this.dirtyContactIds.add(contact.getTopiaId());
        }
    }

    public void delete(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        if (entity instanceof SampleRow) {
            this.samplingPlansCache.invalidateAll();
        } else if (entity instanceof Contact) {
            Contact contact = (Contact)entity;
            this.dirtyBoatIds.add(contact.getBoat().getTopiaId());
            this.dirtySampleRowIds.add(contact.getSampleRow().getTopiaId());
            this.dirtyContactIds.add(contact.getTopiaId());
        }
    }

    public void commit(TopiaTransactionEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("will commit for entities " + event.getEntities()));
        }
        if (this.invalidateAllSampleRows) {
            this.samplingPlansCache.invalidateAll();
            this.synthesesCache.invalidateAll();
        } else {
            HashSet samplingPlansCacheKeysToInvalidate = new HashSet();
            for (Map.Entry entry : this.samplingPlansCache.asMap().entrySet()) {
                if (!CollectionUtils.containsAny((Collection)((SamplingPlan)entry.getValue()).getSampleRowIds(), (Collection)this.dirtySampleRowIds)) continue;
                samplingPlansCacheKeysToInvalidate.add(entry.getKey());
            }
            this.samplingPlansCache.invalidateAll(samplingPlansCacheKeysToInvalidate);
            HashSet synthesesCacheKeysToInvalidate = new HashSet();
            for (Map.Entry entry : this.synthesesCache.asMap().entrySet()) {
                if (!CollectionUtils.containsAny((Collection)((Synthesis)entry.getValue()).getSampleRowIds(), (Collection)this.dirtySampleRowIds)) continue;
                synthesesCacheKeysToInvalidate.add(entry.getKey());
            }
            this.synthesesCache.invalidateAll(synthesesCacheKeysToInvalidate);
        }
        if (this.invalidateAllBoats) {
            if (this.boatsFilterValuesCacheInvalidationEnabled) {
                this.boatsFilterValuesCache.invalidateAll();
            }
        } else {
            HashSet boatsFilterValuesCacheKeysToInvalidate = new HashSet();
            for (Map.Entry entry : this.boatsFilterValuesCache.asMap().entrySet()) {
                if (!CollectionUtils.containsAny((Collection)((BoatsFilterValues)entry.getValue()).getBoatIds(), (Collection)this.dirtyBoatIds)) continue;
                boatsFilterValuesCacheKeysToInvalidate.add(entry.getKey());
            }
            if (this.boatsFilterValuesCacheInvalidationEnabled) {
                this.boatsFilterValuesCache.invalidateAll(boatsFilterValuesCacheKeysToInvalidate);
            }
        }
        this.clear();
    }

    public void rollback(TopiaTransactionEvent event) {
        this.clear();
    }

    protected void clear() {
        this.dirtySampleRowIds.clear();
        this.dirtyBoatIds.clear();
        this.dirtyContactIds.clear();
        this.invalidateAllSampleRows = false;
        this.invalidateAllBoats = false;
        this.invalidateAllContacts = false;
    }
}

