package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.services.service.ImportErrorException;
import fr.ifremer.wao.services.service.SamplingPlanService;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import java.io.InputStream;

@Results({
        @Result(name="error", type="redirectAction", params = { "actionName", "import-sampling-plan!input" }) ,
        @Result(name="success", type="redirectAction", params = { "actionName", "sampling-plan" })
})
public class ImportSamplingPlanAction extends AbstractImportCsvAction {

    private static final long serialVersionUID = 1L;

    protected transient SamplingPlanService samplingPlanService;

    public void setService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    @Override
    protected void importCsv(InputStream csvInputStream) throws ImportErrorException {
        samplingPlanService.importSamplingPlan(getAuthenticatedWaoUser(), csvInputStream);
    }

    @Override
    protected String getSuccessMessage() {
        return t("wao.ui.import.samplingPlan.success");
    }

}
