package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.services.service.IllegalDeletionException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

/**
 * Created on 4/3/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 4.0
 */
@Results({
                 @Result(name = "error", type = "redirectAction", params = {"actionName", "edit-contact!input", "contactId", "%{contactId}"}),
                 @Result(name = "success", type = "redirectAction", params = {"actionName", "contacts"})
         })
public class DeleteContactAction extends WaoJspActionSupport {

    private static final long serialVersionUID = 1L;

    protected String contactId;

    protected transient ContactsService service;

    public void setService(ContactsService service) {
        this.service = service;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public String getContactId() {
        return contactId;
    }

    @Override
    public String execute() {

        String result;
        try {
            service.delete(contactId);

            session.addMessage(t("wao.ui.action.deleteContact.success"));

            result = SUCCESS;

        } catch (IllegalDeletionException e) {

            session.addErrorMessages(t("wao.ui.action.deleteContact.failure"));
            session.addErrorMessages(e.getExplanation(getLocale()));

            result = ERROR;
        }
        return result;
    }
}
