package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.ObjectFactory;
import fr.ifremer.wao.WaoEntityEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.Map;

public class WaoStrutsObjectFactory extends ObjectFactory {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(WaoStrutsObjectFactory.class);

    @Override
    public Object buildBean(Class clazz, Map<String, Object> extraContext) throws IllegalAccessException, InstantiationException {

        Object instance;

        if (TopiaEntity.class.isAssignableFrom(clazz)) {

            if (log.isTraceEnabled()) {
                log.trace(" new instance of " + clazz.getCanonicalName());
            }

            WaoEntityEnum waoEntityEnum =
                    WaoEntityEnum.valueOf(clazz);

            Class<? extends TopiaEntity> implementation =
                    waoEntityEnum.getImplementation();

            instance = implementation.newInstance();

        } else {

            instance = clazz.newInstance();

        }

        return instance;
    }

}
