<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@ taglib prefix="s"         uri="/struts-tags" %>
<%@ taglib prefix="sb"        uri="/struts-bootstrap-tags" %>
<%@ taglib prefix="sj"        uri="/struts-jquery-tags" %>
<%@ taglib prefix="decorator" uri="http://www.opensymphony.com/sitemesh/decorator" %>
<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <title><decorator:title default="Wao"/> - Wao</title>
        <s:if test="localeFrench">
            <sj:head locale="fr" jqueryui="true" loadAtOnce="true"/>
        </s:if>
        <s:else>
            <sj:head locale="en" jqueryui="true" loadAtOnce="true"/>
        </s:else>
        <sb:head />
        <script src="<s:url value="/moment-js-2.5.1/moment-with-langs.js" />"></script>
        <script src="<s:url value="/select2-3.4.5/select2.min.js" />"></script>
        <s:if test="localeFrench">
            <script src="<s:url value="/select2-3.4.5/select2_locale_fr.js" />"></script>
        </s:if>
        <script src="<s:url value="/bootstrap-2.3.1/bootstrap-tooltip.js" />"></script>
        <script src="<s:url value="/bootstrap-2.3.1/bootstrap-popover.js" />"></script>
        <script src="<s:url value="/spin.js-2.0.0/spin.js" />"></script>
        <script src="<s:url value="/spin.js-2.0.0/jquery.spin.js" />"></script>
        <script src="<s:url value="/bootstrap-datetimepicker-2.3.1/js/bootstrap-datetimepicker.min.js" />"></script>
        <s:if test="localeFrench">
            <script src="<s:url value="/bootstrap-datetimepicker-2.3.1/js/locales/bootstrap-datetimepicker.fr.js" />"></script>
        </s:if>
        <script src="<s:url value="/wao.js" />"></script>
        <script src="<s:url value='/endpoints-js.jsp'/>"></script>
        <link rel="stylesheet" type="text/css" href="<s:url value="/select2-3.4.5/select2.css" />" />
        <link rel="stylesheet" type="text/css" href="<s:url value="/select2-3.4.5/select2-bootstrap.css" />" />
        <link rel="stylesheet" type="text/css" href="<s:url value="/wao.css" />" media="all" />
        <link rel="stylesheet" type="text/css" href="<s:url value="/wao-screen.css" />" media="screen">
        <link rel="stylesheet" type="text/css" href="<s:url value="/css/font-awesome.min.css" />" media="screen">
        <link rel="stylesheet" type="text/css" href="<s:url value="/bootstrap-datetimepicker-2.3.1/css/bootstrap-datetimepicker.min.css" />" media="screen">
        <decorator:head />
    </head>

    <body>


        <div class="navbar">
            <div class="navbar-inner">
                <a class="brand" href="#"><span>WAO</span> <s:text name="%{obsProgram.getI18nKey()}"/></a>

                <%--<a class="brand" href="#">Wao <s:property value="%{getText(#obsProgram.getI18nKey())}" /></a>--%>
                <ul class="nav">
                    <li class="<decorator:getProperty property="page.newsMenuItemClass"/>">
                        <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="news" id="newsUrl" />
                        <s:a href="%{newsUrl}">
                            <i class="fa fa-home"></i> <s:text name="wao.ui.page.Index.title" />
                        </s:a>
                    </li>
                    <li class="<decorator:getProperty property="page.samplingPlanMenuItemClass"/>">
                        <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="sampling-plan" id="samplingPlanUrl" />
                        <s:a href="%{samplingPlanUrl}">
                            <i class="fa fa-calendar"></i> <s:text name="wao.ui.page.SamplingPlan.title" />
                        </s:a>
                    </li>
                    <s:if test="authenticatedWaoUser.authorizedToViewBoats">
                        <li class="<decorator:getProperty property="page.boatsMenuItemClass"/>">
                            <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="boats" id="boatsUrl" />
                            <s:a href="%{boatsUrl}">
                                <i class="fa fa-anchor"></i> <s:text name="wao.ui.page.Boats.title" />
                            </s:a>
                        </li>
                    </s:if>
                    <s:if test="authenticatedWaoUser.authorizedToViewContacts">
                        <li class="<decorator:getProperty property="page.contactsMenuItemClass"/>">
                            <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="contacts" id="contactsUrl" />
                            <s:a href="%{contactsUrl}">
                                <i class="fa fa-stack-exchange"></i> <s:text name="wao.ui.page.Contacts.title" />
                            </s:a>
                        </li>
                    </s:if>
                    <s:if test="authenticatedWaoUser.authorizedToViewSynthesis">
                        <li class="<decorator:getProperty property="page.synthesisMenuItemClass"/>">
                            <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="synthesis" id="synthesisUrl" />
                            <s:a href="%{synthesisUrl}">
                                <i class="fa fa-bar-chart-o"></i> <s:text name="wao.ui.page.Synthesis.title" />
                            </s:a>
                        </li>
                    </s:if>
                </ul>
                <ul class="nav pull-right">
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <s:text name="wao.ui.page.Administration.title" />
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu">
                            <decorator:getProperty property="page.administrationMenuOtherOptions"/>
                            
                            <s:if test="authenticatedWaoUser.authorizedToImportSamplingPlan">
                                <li>
                                    <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="import-sampling-plan!input" id="importSamplingPlanUrl" />
                                    <s:a href="%{importSamplingPlanUrl}">
                                        <i class="icon-upload"></i> <s:text name="wao.ui.import.samplingPlan" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToImportContacts">
                                <li>
                                    <s:url namespace="/%{obsProgram.name().toLowerCase()}" action="import-contacts!input" id="importContactsUrl" />
                                    <s:a href="%{importContactsUrl}">
                                        <i class="icon-upload"></i> <s:text name="wao.ui.import.contacts" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToUpdateReferential">
                                <li>
                                    <s:url namespace="/administration" action="referential-management" id="referentialManagementUrl" />
                                    <s:a href="%{referentialManagementUrl}">
                                        <i class="icon-upload"></i> <s:text name="wao.ui.page.ReferentialManagement.title" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToViewCompanies">
                                <li>
                                    <s:url namespace="/administration" action="companies" id="companiesUrl" />
                                    <s:a href="%{companiesUrl}">
                                        <i class="icon-briefcase"></i> <s:text name="wao.ui.page.companies.title" />
                                    </s:a>
                                </li>
                            </s:if>
                            <s:if test="authenticatedWaoUser.authorizedToViewCompanyUsers">
                                <li>
                                    <s:url namespace="/administration" action="wao-users" id="companyUsersUrl">
                                        <s:param name="companyId" value="authenticatedWaoUser.waoUser.company.topiaId" />
                                    </s:url>
                                    <s:a href="%{companyUsersUrl}">
                                        <i class="icon-user"></i>
                                        <%--<s:property value="t('wao.ui.page.waoUsers.titleForCompany', authenticatedWaoUser.waoUser.company.name)" />--%>
                                        <s:text name="wao.ui.page.waoUsers.titleForCompany">
                                            <s:param value="authenticatedWaoUser.waoUser.company.name"/>
                                        </s:text>
                                    </s:a>
                                </li>
                            </s:if>
                        </ul>
                    </li>
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            <i class="fa fa-gear"></i>
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <s:url id="changeLocaleUrl" includeParams="get">
                                    <s:param name="request_locale">
                                        <s:if test="localeFrench">
                                            en
                                        </s:if>
                                        <s:else>
                                            fr
                                        </s:else>
                                    </s:param>
                                </s:url>
                                <s:a href="%{changeLocaleUrl}">
                                    <i class="icon-flag"></i> <s:text name="wao.ui.action.changeLocale" />
                                </s:a>
                            </li>
                            <li>
                                <s:url namespace="/administration" action="edit-wao-user!input" id="editWaoUserUrl">
                                    <s:param name="waoUserId" value="%{authenticatedWaoUser.waoUser.topiaId}" />
                                </s:url>
                                <s:a href="%{editWaoUserUrl}">
                                    <i class="icon-user"></i> <s:text name="wao.ui.page.UserProfileForm.title" />
                                </s:a>
                            </li>
                            <li>
                                <s:url namespace="/authentication" action="logout" id="logoutUrl" />
                                <s:a href="%{logoutUrl}">
                                    <i class="icon-off"></i> <s:text name="wao.ui.action.logout" />
                                </s:a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>

        <main class="<decorator:getProperty property="page.mainClass"/>">
            <s:actionerror theme="bootstrap" />
            <s:actionmessage theme="bootstrap" />
            <s:fielderror theme="bootstrap" />
            <div id="notifications"></div>
            <decorator:body />
        </main>

        <footer class="hidden-print<s:if test="%{instanceDisclaimer != null}"> disclaimer-displayed</s:if>" >
            <ul>
                <li>
                    <s:text name="wao.ui.layout.userDescription">
                        <s:param value="authenticatedWaoUser.waoUser.fullName"/>
                        <s:param value="authenticatedWaoUser.waoUser.company.name"/>
                        <s:param value="getText(authenticatedWaoUser.userRole)"/>
                    </s:text>
                </li>
                <li>
                    <a href="http://maven-site.forge.codelutin.com/wao/" target="_blank">
                        WAO
                    </a>
                </li>
                <li>
                    <a href="http://forge.codelutin.com/projects/wao/news" target="_blank">
                        <%@include file="version.jsp" %>
                    </a>
                </li>
                <s:if test="obsMer">
                    <li>
                        <a href="mailto:harmonie@ifremer.fr" title="Contacter un responsable Obsmer">
                            Obsmer
                        </a>
                    </li>
                </s:if>
                <li>
                    <a href="http://sih.ifremer.fr/" title="Page d'accueil du SIH" target="_blank">
                        Ifremer SIH
                    </a>
                </li>
                <li>
                    <a href="http://forms.ifremer.fr/sih/wao-demande-dintervention-sur-le-site/" title="Page d'accueil du SIH" target="_blank">
                        Demande d’intervention
                    </a>
                </li>
                <li>
                    <a href="http://www.gnu.org/licenses/agpl.html" title="License AGPL v3" target="_blank">
                        AGPLv3
                    </a>
                </li>
                <li>
                    Copyright 2009-2014
                    <a href="http://www.ifremer.fr" title="Ifremer" target="_blank">Ifremer</a>,
                    <a href="http://www.codelutin.com" title="Code Lutin" target="_blank">Code Lutin</a>
                </li>
            </ul>
            <s:if test="obsMer">
                <small class="cnil">
                    <s:text name="wao.ui.disclaimer" />
                </small>
            </s:if>
        </footer>

        <s:if test="%{instanceDisclaimer != null}">
            <div id="instance-disclaimer">
                <div>
                    <s:property value="instanceDisclaimer" />
                </div>
            </div>
        </s:if>

        <s:if test="googleAnalyticsEnabled">
            <!-- Script for Google Analytics -->
            <script>

              var _gaq = _gaq || [];
              _gaq.push(['_setAccount', 'UA-12982015-1']);
              _gaq.push(['_trackPageview']);

              (function() {
                var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
                ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
                var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
              })();

            </script>
        </s:if>

    </body>
</html>
