<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
    <head>
        <title>
            <s:if test="updateSampleRowCommand.creation">
                <s:text name="wao.ui.sampleRow.creation" />
            </s:if>
            <s:else>
                <s:property value="t('wao.ui.sampleRow.edition', updateSampleRowCommand.sampleRow.code)" />
            </s:else>
        </title>
        <script>

            $(document).ready(function() {

                var expectedObservationsByMonths = <s:property value="updateSampleRowCommand.expectedObservationsByMonths" escapeHtml="false" />;

                var $expectedObservationsByMonthsTable = $('#expectedObservationsByMonthsTable');
                var $expectedObservationsByMonthsTableHead = $expectedObservationsByMonthsTable.find('thead');
                var $expectedObservationsByMonthsTableBody = $expectedObservationsByMonthsTable.find('tbody');
                var $periodBeginInput = $('input[name="updateSampleRowCommand.sampleRow.periodBegin"]');
                var $periodEndInput = $('input[name="updateSampleRowCommand.sampleRow.periodEnd"]');

                var updateExpectedObservationsByMonthsTable = function() {
                    $expectedObservationsByMonthsTableHead.empty();
                    $expectedObservationsByMonthsTableBody.empty();
                    var periodBegin = moment($periodBeginInput.val(), 'MM/YYYY');
                    var periodEnd = moment($periodEndInput.val(), 'MM/YYYY');
                    if (periodBegin.isValid() && periodEnd.isValid()) {
                        if (periodBegin > periodEnd) {
                            $periodEndInput.val($periodBeginInput.val());
                            periodEnd = moment($periodEndInput.val(), 'MM/YYYY');
                        }
                        var months = [];
                        do {
                           months.push(periodBegin.format('YYYYMM'));
                           periodBegin.add('months', 1);
                        } while (periodBegin <= periodEnd);
                        $expectedObservationsByMonthsTableHead.append('<tr></tr>');
                        $expectedObservationsByMonthsTableBody.append('<tr></tr>');
                        $(months).each(function (index, month) {
                            var newInput = '    <td>'
                                         + '        ' + moment(month, 'YYYYMM').format('MM/YYYY')
                                         + '    </td>';
                            $expectedObservationsByMonthsTableHead.find('tr').append(newInput);
                        });
                        $(months).each(function (index, month) {
                            var value = "";
                            if (expectedObservationsByMonths[month] != null) {
                                value = expectedObservationsByMonths[month];
                            }
                            var newInput = '    <td>'
                                         + '        <input type="number" name="expectedObservationsByMonths[\'' + month + '\']" value="' + value  + '" class="input-small" />'
                                         + '    </td>';
                            $expectedObservationsByMonthsTableBody.find('tr').append(newInput);
                        });
                    }
                }

                updateExpectedObservationsByMonthsTable();

                $periodBeginInput.change(updateExpectedObservationsByMonthsTable);
                $periodEndInput.change(updateExpectedObservationsByMonthsTable);


                $('#delete-sample-row-link').click(function (e) {
                    if ( ! confirm("<s:text name="wao.ui.action.deleteSampleRow.confirm"/>")) {
                        e.preventDefault();
                    }
                });

            });

        </script>
        
        <content tag="mainClass">form</content>
    </head>


    <s:if test="updateSampleRowCommand.observationAlreadyStarted">
        <div class="alert">
            <s:text name="wao.ui.form.SampleRow.warn.observationAlreadyStarted" />
        </div>
    </s:if>

    <s:form>

        <h1>
            <s:if test="updateSampleRowCommand.creation">
                <s:text name="wao.ui.sampleRow.creation" />
            </s:if>
            <s:else>
                <s:property value="t('wao.ui.sampleRow.edition', updateSampleRowCommand.sampleRow.code)" />
            </s:else>
        </h1>

        <s:hidden name="sampleRowId" value="%{sampleRowId}" />

        <fieldset>

            <legend><s:text name="wao.ui.field.SampleRow.profession" /></legend>

            <s:textfield name="updateSampleRowCommand.sampleRow.profession.libelle"
                         label="%{getText('wao.ui.field.SampleRow.libelle')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted"
                         cssClass="input-xxlarge" />

            <s:textfield name="updateSampleRowCommand.sampleRow.profession.size"
                         label="%{getText('wao.ui.field.SampleRow.size')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted"
                         inputAppend="m"
                         cssClass="input-small" />

            <s:textfield name="updateSampleRowCommand.sampleRow.profession.meshSize"
                         label="%{getText('wao.ui.field.SampleRow.meshSize')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted"
                         inputAppend="mm"
                         cssClass="input-small" />

            <s:textfield name="updateSampleRowCommand.sampleRow.profession.species"
                         label="%{getText('wao.ui.field.SampleRow.species')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted"
                         cssClass="input-xxlarge" />

            <s:textfield name="updateSampleRowCommand.sampleRow.profession.other"
                         label="%{getText('wao.ui.field.SampleRow.other')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted"
                         cssClass="input-xxlarge" />

            <s:select name="updateSampleRowCommand.dcf5CodesIds"
                      label="%{getText('wao.ui.field.SampleRow.dcf5Codes')}"
                      disabled="updateSampleRowCommand.observationAlreadyStarted"
                      list="updateSampleRowCommand.allDcf5Codes"
                      listValue="%{value.code}"
                      cssClass="input-xxlarge select2"
                      multiple="true"
                      />

        </fieldset>

        <fieldset>

            <legend><s:text name="wao.ui.field.SampleRow.fishingZones" /></legend>

            <s:select name="updateSampleRowCommand.fishingZoneIds"
                      label="%{getText('wao.ui.field.SampleRow.fishingZones')}"
                      disabled="updateSampleRowCommand.observationAlreadyStarted"
                      list="updateSampleRowCommand.allFishingZones"
                      listValue="%{value.code}"
                      multiple="true"
                      cssClass="input-xxlarge"
                      />

            <s:textfield name="updateSampleRowCommand.sampleRow.fishingZonesInfos" label="%{getText('wao.ui.field.SampleRow.fishingZonesInfos')}" cssClass="input-xxlarge" />

        </fieldset>

        <fieldset>

            <legend><s:text name="wao.ui.form.SampleRow.program" /></legend>

            <s:textfield name="updateSampleRowCommand.sampleRow.programName"
                         label="%{getText('wao.ui.field.SampleRow.programName')}"
                         disabled="updateSampleRowCommand.observationAlreadyStarted" />
            <s:textfield name="updateSampleRowCommand.sampleRow.periodBegin"
                         label="%{getText('wao.ui.field.SampleRow.periodBegin')}"
                         placeholder="04/2014"
                         cssClass="input-small" />
            <s:textfield name="updateSampleRowCommand.sampleRow.periodEnd"
                         label="%{getText('wao.ui.field.SampleRow.periodEnd')}"
                         placeholder="03/2015"
                         cssClass="input-small" />


            <div class="control-group">
                <label class="control-label"><s:text name="wao.ui.samplingPlan.effort" /></label>
                <div class="controls">
                    <table id="expectedObservationsByMonthsTable">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>


        </fieldset>

        <fieldset>

            <legend><s:text name="wao.ui.form.SampleRow.others" /></legend>

            <s:if test="updateSampleRowCommand.creation">
                <s:textfield name="updateSampleRowCommand.code"
                             label="%{getText('wao.ui.field.SampleRow.code')}"
                             disabled="updateSampleRowCommand.observationAlreadyStarted"
                             cssClass="input-small" />
            </s:if>

            <s:select name="updateSampleRowCommand.companyId"
                      label="%{getText('wao.ui.field.SampleRow.company')}"
                      disabled="updateSampleRowCommand.observationAlreadyStarted"
                      list="updateSampleRowCommand.allCompanies"
                      listValue="%{value.name}"
                      cssClass="input-xxlarge"
                      />

            <s:if test="updateSampleRowCommand.sampleRow.obsProgram.obsMer">

                <s:textfield type="number" name="updateSampleRowCommand.sampleRow.nbObservants" label="%{getText('wao.ui.field.SampleRow.nbObservants')}" inputAppend="%{getText('wao.ui.unit.observers')}" cssClass="input-small"/>

                <%-- XXX brendan 19/05/14 ne pas mettre type="number" car avec le formatter qui mets la valeur avec ',' on a pas la valeur quand on modifie une ligne --%>
                <s:textfield name="updateSampleRowCommand.sampleRow.averageTideTime" label="%{getText('wao.ui.field.SampleRow.averageTideTime')}" inputAppend="%{getText('wao.ui.unit.days')}" cssClass="input-small"/>
                <s:textfield name="updateSampleRowCommand.sampleRow.appliedCoverageRate" label="%{getText('wao.ui.field.SampleRow.appliedCoverageRate')}" inputAppend="%" cssClass="input-small"/>

            </s:if>

            <s:if test="updateSampleRowCommand.sampleRow.obsProgram.obsVente">

                <s:textfield type="number" name="updateSampleRowCommand.sampleRow.averageObservationsCount" label="%{getText('wao.ui.field.SampleRow.averageObservationsCount')}" inputAppend="%{getText('wao.ui.unit.observations')}" cssClass="input-small"/>

            </s:if>

            <s:textarea name="updateSampleRowCommand.elligibleBoatImmatriculations" label="%{getText('wao.ui.field.SampleRow.elligibleBoat')}" />

            <s:textarea name="updateSampleRowCommand.sampleRow.comment" label="%{getText('wao.ui.field.SampleRow.comment')}" />

        </fieldset>

        <s:if test=" ! updateSampleRowCommand.creation">

            <fieldset>

                <legend><s:text name="wao.ui.form.editComment" /></legend>

                <s:text name="wao.ui.form.editionAuthor" /> <s:property value="updateSampleRowCommand.sampleRowLog.author.fullName" />

                <s:textarea name="updateSampleRowCommand.sampleRowLog.comment" label="%{getText('wao.ui.form.editComment')}" requiredLabel="true" />

            </fieldset>

        </s:if>

        <div class="form-actions">
            <s:url action="sampling-plan" id="samplingPlanUrl" />
            <s:a href="%{samplingPlanUrl}" cssClass="btn">
                <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.cancel" />
            </s:a>
            <s:submit type="button" cssClass="btn">
                <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
            </s:submit>
            <s:if test=" ! updateSampleRowCommand.creation">
                <s:url action="delete-sample-row" id="deleteSampleRowUrl">
                    <s:param name="sampleRowId" value="sampleRowId" />
                </s:url>
                <s:a href="%{deleteSampleRowUrl}" cssClass="btn pull-right" id="delete-sample-row-link">
                    <i class="icon-trash"></i> <s:text name="wao.ui.action.deleteSampleRow" />
                </s:a>
            </s:if>
        </div>

    </s:form>

</html>

