<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>
    <head>
        <title>
            <s:if test="companyId == null">
                <s:text name="wao.ui.form.Company.title.creation" />
            </s:if>
            <s:else>
                <s:property value="%{t('wao.ui.form.Company.title.edition', company.name)}" />
            </s:else>
        </title>
        <content tag="mainClass">form</content>
    </head>

    <s:form>

        <h1>
            <s:if test="companyId == null">
                <s:text name="wao.ui.form.Company.title.creation" />
            </s:if>
            <s:else>
                <s:property value="%{t('wao.ui.form.Company.title.edition', company.name)}" />
            </s:else>
        </h1>

        <s:hidden name="companyId" value="%{companyId}" />

        <s:textfield name="company.name" label="%{getText('wao.ui.field.Company.name')}" requiredLabel="true" cssClass="input-xlarge" />
        <s:textfield name="company.address1" label="%{getText('wao.ui.field.Company.address1')}" cssClass="input-xlarge" />
        <s:textfield name="company.address2" label="%{getText('wao.ui.field.Company.address2')}" cssClass="input-xlarge" />
        <s:textfield name="company.postalCode" label="%{getText('wao.ui.field.Company.postalCode')}" cssClass="input-small" />
        <s:textfield name="company.city" label="%{getText('wao.ui.field.Company.city')}" cssClass="input-xlarge" />
        <s:textfield name="company.phoneNumber" label="%{getText('wao.ui.field.Company.phoneNumber')}" size="14" />
        <s:textfield type="email" name="company.email" label="%{getText('wao.ui.field.Company.email')}" cssClass="input-xlarge" />

        <s:checkbox name="company.active" label="%{getText('wao.ui.field.Company.active')}" />

        <div class="form-actions">
            <s:url action="companies" id="companiesUrl" />
            <s:a href="%{companiesUrl}" cssClass="btn">
                <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.cancel" />
            </s:a>

            <s:submit type="button" cssClass="btn">
                <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
            </s:submit>
        </div>

    </s:form>

</html>
