/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.converter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.xwork2.conversion.TypeConversionException;
import fr.ifremer.wao.WaoUtils;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;

public abstract class AbstractDateConverter
extends StrutsTypeConverter {
    private static final Log log = LogFactory.getLog(AbstractDateConverter.class);

    protected abstract Date parse(Locale var1, String var2) throws ParseException;

    protected abstract String format(Locale var1, Date var2);

    public Date convertFromString(Map map, String[] strings, Class aClass) {
        if (strings.length == 1) {
            Date parsedValue;
            String string = strings[0];
            if (StringUtils.isEmpty((CharSequence)string)) {
                parsedValue = null;
            } else {
                Locale locale = (Locale)map.get("com.opensymphony.xwork2.ActionContext.locale");
                Preconditions.checkNotNull((Object)locale, (Object)"No locale found in ActionContext");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("to convert date, will use locale " + locale.toLanguageTag()));
                }
                if (!ImmutableSet.of((Object)Locale.FRENCH, (Object)Locale.ENGLISH).contains((Object)locale)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("locale " + locale + " is not french nor english, will default to french"));
                    }
                    locale = Locale.FRENCH;
                }
                try {
                    parsedValue = this.parse(locale, string);
                }
                catch (ParseException e) {
                    locale = WaoUtils.isFrench((Locale)locale) ? Locale.ENGLISH : Locale.FRENCH;
                    try {
                        parsedValue = this.parse(locale, string);
                    }
                    catch (ParseException e1) {
                        throw new TypeConversionException("strings=" + Arrays.toString(strings));
                    }
                }
            }
            return parsedValue;
        }
        throw new TypeConversionException("strings=" + Arrays.toString(strings));
    }

    public String convertToString(Map map, Object o) {
        String str;
        if (o == null) {
            str = "";
        } else if (o instanceof Date) {
            Date date = (Date)o;
            Locale locale = (Locale)map.get("com.opensymphony.xwork2.ActionContext.locale");
            Preconditions.checkNotNull((Object)locale, (Object)"No locale found in ActionContext");
            str = this.format(locale, date);
        } else {
            throw new UnsupportedOperationException("cannot convert to month " + o);
        }
        return str;
    }
}

