/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Preconditions;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.BoatDetails;
import fr.ifremer.wao.services.service.BoatsService;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.List;

public class BoatDetailsAction
extends WaoJspActionSupport {
    private static final long serialVersionUID = 1L;
    protected transient BoatsService service;
    protected transient SamplingPlanService samplingPlanService;
    protected String companyId;
    protected String boatId;
    protected BoatDetails boatDetails;
    protected SampleRow startBoatSelectionForSampleRow;
    private List<SampleRow> sampleRowsToSetElligible;

    public void setService(BoatsService service) {
        this.service = service;
    }

    public void setSamplingPlanService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setBoatId(String boatId) {
        this.boatId = boatId;
    }

    public String execute() {
        Preconditions.checkState((boolean)this.getAuthenticatedWaoUser().isAuthorizedToViewBoatDetails(this.companyId));
        this.boatDetails = this.service.getBoatDetails(this.getObsProgram(), this.boatId, this.companyId);
        String startBoatSelectionForSampleRowId = this.session.getStartBoatSelectionForSampleRowId();
        if (startBoatSelectionForSampleRowId != null) {
            this.startBoatSelectionForSampleRow = this.samplingPlanService.getSampleRow(startBoatSelectionForSampleRowId);
        }
        this.sampleRowsToSetElligible = this.samplingPlanService.getUnfinishedSampleRows(this.getAuthenticatedWaoUser(), this.companyId);
        return "success";
    }

    public BoatDetails getBoatDetails() {
        return this.boatDetails;
    }

    public SampleRow getStartBoatSelectionForSampleRow() {
        return this.startBoatSelectionForSampleRow;
    }

    public List<SampleRow> getSampleRowsToSetElligible() {
        return this.sampleRowsToSetElligible;
    }
}

