/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Objects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.SampleRowsFilter;
import fr.ifremer.wao.services.service.SampleRowsFilterValues;
import fr.ifremer.wao.services.service.SamplingPlan;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.i18n.I18n;

public abstract class AbstractSamplingPlanAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected transient SamplingPlanService samplingPlanService;
    protected SampleRowsFilter filter;
    protected SamplingPlan samplingPlan;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");

    public void setSamplingPlanService(SamplingPlanService samplingPlanService) {
        this.samplingPlanService = samplingPlanService;
    }

    public SampleRowsFilter getFilter() {
        if (this.filter == null) {
            this.prepare();
        }
        return this.filter;
    }

    public void prepare() {
        if (this.filter == null) {
            this.filter = this.samplingPlanService.newSampleRowsFilter(this.getAuthenticatedWaoUser());
        }
    }

    public void validate() {
        if (this.filter.getPeriodFrom() != null && this.filter.getPeriodTo() != null && this.filter.getPeriodTo().before(this.filter.getPeriodFrom())) {
            this.addFieldError("filter.periodTo", I18n.l((Locale)this.getLocale(), (String)"wao.ui.periodToMustBeAfterPeriodFrom", (Object[])new Object[0]));
        }
    }

    public String execute() {
        this.filter = (SampleRowsFilter)Objects.firstNonNull((Object)this.session.getSampleRowsFilter(), (Object)this.filter);
        return this.applyFilter();
    }

    public String resetFilter() {
        this.filter = this.samplingPlanService.newSampleRowsFilter(this.getAuthenticatedWaoUser());
        return this.applyFilter();
    }

    public String applyFilter() {
        this.getSession().setSampleRowsFilter(this.filter);
        this.samplingPlan = this.samplingPlan();
        return "success";
    }

    protected abstract SamplingPlan samplingPlan();

    public SamplingPlan getSamplingPlan() {
        return this.samplingPlan;
    }

    public String getSampleRowToHighlightId() {
        return this.getSession().getSampleRowToHighlightId();
    }

    public SampleRowsFilterValues getFilterValues() {
        SampleRowsFilterValues filterValues = this.getSamplingPlan().getFilterValues();
        return filterValues;
    }

    public boolean isFullView() {
        boolean fullView = this.getAuthenticatedWaoUser().isAdmin() || this.getAuthenticatedWaoUser().isProfessional();
        return fullView;
    }

    public boolean isCurrentMonth(Date month) {
        String currentStr = this.dateFormat.format(this.getNow());
        String monthStr = this.dateFormat.format(month);
        return currentStr.equals(monthStr);
    }

    public String getFilterPeriodFromPlaceholder() {
        String placeholder = this.formatMonth(DateUtils.addMonths((Date)this.getNow(), (int)1));
        return placeholder;
    }

    public String getFilterPeriodToPlaceholder() {
        String placeholder = this.formatMonth(DateUtils.addYears((Date)this.getNow(), (int)1));
        return placeholder;
    }
}

