package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.services.service.administration.CompaniesService;
import fr.ifremer.wao.services.service.administration.CompanyNameMustBeUniqueException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results({
        @Result(name="success", type="redirectAction", params = { "actionName", "companies" })
})
public class EditCompanyAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient CompaniesService service;

    protected String companyId;

    protected Company company;

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public void setService(CompaniesService service) {
        this.service = service;
    }

    @Override
    public void prepare() {
        if (StringUtils.isEmpty(companyId)) {
            company = service.newCompany();
        } else {
            company = service.getCompany(companyId);
        }
    }

    @Override
    public void validate() {

        try {
            service.preValidate(company);
        } catch (CompanyNameMustBeUniqueException e) {
            addFieldError("company.name", t("wao.ui.form.Company.error.nameMustBeUnique"));
        }

    }

    @Override
    public String execute() {

        service.save(company);

        session.addMessage(t("wao.ui.action.save.success"));

        return SUCCESS;

    }

    public String getCompanyId() {
        return companyId;
    }

    public Company getCompany() {
        return company;
    }

}
