package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.News;
import fr.ifremer.wao.services.service.administration.NewsService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

@Results({
        @Result(name="success", type="redirectAction", params = { "actionName", "news" })
})
public class EditNewsAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected static final Whitelist WHITE_LIST = Whitelist.basicWithImages().addTags("h1", "h2", "h3");

    protected transient NewsService service;

    protected String newsId;

    protected News news;

    public void setService(NewsService service) {
        this.service = service;
    }

    public void setNewsId(String newsId) {
        this.newsId = newsId;
    }

    public void setNews(News news) {
        this.news = news;
    }

    @Override
    public void prepare() {
        if (StringUtils.isEmpty(newsId)) {
            news = service.newNews(getAuthenticatedWaoUser());
        } else {
            news = service.getNews(newsId);
        }
    }

    @Override
    public String execute() {

        //filtrage de news
        String clean = Jsoup.clean(news.getContent(), WHITE_LIST);
        news.setContent(clean);

        service.save(news);

        addActionMessage(t("wao.ui.action.createNews.success"));

        return SUCCESS;

    }

    public String getNewsId() {
        return newsId;
    }

    public News getNews() {
        return news;
    }

}
