<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<content tag="synthesisMenuItemClass">active</content>

<html>

    <head>
        <title>
            <s:text name="wao.ui.page.Synthesis.title"/>
        </title>

        <script type="text/javascript">

            $(document).ready(function() {

                var contactsFilterMappings = [
                    <s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
                        {
                            filterName: 'sampleRowFilter.companyIds',
                            filterLabel: "<s:text name="wao.ui.entity.Company"/>",
                            filterValuesField: 'sampleRowsFilterValues.companies',
                        },
                    </s:if>
                    {
                        filterName: 'sampleRowFilter.sampleRowCodes',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.code"/>",
                        filterValuesField: 'sampleRowsFilterValues.sampleRowCodes',
                    },
                    {
                        filterName: 'sampleRowFilter.programNames',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.programName"/>",
                        filterValuesField: 'sampleRowsFilterValues.programNames',
                    },
                    {
                        filterName: 'sampleRowFilter.fishingZoneFacadeNames',
                        filterLabel: "<s:text name="wao.ui.field.FishingZone.facadeName"/>",
                        filterValuesField: 'sampleRowsFilterValues.fishingZoneFacadeNames',
                    },
                    {
                        filterName: 'sampleRowFilter.fishingZoneSectorNames',
                        filterLabel: "<s:text name="wao.ui.field.FishingZone.sectorName"/>",
                        filterValuesField: 'sampleRowsFilterValues.fishingZoneSectorNames',
                    },
                    {
                        filterName: 'sampleRowFilter.fishingGearDcfIds',
                        filterLabel: "<s:text name="wao.ui.entity.fishingGearDCF"/>",
                        filterValuesField: 'sampleRowsFilterValues.fishingGearDcfs',
                    },
                    {
                        filterName: 'sampleRowFilter.targetSpeciesDcfIds',
                        filterLabel: "<s:text name="wao.ui.entity.targetSpeciesDCF"/>",
                        filterValuesField: 'sampleRowsFilterValues.targetSpeciesDcfs',
                    },
                    <s:if test="obsVente">
                        {
                            filterName: 'sampleRowFilter.terrestrialDistrictIds',
                            filterLabel: "<s:text name="wao.ui.field.SampleRow.terrestrialLocation"/>",
                            filterValuesField: 'sampleRowsFilterValues.terrestrialDistricts'
                        },
                    </s:if>
                    <s:if test="authenticatedWaoUser.authorizedToFilterOnBoats">
                        {
                            filterName: 'boatFilter.boatIds',
                            filterLabel: "<s:text name="wao.ui.entity.Boat"/>",
                            filterValuesField: 'boatsFilterValues.boats',
                            minimumInputLength: 3
                        },
                    </s:if>
                    {
                        filterName: 'boatFilter.districtIds',
                        filterLabel: "<s:text name="wao.ui.field.Boat.district.long"/>",
                        filterValuesField: 'boatsFilterValues.districts'
                    },
                    <s:if test="obsVente">
                        {
                            filterName: 'sampleRowFilter.samplingStrategies',
                            filterLabel: "<s:text name="wao.ui.field.SampleRow.samplingStrategy"/>",
                            filterValuesField: 'sampleRowsFilterValues.samplingStrategies'
                        },
                        {
                            filterName: 'actualSamplingStrategies',
                            filterLabel: "<s:text name="wao.ui.field.Contact.samplingStrategy"/>",
                            filterValuesField: 'actualSamplingStrategies'
                        },
                        {
                            filterName: 'completeSamplings',
                            filterLabel: "<s:text name="wao.ui.field.Contact.completeSampling"/>",
                            filterValuesField: 'completeSamplings'
                        },
                    </s:if>
                    {
                        filterName: 'observerIds',
                        filterLabel: "<s:text name="wao.ui.misc.observer"/>",
                        filterValuesField: 'observers'
                    }
                ];

                filter = <s:property value="filter" escapeHtml="false"/>;

                contactsFilterController2 = new FilterController2(contactsFilterMappings, filter, WAO.CONTACTS_FILTER_VALUES_JSON_URL, $('#synthesis-filters-form fieldset.extra-filters'));
                contactsFilterController2.init();

            });

        </script>
    </head>

    <content tag="mainClass">large syntheses</content>

    <s:form method="GET" id="synthesis-filters-form" cssClass="filters-form">

        <fieldset>

            <s:textfield name="filter.periodFrom"
                         label="%{getText('wao.ui.form.periodFrom')}"
                         placeholder="%{getFilterPeriodFromPlaceholder()}"
                         cssClass="input-small"/>

            <s:textfield name="filter.periodTo"
                         label="%{getText('wao.ui.form.period.to')}"
                         placeholder="%{getFilterPeriodToPlaceholder()}"
                         cssClass="input-small"/>

        </fieldset>

        <fieldset class="extra-filters">

        </fieldset>

        <fieldset>

            <s:if test="obsMer">

                <s:checkbox name="filter.mammalsObservationOnly"
                            label="%{getText('wao.ui.misc.observations')}"/>

                <s:checkbox name="filter.mammalsCaptureOnly"
                            label="%{getText('wao.ui.field.Contact.mammalsCapture')}"/>

            </s:if>

            <s:checkbox name="filter.commentDefinedOnly"
                        label="%{getText('wao.ui.field.Contact.comment')}"/>

            <s:checkbox name="filter.commentCompanyDefinedOnly"
                        label="%{getText('wao.ui.field.Contact.commentCompany')}"/>

            <s:checkbox name="filter.commentAdminDefinedOnly"
                        label="%{getText('wao.ui.field.Contact.commentAdmin')}"/>

            <s:checkbox name="filter.realVsEstimated"
                        label="%{getText('wao.ui.form.realTides.description')}"/>

        </fieldset>

        <div class="form-actions">

            <s:submit type="button" action="synthesis!applyFilter" cssClass="btn btn-primary">
                <i class="icon-filter"></i> <s:text name="wao.ui.action.filter"/>
            </s:submit>

            <s:submit type="button" action="synthesis!resetFilter" cssClass="btn">
                <i class="icon-trash"></i> <s:text name="wao.ui.action.reset"/>
            </s:submit>

        </div>

    </s:form>

    <s:if test="synthesis.empty">
        <s:text name="wao.ui.synthesis.empty"/>
    </s:if>
    <s:else>

        <article>
            <h2>
                <s:text name="SynthesisId.GRAPH_SAMPLING"/>
            </h2>

            <s:property value="synthesis.expectedVsActualObservationsByMonthsChart" escapeHtml="false"/>
        </article>

        <article>
            <h2>
                <s:text name="SynthesisId.GRAPH_BOARDING"/>
            </h2>

            <s:property value="synthesis.boardingBoatsChart" escapeHtml="false"/>

            <p>
                <s:text name="wao.ui.synthesis.boarding.description"/>
            </p>

            <p>
                <s:text name="wao.ui.synthesis.boarding.mostUsedBoat">
                    <s:param value="%{synthesis.maxBoardingValue}"/>
                    <s:param value="%{synthesis.maxBoardingBoat.name}"/>
                    <s:param value="%{synthesis.maxBoardingBoat.immatriculation}"/>
                </s:text>
            </p>

            <p>
                <s:text name="wao.ui.synthesis.boarding.boardingCount">
                    <s:param value="%{synthesis.invalidBoardingsCount}"/>
                    <s:param value="%{synthesis.boardingsCount}"/>
                    <%--
                    <s:param value="%{synthesis.validBoardingsCount}"/>
                    --%>
                </s:text>
            </p>

        </article>

        <s:if test="obsMer">

            <article>
                <h2>
                    <s:text name="SynthesisId.IND_COMPLIANCE_BOARDING"/>
                </h2>

                <table class="table">
                    <thead>
                        <tr>
                            <th>
                                <s:text name="wao.ui.entity.Company"/>
                            </th>
                            <th>
                                <s:text name="wao.ui.synthesis.complianceBoarding.description"/>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <s:iterator value="synthesis.companySynthesesOrderedByName">
                            <tr>
                                <td>
                                    <s:property value="companyName"/>
                                </td>
                                <td>
                                    <s:property value="complianceBoardingIndicator * 100"/> %
                                </td>
                            </tr>
                        </s:iterator>
                    </tbody>
                </table>

            </article>

        </s:if>

        <article>
            <h2>
                <s:text name="SynthesisId.IND_CONTACT_STATE"/>
            </h2>

            <table class="table">
                <thead>
                    <tr>
                        <th>
                            <s:text name="wao.ui.entity.Company"/>
                        </th>
                        <s:iterator value="synthesis.companySynthesesOrderedByName.iterator.next().contactsStatesStatistics.keySet()" var="contactState">
                            <th>
                                <s:text name="%{#contactState.i18nKey}"/>
                            </th>
                        </s:iterator>
                        <th>
                            <s:text name="wao.ui.misc.total"/>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <s:iterator value="synthesis.companySynthesesOrderedByName">
                        <tr>
                            <td>
                                <s:property value="companyName"/>
                            </td>
                            <s:iterator value="contactsStatesStatistics">
                                <td>
                                    <s:property value="value"/>
                                    <s:set name="percentage" value="%{value.doubleValue() / contactsCount * 100}" />
                                    (<s:property value="#percentage"/> %)
                                </td>
                            </s:iterator>
                            <td>
                                <s:property value="contactsCount"/>
                            </td>
                        </tr>
                    </s:iterator>
                </tbody>
            </table>

        </article>

        <article>
            <h2>
                <s:text name="SynthesisId.IND_ALLEGRO_REACTIVITY"/>
            </h2>

            <table class="table">
                <thead>
                    <tr>
                        <th>
                            <s:text name="wao.ui.entity.Company"/>
                        </th>
                        <th>
                            <s:text name="wao.ui.synthesis.allegroReactivity.title"/>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <s:iterator value="synthesis.companySynthesesOrderedByName">
                        <tr>
                            <td>
                                <s:property value="companyName"/>
                            </td>
                            <td<s:if test="dataInputDateReactivityHigh"> class="lower-than-expected"</s:if>>
                                <s:property value="dataInputDateReactivity"/>
                                <s:text name="wao.ui.unit.days"/>
                            </td>
                        </tr>
                    </s:iterator>
                </tbody>
            </table>

            <p>
                <s:text name="wao.ui.synthesis.allegroReactivity.description"/>
            </p>

        </article>

        <s:if test="obsMer">

            <article>

                <h2>
                    <s:text name="SynthesisId.IND_DATA_RELIABILITY"/>
                </h2>

                <table class="table">
                    <thead>
                        <tr>
                            <th>
                                <s:text name="wao.ui.entity.Company"/>
                            </th>
                            <th>
                                <s:text name="wao.ui.synthesis.dataReliability.description"/>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <s:iterator value="synthesis.companySynthesesOrderedByName">
                            <tr>
                                <td>
                                    <s:property value="companyName"/>
                                </td>
                                <td>
                                    <s:property value="dataReliabilityRatio * 100"/> %
                                </td>
                            </tr>
                        </s:iterator>
                    </tbody>
                </table>

            </article>

        </s:if>

    </s:else>


</html>
