<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<content tag="newsMenuItemClass">active</content>

<html>

    <head>

    </head>

    <content tag="mainClass">home</content>

    <s:if test="authenticatedWaoUser.authorizedToCreateNews">
        <content tag="administrationMenuOtherOptions">
            <li>
                <s:url action="edit-news!input" id="createNewsUrl"/>
                <s:a href="%{createNewsUrl}">
                    <i class="fa fa-plus-square"></i> <s:text name="wao.ui.action.createNews"/>
                </s:a>
            </li>
        </content>
    </s:if>

    <div class="buttons-area">
    </div>

    <s:iterator value="recentNews" var="aRecentNews">

        <div class="news">
            <h2>
                <s:property value="title" />
            </h2>

            <s:property value="content" escapeHtml="false" />

            <p class="publication">
                <s:if test="fromAdmin">
                    <s:text name="wao.ui.publishedByProgram" />
                </s:if>
                <s:else>
                    <s:text name="wao.ui.publishedByYourCompany" />
                </s:else>
                <s:text name="wao.ui.misc.onDate" />
                <s:property value="topiaCreateDate" />

                <s:if test="authenticatedWaoUser.isAuthorizedToEditOrDeleteNews(#aRecentNews)">

                    <s:url action="delete-news" id="deleteNewsUrl">
                        <s:param name="newsId" value="topiaId" />
                    </s:url>
                    <s:a href="%{deleteNewsUrl}" cssClass="btn-link" title="%{getText('wao.ui.action.delete')}" >
                        <i class="fa fa-trash-o"></i> 
                    </s:a>
                    
                    <s:url action="edit-news!input" id="editNewsUrl">
                        <s:param name="newsId" value="topiaId" />
                    </s:url>
                    <s:a href="%{editNewsUrl}" cssClass="btn-link btn-link-edit" title="%{getText('wao.ui.action.edit')}">
                        <i class="fa fa-edit"></i>
                    </s:a>
                </s:if>
            </p>
        </div>

    </s:iterator>

</html>
