<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

<head>
    <title>
        <s:text name="wao.ui.page.Boats.title"/>
    </title>

    <script>

        $(document).ready(function () {

            var boatFilterMappings = [

                <s:if test="authenticatedWaoUser.authorizedToFilterOnBoats">
                    {
                        filterName: 'boatIds',
                        filterLabel: "<s:text name="wao.ui.entity.Boat"/>",
                        filterValuesField: 'boats',
                        minimumInputLength: 3
                    },
                </s:if>
                {
                    filterName: 'elligibleForSampleRowsFilter.fishingZoneFacadeNames',
                    filterLabel: "<s:text name="wao.ui.field.FishingZone.facadeName"/>",
                    filterValuesField: 'elligibleForSampleRowsFilterValues.fishingZoneFacadeNames'
                },
                {
                    filterName: 'elligibleForSampleRowsFilter.fishingZoneSectorNames',
                    filterLabel: "<s:text name="wao.ui.field.FishingZone.sectorName"/>",
                    filterValuesField: 'elligibleForSampleRowsFilterValues.fishingZoneSectorNames'
                },
                {
                    filterName: 'elligibleForSampleRowsFilter.sampleRowCodes',
                    filterLabel: "<s:text name="wao.ui.field.SampleRow.code"/>",
                    filterValuesField: 'elligibleForSampleRowsFilterValues.sampleRowCodes'
                },
                {
                    filterName: 'districtIds',
                    filterLabel: "<s:text name="wao.ui.field.Boat.district"/>",
                    filterValuesField: 'districts'
                },
                {
                    filterName: 'shipOwnerIds',
                    filterLabel: "<s:text name="wao.ui.field.Boat.shipOwner"/>",
                    filterValuesField: 'shipOwners',
                    minimumInputLength: 3
                },
                {
                    filterName: 'portOfRegistryIds',
                    filterLabel: "<s:text name="wao.ui.field.Boat.portOfRegistry"/>",
                    filterValuesField: 'portsOfRegistry'
                }
            ];

            filter = <s:property value="filter" escapeHtml="false"/>;

            boatsFilterController2 = new FilterController2(boatFilterMappings, filter, WAO.BOATS_FILTER_VALUES_JSON_URL, $('#boats-filters-form fieldset.extra-filters'));
            boatsFilterController2.init();

//            var $boatsFiltersForm = $('#boats-filters-form');
//            var boatsFilterController = new FilterController(WAO.BOATS_FILTER_VALUES_JSON_URL, $boatsFiltersForm);
//            boatsFilterController.init();

            var $boatDetails = $('#boat-details');
            var $companyId = $('#companyId');

            var showBoatDetails = function (boatId) {
                var companyId = $companyId.val();
                var successCallback = function (data) {
                    $boatDetails.html(data);
                    $('tr.boat-row').removeClass('highlight');
                    $('tr[data-boat-id="' + boatId + '"]').addClass('highlight');
                    $boatDetails.effect('highlight', 'slow');
                };
                var data = {
                    fragment: true,
                    boatId: boatId,
                    companyId: companyId
                };
                WAO.get(WAO.BOAT_DETAILS_URL, data, successCallback);
            }
            $('a.boat-details-action').click(function (e) {
                e.preventDefault();
                var boatId = $(this).parents('tr.boat-row').attr('data-boat-id');
                showBoatDetails(boatId);
            });
            $companyId.change(function () {
                var boatId = $('tr.boat-row.highlight').attr('data-boat-id');
                if (boatId) {
                    showBoatDetails(boatId);
                }
            });

        });

    </script>

</head>

<content tag="mainClass">large</content>
<content tag="boatsMenuItemClass">active</content>

<s:if test="startBoatSelectionForSampleRow != null">
    <div class="alert alert-info">
        <s:text name="wao.ui.tip.boatSelectionForSampleRowStarted">
            <s:param value="startBoatSelectionForSampleRow.code"/>
            <s:param value="startBoatSelectionForSampleRow.professionDescription"/>
        </s:text>
        <s:url action="cancel-boat-selection" id="cancelBoatSelectionUrl"/>
        <s:a href="%{cancelBoatSelectionUrl}" cssClass="btn btn-link">
            <s:text name="wao.ui.action.cancel"/>
        </s:a>
    </div>
</s:if>

<div id="boats-filters-list-details-layout">

    <div>
        <s:form method="GET" id="boats-filters-form" cssClass="filters-form">

            <fieldset class="extra-filters">

            </fieldset>

            <div class="form-actions">

                <s:submit type="button" action="boats!applyFilter" cssClass="btn btn-primary">
                    <i class="icon-filter"></i> <s:text name="wao.ui.action.filter"/>
                </s:submit>

                <s:submit type="button" action="boats!resetFilter" cssClass="btn">
                    <i class="icon-trash"></i> <s:text name="wao.ui.action.reset"/>
                </s:submit>

                <s:submit action="export-boats" type="button" cssClass="btn">
                    <i class="icon-download"></i> <s:text name="wao.ui.action.csvExport"/>
                </s:submit>

            </div>

        </s:form>

    </div>

    <div>
        <div class="arrow-right"></div>
        <h2>
            <s:text name="wao.ui.boats.title">
                <s:param value="%{pagination.count}"/>
            </s:text>
        </h2>

        <s:if test="authenticatedWaoUser.authorizedToViewBoatDetailsForAllCompanies">
            <s:select id="companyId"
                      name="companyId"
                      label="Vous devez sélectionner la société pour laquelle vous souhaitez consulter les informations"
                      list="allCompanies"
                      listKey="%{topiaId}"
                      listValue="%{name}"
                      value="%{authenticatedWaoUser.waoUser.company.topiaId}"
                      cssClass="input-xxlarge" />
        </s:if>
        <s:else>
            <s:hidden id="companyId" name="companyId" value="%{authenticatedWaoUser.waoUser.company.topiaId}"/>
        </s:else>

        <table id="boats-list" class="table-condensed table-striped table-hover">
            <thead>
                <tr>
                    <th>
                        <s:text name="wao.ui.boats.registrationCode"/>
                    </th>
                    <th>
                        <s:text name="wao.ui.boats.boatName"/>
                    </th>
                    <th>
                        <s:text name="wao.ui.boats.boatLength"/> (cm)
                    </th>
                    <th>
                        <s:text name="wao.ui.boats.buildYear"/>
                    </th>
                    <th>
                        <s:text name="wao.ui.boats.district"/>
                    </th>
                    <th>
                        <span data-original-title="<s:text name="wao.ui.boats.portOfRegistry.description"/>" data-toggle="tooltip" data-placement="bottom">
                            <s:text name="wao.ui.boats.portOfRegistry"/>
                        </span>
                    </th>
                </tr>
            </thead>
            <tbody>
                <s:iterator value="boats" var="boat">
                <tr data-boat-id="<s:property value="topiaId"/>" class="boat-row">
                    <td>
                        <s:if test="authenticatedWaoUser.authorizedToViewBoatDetails">
                            <s:url action="boat-details" id="boatDetailsUrl">
                                <s:param name="companyId" value="authenticatedWaoUser.waoUser.company.topiaId" />
                                <s:param name="boatId" value="topiaId" />
                            </s:url>
                            <s:a href="%{boatDetailsUrl}" cssClass="boat-details-action">
                                <s:property value="%{'' + immatriculation}"/>
                            </s:a>
                        </s:if>
                        <s:else>
                            <s:property value="%{'' + immatriculation}"/>
                        </s:else>
                    </td>
                    <td<s:if test="!active"> class="inactive"</s:if>>
                        <s:property value="name"/>
                    </td>
                    <td><s:property value="boatLength"/></td>
                    <td><s:property value="%{'' + buildYear}"/></td>
                    <td><s:property value="district.districtCode"/></td>
                    <td>
                        <s:if test="portOfRegistry != null">
                            <span data-original-title="<s:property value="portOfRegistry.description"/>" data-toggle="tooltip" data-placement="bottom">
                                <s:property value="portOfRegistry.portCode"/>
                            </span>
                        </s:if>
                    </td>
                </tr>
                </s:iterator>
            </todby>
        </table>

        <%-- Pagination --%>
        <div class="pagination">
            <ul>
                <s:url var="fullUrl" includeParams="get"/>
                <s:set var="paginationUrl" value="%{getPaginationUrl(#fullUrl)}"/>
                <s:if test="firstRangePage > 2">
                    <li>
                        <a href="${paginationUrl}0">1</a>
                    </li>
                    <li>
                        <a href="${paginationUrl}1">2</a>
                    </li>
                    <li>
                        <span>...</span>
                    </li>
                </s:if>

                <s:iterator var="currentPage" begin="firstRangePage" end="lastRangePage">
                    <li class="<s:if test="#currentPage - 1 == pagination.currentPage.pageNumber">active</s:if>">
                        <a href="${paginationUrl}${currentPage - 1}">
                            <s:property/>
                        </a>
                    </li>
                </s:iterator>

                <s:if test="lastRangePage < pagination.pageCount - 1">
                    <li>
                        <span>...</span>
                    </li>
                    <li>
                        <a href="${paginationUrl}${pagination.pageCount - 2}">
                            <s:property value="pagination.pageCount - 1"/>
                        </a>
                    </li>
                    <li>
                        <a href="${paginationUrl}${pagination.pageCount - 1}">
                            <s:property value="pagination.pageCount"/>
                        </a>
                    </li>
                </s:if>
            </ul>
        </div>
    </div>

    <s:if test="authenticatedWaoUser.authorizedToViewBoatDetails">

        <div>
            <div class="arrow-right"></div>
            <div id="boat-details">
                <div class="alert alert-info">
                    <s:text name="wao.ui.tip.youMustChooseBoat" />
                </div>
            </div>
        </div>
    </s:if>

</div>

</html>
