<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@taglib uri="/struts-tags" prefix="s" %>

<script>
    $(document).ready(function () {

    // le formulaire concernant l'interlocuteur

        var $boatInfosForm = $('#boat-infos-form');
        var $saveBoatInfosButton = $('#save-boat-infos');
        var $unlockBoatInfosFormButton = $('#unlock-boat-infos-form');

        $saveBoatInfosButton.click(function () {
            var data = WAO.toData($boatInfosForm);
            if ( ! data['boatInfos.contactPostalCode'].match(/^[\d ]*$/)) {
                alert("<s:text name="wao.ui.form.BoatInfos.validation.invalidPostalCode"/>");
            } else {
                $boatInfosForm.find('input, textarea').attr('readonly', 'readonly');
                $saveBoatInfosButton.attr('disabled', 'disabled');
                $unlockBoatInfosFormButton.removeAttr('disabled');
                var successCallback = function () {
                    WAO.notifications.success('<s:text name="wao.ui.form.BoatInfos.success"/>');
                };
                WAO.post(WAO.UPDATE_BOAT_INFOS_JSON_URL, data, successCallback);
            }
        });

        $unlockBoatInfosFormButton.click(function () {
            $boatInfosForm.find('input[readonly], button, textarea').removeAttr('readonly').removeAttr('disabled');
            $unlockBoatInfosFormButton.attr('disabled', 'disabled');
        });


    // le calcul des sollicitations

        var $boatContactsCountForm = $('#boat-contacts-count-form');
        var $boatContactsCountsTable = $('#boat-contacts-counts-table');

        $boatContactsCountsTable.hide();

        var getBoatContactsCount = function () {
            var data = WAO.toData($boatContactsCountForm);
            var since = data.since;
            var successCallback = function (data) {
                var tr = '<tr>'
                       + '    <td>'
                       +          since
                       + '    </td>'
                       + '    <td>'
                       +          data.boatContactsCounts.contactsCompanyCount
                       + '        (' + data.boatContactsCounts.observationsCompanyCount + ')'
                       + '    </td>'
                       + '    <td>'
                       +          data.boatContactsCounts.contactsCount
                       + '        (' + data.boatContactsCounts.observationsCount + ')'
                       + '    </td>'
                       + '</tr>';
                $boatContactsCountsTable.find('tbody').append(tr);
                $boatContactsCountsTable.show();
            };
            WAO.get(WAO.GET_BOAT_CONTACTS_COUNT_JSON_URL, data, successCallback);
        }

        $('#get-boat-contacts-count').click(getBoatContactsCount);
        $boatContactsCountForm.enterKey(getBoatContactsCount);

    // création d'un contact depuis une ligne éligible

        var $createContactFromBoatButton = $('#createContactFromBoatButton');
        var $sampleRowIdInput = $('input[name="sampleRowId"]');
        var expiredSampleRowIds = <s:property value="boatDetails.expiredSampleRowIds" escapeHtml="false"/>
        $sampleRowIdInput.change(function () {
            $createContactFromBoatButton.removeAttr('disabled');
        });
        $createContactFromBoatButton.click(function (e) {
            var selectedSampleRowIsExpired = $.inArray($('input[name="sampleRowId"]:checked').val(), expiredSampleRowIds) !== -1;
            var confirmMessage = "<s:text name="wao.ui.contacts.createFromBoat.warn"/>";
            if (selectedSampleRowIsExpired && ! confirm(confirmMessage)) {
                e.preventDefault();
            }
        });

    // suppresssion d'une éligibilité
        $('.remove-boat-eligibility').click(function (e) {
            e.preventDefault();
            if (confirm("<s:text name="wao.ui.removeBoatEligibility.confirm"/>")) {
                var url = $(this).attr('href');
                var $toRemove = $(this).parents('.elligible-sample-row')
                var successCallback = function (data) {
                    $toRemove.remove();
                };
                WAO.post(url, {}, successCallback);
            }
        });

    });
</script>

<h2>
    <s:text name="wao.ui.boatinfo.contacts">
        <s:param value="boatDetails.boatInfos.boat.name"/>
    </s:text>
</h2>

<h3>
    <s:text name="wao.ui.boats.contacts.existing"/>
</h3>

<s:if test="boatDetails.contactsCount > 0">

    <h4>
        <s:text name="wao.ui.contact.lastContact"/>
    </h4>

    <table class="table">
        <tbody>
            <tr>
                <th>
                    <s:text name="wao.ui.field.Contact.creationDate"/>
                </th>
                <td>
                    <s:property value="boatDetails.mostRecentContact.creationDate"/>
                </td>
            </tr>
            <tr>
                <th>
                    <s:text name="wao.ui.field.Contact.mainObserver"/>
                </th>
                <td>
                    <s:property value="boatDetails.mostRecentContact.mainObserver.fullName"/>
                </td>
            </tr>
            <tr>
                <th>
                    <s:text name="wao.ui.field.Contact.contactState"/>
                </th>
                <td>
                    <s:property value="%{getText(boatDetails.mostRecentContact.contactState)}"/>
                </td>
            </tr>
            <tr>
                <th>
                    <s:text name="wao.ui.field.Contact.sampleRow"/>
                </th>
                <td>
                    <s:property value="boatDetails.mostRecentContact.sampleRow.code"/>
                </td>
            </tr>
        </tbody>
    </table>

    <s:url action="contacts!applyFilter" id="viewAssociatedContactsForBoatUrl">
        <s:param name="filter.boatFilter.registrationCode" value="boatDetails.boatInfos.boat.immatriculation"/>
        <s:param name="filter.sampleRowFilter.companyIds" value="boatDetails.boatInfos.company.topiaId"/>
        <s:param name="filter.periodFrom"/>
        <s:param name="filter.periodTo"/>
    </s:url>
    <s:a href="%{viewAssociatedContactsForBoatUrl}">
        <s:text name="wao.ui.action.viewAssociatedContactsForBoat">
            <s:param value="boatDetails.contactsCount"/>
        </s:text>
    </s:a>

</s:if>
<s:else>
    <s:text name="wao.ui.boats.contacts.none"/>
</s:else>

<h3>
    <s:text name="wao.ui.contact.creation"/>
</h3>

<s:if test="boatDetails.boatInfos.boat.active">
    <s:if test="startBoatSelectionForSampleRow == null">
        <s:if test="boatDetails.elligibleForSampleRows.empty">
            <s:text name="wao.ui.tip.boatDetails.elligibleForSampleRowsEmpty" />
        </s:if>
        <s:else>
            <s:text name="wao.ui.boats.associatedLine"/>
            <s:if test="boatDetails.newContactCreatable && authenticatedWaoUser.authorizedToCreateContact">
                <s:form action="create-contact">

                    <s:hidden name="boatId" value="%{boatDetails.boatInfos.boat.topiaId}"/>

                    <div class="control-group">
                        <div class="controls">
                            <s:iterator value="boatDetails.elligibleForSampleRows" status="status">
                                <div class="elligible-sample-row">
                                    <s:set name="radioId">radio-<s:property value="#status.index"/></s:set>
                                    <input type="radio" name="sampleRowId" id="<s:property value="#radioId"/>" value="<s:property value="topiaId"/>"/>
                                    <%--
                                    <label for="<s:property value="%{#radioId}"/>" class="radio">
                                        <s:property value="code"/>
                                    </label>
                                    --%>
                                    <s:property value="code"/>
                                    <s:url action="update-boat-elligibility-json" id="updateBoatElligibilityUrl">
                                        <s:param name="boatId" value="boatDetails.boatInfos.boat.topiaId"/>
                                        <s:param name="sampleRowId" value="topiaId"/>
                                        <s:param name="active" value="false"/>
                                    </s:url>
                                    <s:a href="%{updateBoatElligibilityUrl}" cssClass="btn btn-link remove-boat-eligibility">
                                        <i class="icon-remove"></i>
                                    </s:a>
                                </div>
                            </s:iterator>
                        </div>
                    </div>


                    <s:submit id="createContactFromBoatButton" type="button" cssClass="btn btn-success" disabled="true">
                        <i class="icon-plus"></i>
                        <s:text name="wao.ui.contacts.createFromBoat"/>
                    </s:submit>
                </s:form>
            </s:if>
            <s:else>
                <ul>
                    <s:iterator value="boatDetails.elligibleForSampleRows">
                        <li class="elligible-sample-row">
                            <s:property value="code"/>
                            <s:url action="update-boat-elligibility-json" id="updateBoatElligibilityUrl">
                                <s:param name="boatId" value="boatDetails.boatInfos.boat.topiaId"/>
                                <s:param name="sampleRowId" value="topiaId"/>
                                <s:param name="active" value="false"/>
                            </s:url>
                            <s:a href="%{updateBoatElligibilityUrl}" cssClass="btn btn-link remove-boat-eligibility">
                                <i class="icon-remove"></i>
                            </s:a>
                        </li>
                    </s:iterator>
                </ul>
            </s:else>
        </s:else>
        <s:if test="authenticatedWaoUser.authorizedToCreateContact">
            <div class="alert alert-info">
                <s:text name="wao.ui.tip.useBoatSelectionForSampleRow"/>
            </div>
        </s:if>
    </s:if>
    <s:else>
        <s:if test="boatDetails.newContactCreatable">
            <s:if test="boatDetails.newContactCreatable && authenticatedWaoUser.authorizedToCreateContact">
                <s:url action="create-contact" id="createContactUrl">
                    <s:param name="boatId" value="boatDetails.boatInfos.boat.topiaId"/>
                    <s:param name="sampleRowId" value="startBoatSelectionForSampleRow.topiaId"/>
                </s:url>
                <s:a href="%{createContactUrl}" cssClass="btn btn-success">
                    <i class="icon-plus"></i>
                    <s:text name="wao.ui.contacts.createFromBoatAndSelectedSampleRow">
                        <s:param value="startBoatSelectionForSampleRow.code"/>
                        <s:param value="startBoatSelectionForSampleRow.professionDescription"/>
                    </s:text>
                </s:a>
            </s:if>
        </s:if>
        <s:else>
            <div class="alert">
                <s:text name="wao.ui.tip.contactAlreadyExists"/>
            </div>
        </s:else>
    </s:else>

</s:if>
<s:else>
    <div class="alert">
        <s:text name="wao.ui.tip.inactiveBoat"/>
    </div>
</s:else>

<h3>
    <s:text name="wao.ui.boatDetails.boatContactsCounts.title"/>
</h3>

<table id="boat-contacts-counts-table" class="table no-border-top">
    <thead>
        <tr>
            <td>
                <s:text name="wao.ui.boatDetails.boatContactsCounts.since"/>
            </td>
            <td>
                <s:text name="wao.ui.boatDetails.boatContactsCounts.contactsCompanyCount"/>
            </td>
            <td>
                <s:text name="wao.ui.boatDetails.boatContactsCounts.contactsCount"/>
            </td>
    </thead>
    <tbody>
    </tbody>
</table>

<s:form id="boat-contacts-count-form">

    <s:hidden name="boatId" value="%{boatDetails.boatInfos.boat.topiaId}" />
    <s:hidden name="companyId" value="%{boatDetails.boatInfos.company.topiaId}" />

    <div class="input-prepend input-append">

        <span class="add-on">
            <s:text name="wao.ui.boatDetails.boatContactsCounts.since"/>
        </span>

        <input name="since" type="text" value="<s:property value="%{oneYearAgoDatePlaceHolder}"/>"/>

        <button type="button" id="get-boat-contacts-count" class="btn">
            <i class="icon-plus"></i> <s:text name="wao.ui.boatDetails.boatContactsCounts.compute" />
        </button>
    </div>
</s:form>

<h2>
    <s:text name="wao.ui.boatinfo.title">
        <s:param value="boatDetails.boatInfos.boat.name"/>
    </s:text>
</h2>

<h3>
    <s:text name="wao.ui.boats.info"/>
</h3>

<table class="table">
    <tbody>
        <tr>
            <th class="no-border-top">
                <s:text name="wao.ui.field.Boat.shipOwner"/>
            </th>
            <td class="no-border-top">
                <s:url action="boats!applyFilter" id="shipOwnerBoatsUrl">
                    <s:param name="filter.shipOwnerIds" value="boatDetails.boatInfos.boat.shipOwner.topiaId"/>
                </s:url>
                <s:set name="shipOwnerBoatsTitle">
                    <s:text name="wao.ui.action.viewShipOwnerBoats"/>
                </s:set>
                <s:a href="%{shipOwnerBoatsUrl}" title="%{shipOwnerBoatsTitle}">
                    <s:property value="boatDetails.boatInfos.boat.shipOwner.firstName"/>
                    <s:property value="boatDetails.boatInfos.boat.shipOwner.lastName"/>
                </s:a>
            </td>
        </tr>
        <tr>
            <th>
                <s:text name="wao.ui.field.Boat.boatGroup"/>
            </th>
            <td>
                <s:if test="boatDetails.boatInfos.boat.boatGroup == null">
                    <s:text name="wao.ui.misc.N/A"/>
                </s:if>
                <s:else>
                    <s:property value="boatDetails.boatInfos.boat.boatGroup.description"/>
                </s:else>
            </td>
        </tr>
    </tbody>
</table>

<h3>
    <s:text name="wao.ui.boats.interlocutor"/>
</h3>

<s:form id="boat-infos-form" cssClass="form-horizontal">

    <s:hidden name="boatId" value="%{boatDetails.boatInfos.boat.topiaId}" />
    <s:hidden name="companyId" value="%{boatDetails.boatInfos.company.topiaId}" />

    <s:textfield name="boatInfos.contactFirstName" value="%{boatDetails.boatInfos.contactFirstName}" label="%{getText('wao.ui.field.BoatInfos.contactFirstName')}" readonly="true" cssClass="input-large" />
    <s:textfield name="boatInfos.contactLastName" value="%{boatDetails.boatInfos.contactLastName}" label="%{getText('wao.ui.field.BoatInfos.contactLastName')}" readonly="true" cssClass="input-large" />
    <s:textfield type="email" name="boatInfos.contactEmail" value="%{boatDetails.boatInfos.contactEmail}" label="%{getText('wao.ui.field.BoatInfos.contactEmail')}" readonly="true" cssClass="input-large" />
    <s:textfield type="tel" name="boatInfos.contactPhoneNumber" value="%{boatDetails.boatInfos.contactPhoneNumber}" label="%{getText('wao.ui.field.BoatInfos.contactPhoneNumber')}" readonly="true" cssClass="input-large" />
    <s:textfield type="number" name="boatInfos.dup" value="%{boatDetails.boatInfos.dup}" label="%{getText('wao.ui.field.BoatInfos.dup')}" readonly="true" cssClass="input-small" />
    <s:textfield name="boatInfos.contactAddress1" value="%{boatDetails.boatInfos.contactAddress1}" label="%{getText('wao.ui.field.BoatInfos.contactAddress1')}" readonly="true" cssClass="input-xxlarge" />
    <s:textfield name="boatInfos.contactAddress2" value="%{boatDetails.boatInfos.contactAddress2}" label="%{getText('wao.ui.field.BoatInfos.contactAddress2')}" readonly="true" cssClass="input-xxlarge" />
    <s:textfield name="boatInfos.contactPostalCode" value="%{boatDetails.boatInfos.contactPostalCode}" label="%{getText('wao.ui.field.BoatInfos.contactPostalCode')}" readonly="true" cssClass="input-small" />
    <s:textfield name="boatInfos.contactCity" value="%{boatDetails.boatInfos.contactCity}" label="%{getText('wao.ui.field.BoatInfos.contactCity')}" readonly="true" cssClass="input-large" />
    <s:textarea name="boatInfos.comment" value="%{boatDetails.boatInfos.comment}" label="%{getText('wao.ui.field.BoatInfos.comment')}" readonly="true" cssClass="input-xxlarge" />

    <div class="form-actions">
        <button type="button" id="unlock-boat-infos-form" class="btn">
            <i class="icon-edit"></i> <s:text name="wao.ui.action.edit" />
        </button>

        <button type="button" id="save-boat-infos" class="btn" disabled="disabled">
            <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
        </button>
    </div>

</s:form>