/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.WaoTechnicalException;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.I18nAble;
import fr.ifremer.wao.services.AuthenticatedWaoUser;
import fr.ifremer.wao.services.service.ContactDataInputDateAfterTodayException;
import fr.ifremer.wao.services.service.ContactDataInputDateBeforeObservationEndDateException;
import fr.ifremer.wao.services.service.ContactNotUpdatableException;
import fr.ifremer.wao.services.service.ContactObservationEndDateAfterTodayException;
import fr.ifremer.wao.services.service.ContactObservationEndDateBeforeBeginDateException;
import fr.ifremer.wao.services.service.ContactRestitutionDateBeforeDataInputDateException;
import fr.ifremer.wao.services.service.ContactWithObservedDataControlToCorrectionAskedException;
import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.services.service.DuplicatedContactMainObserverInSecondaryObserversException;
import fr.ifremer.wao.services.service.IllegalAcceptationException;
import fr.ifremer.wao.services.service.InvalidContactObservationBeginDateException;
import fr.ifremer.wao.services.service.MismatchContactMainObserverCompanyException;
import fr.ifremer.wao.services.service.MismatchContactSecondaryObserverCompanyException;
import fr.ifremer.wao.services.service.MissingContactCommentAdminException;
import fr.ifremer.wao.services.service.MissingContactCommentException;
import fr.ifremer.wao.services.service.MissingContactDataInputDateException;
import fr.ifremer.wao.services.service.MissingContactDataReliabilityException;
import fr.ifremer.wao.services.service.MissingContactMainObserverException;
import fr.ifremer.wao.services.service.MissingContactMammalsInfoException;
import fr.ifremer.wao.services.service.MissingContactNbObservantsException;
import fr.ifremer.wao.services.service.MissingContactObservationBeginDateException;
import fr.ifremer.wao.services.service.MissingContactObservationEndDateException;
import fr.ifremer.wao.services.service.MissingContactObservedDataControlException;
import fr.ifremer.wao.services.service.MissingContactRestitutionException;
import fr.ifremer.wao.services.service.MissingContactStateMotifException;
import fr.ifremer.wao.services.service.MissingContactTerrestrialLocationException;
import fr.ifremer.wao.services.service.UnknownContactIdException;
import fr.ifremer.wao.services.service.UnwantedContactContactStateMotifException;
import fr.ifremer.wao.services.service.UpdateContactCommand;
import fr.ifremer.wao.web.WaoJsonActionSupport;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidateContactJsonAction
extends WaoJsonActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ValidateContactJsonAction.class);
    protected String contactId;
    protected Boolean validationState;
    protected String successMessage;
    protected String errorMessage;
    protected transient ContactsService service;
    protected UpdateContactCommand updateContactCommand;

    public void setService(ContactsService service) {
        this.service = service;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public void setValidationState(Boolean validationState) {
        this.validationState = validationState;
    }

    public String getContactId() {
        return this.contactId;
    }

    public Boolean getValidationState() {
        return this.validationState;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isSuccessful() {
        return this.errorMessage == null;
    }

    public void prepare() {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)this.contactId));
        try {
            this.updateContactCommand = this.service.newUpdateContactCommand(this.session.getAuthenticatedWaoUser(), this.contactId);
        }
        catch (UnknownContactIdException e) {
            this.addActionError(this.t("wao.ui.error.unknownContactId", new Object[0]));
        }
    }

    public String execute() {
        AuthenticatedWaoUser authenticatedWaoUser = this.session.getAuthenticatedWaoUser();
        if (log.isInfoEnabled()) {
            log.info((Object)("user " + authenticatedWaoUser + " wants to change validation for contact " + this.contactId));
        }
        if (authenticatedWaoUser.isAdmin()) {
            this.updateContactCommand.setValidationProgram(this.validationState);
            if (log.isInfoEnabled()) {
                log.info((Object)("setting contact validation program to " + this.validationState));
            }
        } else {
            this.updateContactCommand.setValidationCompany(this.validationState);
            if (log.isInfoEnabled()) {
                log.info((Object)("setting contact validation company to " + this.validationState));
            }
        }
        try {
            this.service.validate(authenticatedWaoUser, this.updateContactCommand);
        }
        catch (ContactNotUpdatableException e) {
            this.session.addErrorMessages(this.t("wao.ui.contacts.validation.failure.not.updatable", new Object[0]));
        }
        catch (UnwantedContactContactStateMotifException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.unwantedContactStateMotif", new Object[0]);
        }
        catch (MissingContactNbObservantsException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingObserver", new Object[]{state});
        }
        catch (MissingContactObservationEndDateException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingObservationEndDate", new Object[]{state});
        }
        catch (ContactDataInputDateBeforeObservationEndDateException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.dataInputDateBeforeObservationEndDate", new Object[0]);
        }
        catch (InvalidContactObservationBeginDateException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.invalidObservationBeginDate", new Object[0]);
        }
        catch (MissingContactRestitutionException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingRestitution", new Object[0]);
        }
        catch (ContactDataInputDateAfterTodayException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.dataInputDateAfterToday", new Object[0]);
        }
        catch (MissingContactCommentException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingComment", new Object[]{state});
        }
        catch (MismatchContactMainObserverCompanyException e) {
            String companyName = e.getCompany().getName();
            String observerLogin = e.getObserver().getLogin();
            this.errorMessage = this.t("wao.ui.form.Contact.error.mismatchCompanyForObserver", new Object[]{observerLogin, companyName});
        }
        catch (ContactRestitutionDateBeforeDataInputDateException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.transmissionDateBeforeDataInputDate", new Object[0]);
        }
        catch (ContactObservationEndDateBeforeBeginDateException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.observationEndDateBeforeBeginDate", new Object[0]);
        }
        catch (DuplicatedContactMainObserverInSecondaryObserversException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.duplicatedMainObserverInSecondaryObservers", new Object[0]);
        }
        catch (MissingContactDataReliabilityException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingDataReliability", new Object[0]);
        }
        catch (MismatchContactSecondaryObserverCompanyException e) {
            String companyName = e.getCompany().getName();
            String observerLogin = e.getObserver().getLogin();
            this.errorMessage = this.t("wao.ui.form.Contact.error.mismatchCompanyForObserver", new Object[]{observerLogin, companyName});
        }
        catch (MissingContactObservedDataControlException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingObservedDataControl", new Object[0]);
        }
        catch (ContactWithObservedDataControlToCorrectionAskedException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.observedDataControlToCorrectionAsked", new Object[0]);
        }
        catch (MissingContactStateMotifException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingContactStateMotif", new Object[0]);
        }
        catch (MissingContactDataInputDateException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingDataInputDate", new Object[0]);
        }
        catch (MissingContactMainObserverException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingMainObserver", new Object[0]);
        }
        catch (MissingContactCommentAdminException e) {
            String dataReliability = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getDataReliability());
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingCommentAdmin", new Object[]{dataReliability});
        }
        catch (ContactObservationEndDateAfterTodayException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.observationEndDateAfterToday", new Object[0]);
        }
        catch (MissingContactObservationBeginDateException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingObservationBeginDate", new Object[]{state});
        }
        catch (MissingContactTerrestrialLocationException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingContactTerrestrialLocation", new Object[0]);
        }
        catch (MissingContactMammalsInfoException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.missingContactMammalsInfo", new Object[0]);
        }
        catch (IllegalAcceptationException e) {
            this.errorMessage = this.t("wao.ui.form.Contact.error.illegalAcceptationException", new Object[0]);
        }
        if (this.isSuccessful()) {
            try {
                this.service.save(this.updateContactCommand);
            }
            catch (ContactNotUpdatableException e) {
                throw new WaoTechnicalException("should never occur", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"changing validation state successful");
            }
            this.successMessage = this.validationState == null ? this.t("wao.ui.contacts.validation.to.unvalidate.state.success", new Object[0]) : (this.validationState.booleanValue() ? this.t("wao.ui.contacts.validation.to.accept.state.success", new Object[0]) : this.t("wao.ui.contacts.validation.to.reject.state.success", new Object[0]));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("changing validation state failed for reason " + this.errorMessage));
        }
        return "success";
    }

    public boolean isAcceptable(Contact contact) {
        boolean acceptable;
        if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            acceptable = contact.isAcceptableByCompany();
        } else if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            acceptable = contact.isAcceptableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return acceptable;
    }

    public boolean isRefusable(Contact contact) {
        boolean refuseable;
        if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            refuseable = contact.isRefusableByCompany();
        } else if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            refuseable = contact.isRefusableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return refuseable;
    }

    public boolean isUnacceptable(Contact contact) {
        boolean unacceptable;
        if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            unacceptable = contact.isUnacceptableByCompany();
        } else if (this.session.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            unacceptable = contact.isUnacceptableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return unacceptable;
    }

    public Boolean getValidationProgram() {
        return this.updateContactCommand.getContact().getValidationProgram();
    }

    public Boolean getValidationCompany() {
        return this.updateContactCommand.getContact().getValidationCompany();
    }
}

