/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.entity.ContactState;
import fr.ifremer.wao.entity.ContactStateMotif;
import fr.ifremer.wao.entity.DataReliability;
import fr.ifremer.wao.entity.I18nAble;
import fr.ifremer.wao.entity.ObsProgram;
import fr.ifremer.wao.entity.ObservedDataControl;
import fr.ifremer.wao.entity.SamplingStrategy;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.TerrestrialLocations;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.entity.WaoUsers;
import fr.ifremer.wao.services.AuthenticatedWaoUser;
import fr.ifremer.wao.services.service.ContactDataInputDateAfterTodayException;
import fr.ifremer.wao.services.service.ContactDataInputDateBeforeObservationEndDateException;
import fr.ifremer.wao.services.service.ContactNotUpdatableException;
import fr.ifremer.wao.services.service.ContactObservationEndDateAfterTodayException;
import fr.ifremer.wao.services.service.ContactObservationEndDateBeforeBeginDateException;
import fr.ifremer.wao.services.service.ContactRestitutionDateBeforeDataInputDateException;
import fr.ifremer.wao.services.service.ContactWithObservedDataControlToCorrectionAskedException;
import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.services.service.DuplicatedContactMainObserverInSecondaryObserversException;
import fr.ifremer.wao.services.service.IllegalAcceptationException;
import fr.ifremer.wao.services.service.InvalidContactObservationBeginDateException;
import fr.ifremer.wao.services.service.MismatchContactMainObserverCompanyException;
import fr.ifremer.wao.services.service.MismatchContactSecondaryObserverCompanyException;
import fr.ifremer.wao.services.service.MissingContactCommentAdminException;
import fr.ifremer.wao.services.service.MissingContactCommentException;
import fr.ifremer.wao.services.service.MissingContactDataInputDateException;
import fr.ifremer.wao.services.service.MissingContactDataReliabilityException;
import fr.ifremer.wao.services.service.MissingContactMainObserverException;
import fr.ifremer.wao.services.service.MissingContactMammalsInfoException;
import fr.ifremer.wao.services.service.MissingContactNbObservantsException;
import fr.ifremer.wao.services.service.MissingContactObservationBeginDateException;
import fr.ifremer.wao.services.service.MissingContactObservationEndDateException;
import fr.ifremer.wao.services.service.MissingContactObservedDataControlException;
import fr.ifremer.wao.services.service.MissingContactRestitutionException;
import fr.ifremer.wao.services.service.MissingContactStateMotifException;
import fr.ifremer.wao.services.service.MissingContactTerrestrialLocationException;
import fr.ifremer.wao.services.service.UnknownContactIdException;
import fr.ifremer.wao.services.service.UnwantedContactContactStateMotifException;
import fr.ifremer.wao.services.service.UpdateContactCommand;
import fr.ifremer.wao.services.service.administration.ReferentialService;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name="success", type="redirectAction", params={"actionName", "contacts"})})
public class EditContactAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected Optional<String> optionalContactId = Optional.absent();
    protected Map<String, String> observers;
    protected Map<String, String> terrestrialLocations;
    protected Map<ContactState, String> contactStates;
    protected Map<String, String> contactStateMotives;
    protected Map<ObservedDataControl, String> observedDataControls;
    protected Map<DataReliability, String> dataReliabilities;
    protected Map<SamplingStrategy, String> samplingStrategies;
    protected transient ContactsService service;
    protected transient WaoUsersService waoUsersService;
    protected transient ReferentialService referentialService;
    protected UpdateContactCommand updateContactCommand;

    public void setService(ContactsService service) {
        this.service = service;
    }

    public void setWaoUsersService(WaoUsersService waoUsersService) {
        this.waoUsersService = waoUsersService;
    }

    public void setReferentialService(ReferentialService referentialService) {
        this.referentialService = referentialService;
    }

    public void setContactId(String contactId) {
        this.optionalContactId = Optional.fromNullable((Object)Strings.emptyToNull((String)contactId));
    }

    public String getContactId() {
        return (String)this.optionalContactId.orNull();
    }

    public UpdateContactCommand getUpdateContactCommand() {
        if (this.updateContactCommand == null) {
            this.prepare();
        }
        return this.updateContactCommand;
    }

    public Map<String, String> getObservers() {
        if (this.observers == null) {
            this.prepare();
        }
        return this.observers;
    }

    public Map<ContactState, String> getContactStates() {
        if (this.contactStates == null) {
            this.prepare();
        }
        return this.contactStates;
    }

    public Map<String, String> getContactStateMotives() {
        if (this.contactStateMotives == null) {
            this.prepare();
        }
        return this.contactStateMotives;
    }

    public Map<ObservedDataControl, String> getObservedDataControls() {
        if (this.observedDataControls == null) {
            this.prepare();
        }
        return this.observedDataControls;
    }

    public Map<DataReliability, String> getDataReliabilities() {
        if (this.dataReliabilities == null) {
            this.prepare();
        }
        return this.dataReliabilities;
    }

    public Map<String, String> getTerrestrialLocations() {
        if (this.terrestrialLocations == null) {
            this.prepare();
        }
        return this.terrestrialLocations;
    }

    public Map<SamplingStrategy, String> getSamplingStrategies() {
        if (this.samplingStrategies == null) {
            this.prepare();
        }
        return this.samplingStrategies;
    }

    public String getDateTimePlaceholder() {
        return this.formatDateTime(new Date());
    }

    public String getDatePlaceholder() {
        return this.formatDate(new Date());
    }

    public void prepare() {
        try {
            this.updateContactCommand = this.service.newUpdateContactCommand(this.getAuthenticatedWaoUser(), this.optionalContactId);
        }
        catch (UnknownContactIdException e) {
            this.addActionError(this.t("wao.ui.error.unknownContactId", new Object[0]));
        }
        List waoUsers = this.waoUsersService.getActiveWaoUsers(Optional.of((Object)this.updateContactCommand.getContact().getSampleRow().getCompany().getTopiaId()));
        TreeSet sortedWaoUsers = Sets.newTreeSet((Comparator)WaoUsers.fullNameComparator());
        sortedWaoUsers.addAll(waoUsers);
        this.observers = new LinkedHashMap();
        for (WaoUser waoUser : sortedWaoUsers) {
            this.observers.put(waoUser.getTopiaId(), waoUser.getFullName());
        }
        this.contactStates = new EnumMap(ContactState.class);
        for (ContactState contactState : ContactState.getAllowedStates((ObsProgram)this.getAuthenticatedWaoUser().getObsProgram())) {
            this.contactStates.put(contactState, WaoUtils.l((Locale)this.getLocale(), (I18nAble)contactState));
        }
        this.contactStateMotives = new TreeMap();
        for (ContactStateMotif contactStateMotif : this.referentialService.getAllContactStateMotifs(null)) {
            this.contactStateMotives.put(contactStateMotif.getTopiaId(), contactStateMotif.getName());
        }
        this.observedDataControls = new EnumMap(ObservedDataControl.class);
        for (ObservedDataControl observedDataControl : ObservedDataControl.values()) {
            this.observedDataControls.put(observedDataControl, WaoUtils.l((Locale)this.getLocale(), (I18nAble)observedDataControl));
        }
        this.dataReliabilities = new EnumMap(DataReliability.class);
        for (ObservedDataControl observedDataControl : DataReliability.values()) {
            this.dataReliabilities.put(observedDataControl, WaoUtils.l((Locale)this.getLocale(), (I18nAble)observedDataControl));
        }
        this.samplingStrategies = new EnumMap(SamplingStrategy.class);
        for (ObservedDataControl observedDataControl : SamplingStrategy.values()) {
            this.samplingStrategies.put(observedDataControl, WaoUtils.l((Locale)this.getLocale(), (I18nAble)observedDataControl));
        }
        this.terrestrialLocations = new LinkedHashMap();
        List terrestrialLocationInDistricts = this.referentialService.getTerrestrialLocationInDistricts(this.updateContactCommand.getContact().getSampleRow().getTerrestrialLocations());
        TreeSet sortedTerrestrialLocations = new TreeSet(TerrestrialLocations.nameComparator());
        sortedTerrestrialLocations.addAll(terrestrialLocationInDistricts);
        for (TerrestrialLocation terrestrialLocation : sortedTerrestrialLocations) {
            this.terrestrialLocations.put(terrestrialLocation.getTopiaId(), terrestrialLocation.getDescription());
        }
    }

    public void validate() {
        this.service.preValidate(this.updateContactCommand);
        AuthenticatedWaoUser authenticatedWaoUser = this.session.getAuthenticatedWaoUser();
        try {
            this.service.validate(authenticatedWaoUser, this.updateContactCommand);
        }
        catch (ContactNotUpdatableException e) {
            this.session.addErrorMessages(this.t("wao.ui.contacts.validation.failure.not.updatable", new Object[0]));
        }
        catch (UnwantedContactContactStateMotifException e) {
            this.addFieldError("updateContactCommand.contact.contactStateMotif", this.t("wao.ui.form.Contact.error.unwantedContactStateMotif", new Object[0]));
        }
        catch (MissingContactNbObservantsException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.addFieldError("updateContactCommand.contact.nbObservants", this.t("wao.ui.form.Contact.error.missingObserver", new Object[]{state}));
        }
        catch (MissingContactObservationEndDateException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.addFieldError("updateContactCommand.contact.observationEndDate", this.t("wao.ui.form.Contact.error.missingObservationEndDate", new Object[]{state}));
        }
        catch (ContactDataInputDateBeforeObservationEndDateException e) {
            this.addFieldError("updateContactCommand.contact.dataInputDate", this.t("wao.ui.form.Contact.error.dataInputDateBeforeObservationEndDate", new Object[0]));
        }
        catch (InvalidContactObservationBeginDateException e) {
            this.addFieldError("updateContactCommand.contact.observationBeginDate", this.t("wao.ui.form.Contact.error.invalidObservationBeginDate", new Object[0]));
        }
        catch (MissingContactRestitutionException e) {
            this.addFieldError("updateContactCommand.contact.restitution", this.t("wao.ui.form.Contact.error.missingRestitution", new Object[0]));
        }
        catch (ContactDataInputDateAfterTodayException e) {
            this.addFieldError("updateContactCommand.contact.dataInputDate", this.t("wao.ui.form.Contact.error.dataInputDateAfterToday", new Object[0]));
        }
        catch (MissingContactCommentException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.addFieldError("updateContactCommand.contact.comment", this.t("wao.ui.form.Contact.error.missingComment", new Object[]{state}));
        }
        catch (MismatchContactMainObserverCompanyException e) {
            String companyName = e.getCompany().getName();
            String observerLogin = e.getObserver().getLogin();
            this.addFieldError("updateContactCommand.contact.mainObserver", this.t("wao.ui.form.Contact.error.mismatchCompanyForObserver", new Object[]{observerLogin, companyName}));
        }
        catch (ContactRestitutionDateBeforeDataInputDateException e) {
            this.addFieldError("updateContactCommand.contact.restitution", this.t("wao.ui.form.Contact.error.transmissionDateBeforeDataInputDate", new Object[0]));
        }
        catch (ContactObservationEndDateBeforeBeginDateException e) {
            this.addFieldError("updateContactCommand.contact.observationEndDate", this.t("wao.ui.form.Contact.error.observationEndDateBeforeBeginDate", new Object[0]));
        }
        catch (DuplicatedContactMainObserverInSecondaryObserversException e) {
            this.addFieldError("updateContactCommand.contact.secondaryObservers", this.t("wao.ui.form.Contact.error.duplicatedMainObserverInSecondaryObservers", new Object[0]));
        }
        catch (MissingContactDataReliabilityException e) {
            this.addFieldError("updateContactCommand.contact.dataReliability", this.t("wao.ui.form.Contact.error.missingDataReliability", new Object[0]));
        }
        catch (MismatchContactSecondaryObserverCompanyException e) {
            String companyName = e.getCompany().getName();
            String observerLogin = e.getObserver().getLogin();
            this.addFieldError("updateContactCommand.contact.secondaryObservers", this.t("wao.ui.form.Contact.error.mismatchCompanyForObserver", new Object[]{observerLogin, companyName}));
        }
        catch (MissingContactObservedDataControlException e) {
            this.addFieldError("updateContactCommand.contact.observedDataControl", this.t("wao.ui.form.Contact.error.missingObservedDataControl", new Object[0]));
        }
        catch (ContactWithObservedDataControlToCorrectionAskedException e) {
            this.addFieldError("updateContactCommand.contact.observedDataControl", this.t("wao.ui.form.Contact.error.observedDataControlToCorrectionAsked", new Object[0]));
        }
        catch (MissingContactStateMotifException e) {
            this.addFieldError("updateContactCommand.contact.contactStateMotif", this.t("wao.ui.form.Contact.error.missingContactStateMotif", new Object[0]));
        }
        catch (MissingContactDataInputDateException e) {
            this.addFieldError("updateContactCommand.contact.dataInputDate", this.t("wao.ui.form.Contact.error.missingDataInputDate", new Object[0]));
        }
        catch (MissingContactMainObserverException e) {
            this.addFieldError("updateContactCommand.contact.mainObserver", this.t("wao.ui.form.Contact.error.missingMainObserver", new Object[0]));
        }
        catch (MissingContactCommentAdminException e) {
            String dataReliability = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getDataReliability());
            this.addFieldError("updateContactCommand.contact.commentAdmin", this.t("wao.ui.form.Contact.error.missingCommentAdmin", new Object[]{dataReliability}));
        }
        catch (ContactObservationEndDateAfterTodayException e) {
            this.addFieldError("updateContactCommand.contact.observationEndDate", this.t("wao.ui.form.Contact.error.observationEndDateAfterToday", new Object[0]));
        }
        catch (MissingContactObservationBeginDateException e) {
            String state = WaoUtils.l((Locale)this.getLocale(), (I18nAble)e.getContact().getContactState());
            this.addFieldError("updateContactCommand.contact.observationBeginDate", this.t("wao.ui.form.Contact.error.missingObservationBeginDate", new Object[]{state}));
        }
        catch (MissingContactMammalsInfoException e) {
            this.addFieldError("updateContactCommand.contact.mammalsInfo", this.t("wao.ui.form.Contact.error.missingMammalsInfo", new Object[0]));
        }
        catch (MissingContactTerrestrialLocationException e) {
            throw new UnsupportedOperationException();
        }
        catch (IllegalAcceptationException e) {
            throw new IllegalStateException("should never occur", e);
        }
    }

    public String execute() throws Exception {
        this.service.save(this.updateContactCommand);
        this.session.addMessage(this.t("wao.ui.form.updateContactCommand.success", new Object[0]));
        this.session.setContactToHighlightId(this.updateContactCommand.getContact().getTopiaId());
        return "success";
    }
}

