/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Objects;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.WaoUtils;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ContactState;
import fr.ifremer.wao.entity.DCF5Code;
import fr.ifremer.wao.entity.FishingZone;
import fr.ifremer.wao.entity.I18nAble;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.ContactsFilterValues;
import fr.ifremer.wao.services.service.ContactsService;
import fr.ifremer.wao.services.service.ObsMerContactsList;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContactsAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    protected transient ContactsService service;
    protected int pageNumber;
    protected long firstRangePage;
    protected long lastRangePage;
    protected ContactsFilter filter;
    protected ObsMerContactsList contactsList;
    protected Date now = new Date();

    public void setService(ContactsService service) {
        this.service = service;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public long getFirstRangePage() {
        return this.firstRangePage;
    }

    public long getLastRangePage() {
        return this.lastRangePage;
    }

    public ContactsFilter getFilter() {
        if (this.filter == null) {
            this.prepare();
        }
        return this.filter;
    }

    public List<Contact> getContacts() {
        return this.contactsList.getContacts().getElements();
    }

    public ContactsFilterValues getFilterValues() {
        return this.contactsList.getFilterValues();
    }

    public PaginationResult<Contact> getPagination() {
        return this.contactsList.getContacts();
    }

    public void prepare() {
        if (this.filter == null) {
            this.filter = this.service.newContactFilter(this.getAuthenticatedWaoUser());
        }
    }

    public void validate() {
        if (this.filter.getPeriodFrom() != null && this.filter.getPeriodTo() != null && this.filter.getPeriodTo().before(this.filter.getPeriodFrom())) {
            this.addFieldError("filter.periodTo", I18n.l((Locale)this.getLocale(), (String)"wao.ui.periodToMustBeAfterPeriodFrom", (Object[])new Object[0]));
        }
    }

    public String execute() {
        this.filter = (ContactsFilter)Objects.firstNonNull((Object)this.session.getContactsFilter(), (Object)this.filter);
        return this.applyFilter();
    }

    public String resetFilter() {
        this.filter = this.service.newContactFilter(this.getAuthenticatedWaoUser());
        return this.applyFilter();
    }

    public String applyFilter() {
        this.getSession().setContactsFilter(this.filter);
        PaginationParameter pager = this.service.newContactsPaginationParameter(this.pageNumber, 25);
        this.contactsList = this.service.getContactsList(this.getAuthenticatedWaoUser(), this.filter, pager);
        this.firstRangePage = this.getPaginationFirstPage(this.contactsList.getContacts(), 10);
        this.lastRangePage = this.getPaginationLastPage(this.contactsList.getContacts(), 10, this.firstRangePage);
        return "success";
    }

    public String getFilterPeriodFromPlaceholder() {
        String placeholder = this.formatDate(DateUtils.addMonths((Date)this.now, (int)1));
        return placeholder;
    }

    public String getFilterPeriodToPlaceholder() {
        String placeholder = this.formatDate(DateUtils.addYears((Date)this.now, (int)1));
        return placeholder;
    }

    public boolean isFullView() {
        boolean fullView = this.getAuthenticatedWaoUser().isAdmin() || this.getAuthenticatedWaoUser().isProfessional();
        return fullView;
    }

    public String getMammalsInfo(Contact contact) {
        return ContactsAction.escapeForToolTip((String)contact.getMammalsInfo());
    }

    public boolean isBoardingDone(Contact contact) {
        return ContactState.OBSERVATION_DONE == contact.getContactState();
    }

    public String getDivision(SampleRow sampleRow) {
        String result = "";
        for (FishingZone zone : sampleRow.getFishingZone()) {
            result = result + zone.getDistrictCode() + " ";
        }
        return result;
    }

    public static String escapeForToolTip(String str) {
        String result = str.replaceAll("\r\n", "\n");
        result = result.replaceAll("\n", "<br />");
        result = result.replaceAll("'", "&rsquo;");
        result = result.replaceAll("\"", "&#34;");
        result = result.replaceAll("%", "&#37;");
        return result;
    }

    public String getContactToHighlightId() {
        return this.session.getContactToHighlightId();
    }

    public Map<String, String> getDcf5CodesAndDescriptions(SampleRow sampleRow) {
        LinkedHashMap<String, String> dcf5CodesAndDescriptions = new LinkedHashMap<String, String>();
        for (DCF5Code dcf5Code : sampleRow.getdCF5Code()) {
            String key = dcf5Code.getCode();
            String description = dcf5Code.getFishingGearCode() + " - " + WaoUtils.l((Locale)this.getLocale(), (I18nAble)dcf5Code.getFishingGearDCF());
            if (dcf5Code.getTargetSpeciesCode() != null) {
                description = description + " ; " + dcf5Code.getTargetSpeciesCode() + " - " + WaoUtils.l((Locale)this.getLocale(), (I18nAble)dcf5Code.getTargetSpeciesDCF());
            }
            dcf5CodesAndDescriptions.put(key, description);
        }
        return dcf5CodesAndDescriptions;
    }

    public boolean isAcceptable(Contact contact) {
        boolean acceptable;
        if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            acceptable = contact.isAcceptableByCompany();
        } else if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            acceptable = contact.isAcceptableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return acceptable;
    }

    public boolean isRefusable(Contact contact) {
        boolean refuseable;
        if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            refuseable = contact.isRefusableByCompany();
        } else if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            refuseable = contact.isRefusableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return refuseable;
    }

    public boolean isUnacceptable(Contact contact) {
        boolean unacceptable;
        if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationCompany()) {
            unacceptable = contact.isUnacceptableByCompany();
        } else if (this.getAuthenticatedWaoUser().isAuthorizedToChangeValidationProgram()) {
            unacceptable = contact.isUnacceptableByProgram();
        } else {
            throw new IllegalStateException();
        }
        return unacceptable;
    }
}

