package fr.ifremer.wao.web.converter;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.util.StrutsTypeConverter;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * To convert a set of Boolean to string (string empty value means {@code null} value).
 * <p/>
 * Created on 4/6/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 4.0
 */
public class BooleanSetConverter extends StrutsTypeConverter {

    @Override
    public Set<Boolean> convertFromString(Map map, String[] strings, Class aClass) {

        Set<Boolean> result = new HashSet<>();

        if (strings.length > 0) {

            for (String string : strings) {
                Boolean aBoolean;

                if (StringUtils.isEmpty(string) || "null".equals(string)) {
                    aBoolean = null;
                } else {
                    aBoolean = Boolean.valueOf(string);
                }
                result.add(aBoolean);
            }
        }
        return result;
    }

    @Override
    public String convertToString(Map map, Object o) {

        String str;

        if (o == null) {

            str = StringUtils.EMPTY;

        } else {

            if (o instanceof Set) {

                Set<Boolean> booleans = (Set<Boolean>) o;
                Set<String> strings = new HashSet<>();
                for (Boolean aBoolean : booleans) {
                    String string;
                    if (aBoolean == null) {
                        string = "";
                    } else {
                        string = aBoolean.toString();
                    }
                    strings.add(string);
                }

                str = Joiner.on(',').join(strings);
            } else {
                throw new UnsupportedOperationException("cannot convert to set of Boolean " + o);
            }
        }

        return str;

    }
}
