package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.services.service.IllegalDeletionException;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results({
        @Result(name="error", type="redirectAction", params = { "actionName", "wao-users" }),
        @Result(name="success", type="redirectAction", params = { "actionName", "wao-users" })
})
public class DeleteWaoUserAction extends WaoJspActionSupport {

    private static final long serialVersionUID = 1L;

    protected transient WaoUsersService service;

    protected String waoUserId;

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setWaoUserId(String waoUserId) {
        this.waoUserId = waoUserId;
    }

    @Override
    public String execute() {

        try {

            service.deleteWaoUser(waoUserId);

            session.addMessage(t("wao.ui.action.deleteWaoUser.success"));

            return SUCCESS;

        } catch (IllegalDeletionException e) {

            session.addErrorMessages(t("wao.ui.action.deleteWaoUser.failure"));
            session.addErrorMessages(e.getExplanation(getLocale()));

            return ERROR;

        }

    }

}
