package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.wao.services.service.BoatsService;
import fr.ifremer.wao.web.WaoJsonActionSupport;

public class UpdateBoatElligibilityJsonAction extends WaoJsonActionSupport {

    protected BoatsService service;

    protected String boatId;

    protected String sampleRowId;

    protected boolean active;

    public void setService(BoatsService service) {
        this.service = service;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setBoatId(String boatId) {
        this.boatId = boatId;
    }

    public void setSampleRowId(String sampleRowId) {
        this.sampleRowId = sampleRowId;
    }

    @Override
    public String execute() {

        service.changeBoatElligibility(session.getAuthenticatedWaoUser(), boatId, sampleRowId, active);

        return SUCCESS;
    }
}
