package fr.ifremer.wao.web.action;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.MissingDcf5CodesException;
import fr.ifremer.wao.services.service.MissingFishingZonesException;
import fr.ifremer.wao.services.service.MissingPeriodBeginException;
import fr.ifremer.wao.services.service.MissingPeriodEndException;
import fr.ifremer.wao.services.service.MissingProfessionSpeciesException;
import fr.ifremer.wao.services.service.MissingProgramNameException;
import fr.ifremer.wao.services.service.MissingSampleRowLogCommentException;
import fr.ifremer.wao.services.service.NoEffortDefinedException;
import fr.ifremer.wao.services.service.ObsMerSamplingPlanService;
import fr.ifremer.wao.services.service.SampleMonthWithIllegalExpectedTidesValueException;
import fr.ifremer.wao.services.service.SampleRowCodeMustBeUniqueException;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.services.service.UpdateSampleRowCommand;
import fr.ifremer.wao.services.service.WrongSampleRowCodeFormatException;
import fr.ifremer.wao.services.service.administration.UnknownBoatImmatriculationsException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import java.util.Map;

@Results({
        @Result(name="success", type="redirectAction", params = { "actionName", "sampling-plan" })
})
public class EditSampleRowAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(EditSampleRowAction.class);

    protected transient SamplingPlanService service;

    protected Optional<String> optionalSampleRowId = Optional.absent();

    protected UpdateSampleRowCommand updateSampleRowCommand;

    public void setService(ObsMerSamplingPlanService service) {
        this.service = service;
    }

    public String getSampleRowId() {
        return optionalSampleRowId.orNull();
    }

    public void setSampleRowId(String sampleRowId) {
        this.optionalSampleRowId = Optional.fromNullable(Strings.emptyToNull(sampleRowId));
    }

    @Override
    public void prepare() {

        updateSampleRowCommand = service.newUpdateSampleRowCommand(getAuthenticatedWaoUser(), optionalSampleRowId);

    }

    @Override
    public void validate() {

        SampleRow sampleRow = updateSampleRowCommand.getSampleRow();

        try {

            service.preValidate(getAuthenticatedWaoUser(), updateSampleRowCommand);

            service.validate(getAuthenticatedWaoUser(), updateSampleRowCommand);

            if (CollectionUtils.isEmpty(sampleRow.getdCF5Code())) {
                addFieldError("updateSampleRowCommand.dcf5Codes", t("wao.ui.form.SampleRow.error.missingDcf5Codes"));
            }

        } catch (UnknownBoatImmatriculationsException e) {
            addFieldError("updateSampleRowCommand.elligibleBoatImmatriculations", t("wao.ui.unknownBoatImmatriculations", Joiner.on(", ").join(e.getImmatriculations())));
        } catch (SampleRowCodeMustBeUniqueException e) {
            addFieldError("updateSampleRowCommand.code", t("wao.ui.form.SampleRow.error.codeMustBeUnique"));
        } catch (MissingPeriodEndException e) {
            addFieldError("updateSampleRowCommand.sampleRow.periodEnd", t("wao.ui.form.SampleRow.error.missingPeriodEnd"));
        } catch (MissingPeriodBeginException e) {
            addFieldError("updateSampleRowCommand.sampleRow.periodBegin", t("wao.ui.form.SampleRow.error.missingPeriodBegin"));
        } catch (MissingFishingZonesException e) {
            addFieldError("updateSampleRowCommand.fishingZones", t("wao.ui.form.SampleRow.error.missingFishingZones"));
        } catch (WrongSampleRowCodeFormatException e) {
            addFieldError("updateSampleRowCommand.code", t("wao.import.sampleRow.failure.wrongSampleRowCodeFormat", sampleRow.getCode()));
        } catch (MissingSampleRowLogCommentException e) {
            addFieldError("updateSampleRowCommand.sampleRowLog.comment", t("wao.ui.form.SampleRow.error.missingLogComment"));
        } catch (MissingProfessionSpeciesException e) {
            addFieldError("updateSampleRowCommand.sampleRow.samplingStrategy", t("wao.ui.form.SampleRow.error.missingProfessionSpecies"));
        } catch (SampleMonthWithIllegalExpectedTidesValueException e) {
            SampleMonth sampleMonth = e.getSampleMonth();
            addActionError(t("wao.ui.form.SampleRow.error.sampleMonthWithIllegalExpectedTidesValue", formatMonth(sampleMonth.getPeriodDate())));
        } catch (MissingProgramNameException e) {
            addFieldError("updateSampleRowCommand.sampleRow.programName", t("wao.ui.form.SampleRow.error.missingProgramName"));
        } catch (MissingDcf5CodesException e) {
            addFieldError("updateSampleRowCommand.dcf5Codes", t("wao.ui.form.SampleRow.error.missingDcf5Codes"));
        } catch (NoEffortDefinedException e) {
            addFieldError("updateSampleRowCommand.dcf5Codes", t("wao.ui.form.SampleRow.error.noEffortDefined"));
        }

    }

    @Override
    public String execute() {

        service.save(updateSampleRowCommand);

        session.addMessage(t("wao.ui.form.updateSampleRowCommand.success", updateSampleRowCommand.getSampleRow().getCode()));

        session.setSampleRowToHighlightId(updateSampleRowCommand.getSampleRow().getTopiaId());

        return SUCCESS;

    }

    public UpdateSampleRowCommand getUpdateSampleRowCommand() {
        if (updateSampleRowCommand == null) {
            prepare();
        }
        return updateSampleRowCommand;
    }

    public Map<String, Integer> getExpectedObservationsByMonths() {
        return getUpdateSampleRowCommand().getExpectedObservationsByMonths();
    }

    public void setExpectedObservationsByMonths(Map<String, Integer> expectedObservationsByMonths) {
        getUpdateSampleRowCommand().setExpectedObservationsByMonths(expectedObservationsByMonths);
    }

}