<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

    <head>
        <title>
            <s:property value="%{t('wao.ui.sampleRowLog.title', sampleRow.code)}" />
        </title>
    </head>

    <h1>
        <s:property value="%{t('wao.ui.sampleRowLog.title', sampleRow.code)}" />
    </h1>

    <s:iterator value="sampleRow.sampleRowLog" var="sampleRowLogEntry">

        <article>
            <h2>
                <s:if test="fromAdmin">
                    <s:text name="wao.ui.misc.changeOn" />
                </s:if>
                <s:else>
                    <s:text name="wao.ui.misc.commentAddedOn" />
                </s:else>
                <s:property value="topiaCreateDate" />
                <s:text name="wao.ui.misc.by" />
                <s:property value="author.fullName" />
            </h2>

            <s:property value="logText" />

            <s:property value="comment" />

        </article>

    </s:iterator>

    <s:if test="authenticatedWaoUser.authorizedToCommentSampleRow">

        <s:form action="comment-sample-row">

            <fieldset>
                <legend><s:text name="wao.ui.form.addComment" /></legend>

                <s:hidden name="sampleRowId" value="%{sampleRowId}" />

                <s:textarea name="comment" label="%{getText('wao.ui.misc.comment')}" />

                <div class="form-actions">
                    <s:url action="sampling-plan" id="samplingPlanUrl" />
                    <s:a href="%{samplingPlanUrl}" cssClass="btn">
                        <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.goBackToSamplingPlan" />
                    </s:a>

                    <s:submit type="button" cssClass="btn">
                        <i class="icon-hdd"></i> <s:text name="wao.ui.action.save" />
                    </s:submit>
                </div>

            </fieldset>

        </s:form>

    </s:if>

    <s:else>

        <div class="form-actions">
            <s:url action="sampling-plan" id="samplingPlanUrl" />
            <s:a href="%{samplingPlanUrl}" cssClass="btn">
                <i class="icon-chevron-left"></i> <s:text name="wao.ui.action.goBackToSamplingPlan" />
            </s:a>
        </div>

    </s:else>

</html>
