<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8" %>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

<head>
    <title>
        <s:text name="wao.ui.page.Contacts.title"/>
    </title>

    <script>

        $(document).ready(function () {

            var contactsFilterMappings = [
                <s:if test="authenticatedWaoUser.authorizedToViewOtherCompanies">
                    {
                        filterName: 'sampleRowFilter.companyIds',
                        filterLabel: "<s:text name="wao.ui.entity.Company"/>",
                        filterValuesField: 'sampleRowsFilterValues.companies',
                    },
                </s:if>
                {
                    filterName: 'sampleRowFilter.sampleRowCodes',
                    filterLabel: "<s:text name="wao.ui.field.SampleRow.code"/>",
                    filterValuesField: 'sampleRowsFilterValues.sampleRowCodes',
                },
                {
                    filterName: 'sampleRowFilter.programNames',
                    filterLabel: "<s:text name="wao.ui.field.SampleRow.programName"/>",
                    filterValuesField: 'sampleRowsFilterValues.programNames',
                },
                {
                    filterName: 'sampleRowFilter.fishingZoneFacadeNames',
                    filterLabel: "<s:text name="wao.ui.field.FishingZone.facadeName"/>",
                    filterValuesField: 'sampleRowsFilterValues.fishingZoneFacadeNames',
                },
                {
                    filterName: 'sampleRowFilter.fishingZoneSectorNames',
                    filterLabel: "<s:text name="wao.ui.field.FishingZone.sectorName"/>",
                    filterValuesField: 'sampleRowsFilterValues.fishingZoneSectorNames',
                },
                <s:if test="obsVente">
                    {
                        filterName: 'terrestrialLocationIds',
                        filterLabel: "<s:text name="wao.ui.field.Contact.terrestrialLocation"/>",
                        filterValuesField: 'terrestrialLocations'
                    },
                </s:if>
                {
                    filterName: 'sampleRowFilter.fishingGearDcfIds',
                    filterLabel: "<s:text name="wao.ui.entity.fishingGearDCF"/>",
                    filterValuesField: 'sampleRowsFilterValues.fishingGearDcfs',
                },
                {
                    filterName: 'sampleRowFilter.targetSpeciesDcfIds',
                    filterLabel: "<s:text name="wao.ui.entity.targetSpeciesDCF"/>",
                    filterValuesField: 'sampleRowsFilterValues.targetSpeciesDcfs',
                },
                <s:if test="authenticatedWaoUser.authorizedToFilterOnBoats">
                    {
                        filterName: 'boatFilter.boatIds',
                        filterLabel: "<s:text name="wao.ui.entity.Boat"/>",
                        filterValuesField: 'boatsFilterValues.boats',
                        minimumInputLength: 3
                    },
                </s:if>
                {
                    filterName: 'boatFilter.districtIds',
                    filterLabel: "<s:text name="wao.ui.field.Boat.district"/>",
                    filterValuesField: 'boatsFilterValues.districts'
                },
                {
                    filterName: 'observerIds',
                    filterLabel: "<s:text name="wao.ui.misc.observer"/>",
                    filterValuesField: 'observers'
                },
                {
                    filterName: 'contactStates',
                    filterLabel: "<s:text name="wao.ui.field.Contact.contactState"/>",
                    filterValuesField: 'contactStates'
                },
                {
                    filterName: 'companyAcceptations',
                    filterLabel: "<s:text name="wao.ui.field.Contact.validationCompany"/>",
                    filterValuesField: 'companyAcceptations'
                },
                {
                    filterName: 'programAcceptations',
                    filterLabel: "<s:text name="wao.ui.field.Contact.validationProgram"/>",
                    filterValuesField: 'programAcceptations'
                },
                <s:if test="obsMer">
                    {
                        filterName: 'observedDataControls',
                        filterLabel: "<s:text name="wao.ui.field.Contact.observedDataControl"/>",
                        filterValuesField: 'observedDataControls'
                    },
                    {
                        filterName: 'dataReliabilities',
                        filterLabel: "<s:text name="wao.ui.field.Contact.dataReliability"/>",
                        filterValuesField: 'dataReliabilities'
                    }
                </s:if>
                <s:if test="obsVente">
                    {
                        filterName: 'sampleRowFilter.terrestrialDistrictIds',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.terrestrialLocation"/>",
                        filterValuesField: 'sampleRowsFilterValues.terrestrialDistricts'
                    },
                    {
                        filterName: 'sampleRowFilter.samplingStrategies',
                        filterLabel: "<s:text name="wao.ui.field.SampleRow.samplingStrategy"/>",
                        filterValuesField: 'sampleRowsFilterValues.samplingStrategies'
                    },
                    {
                        filterName: 'actualSamplingStrategies',
                        filterLabel: "<s:text name="wao.ui.field.Contact.samplingStrategy"/>",
                        filterValuesField: 'actualSamplingStrategies'
                    },
                    {
                        filterName: 'completeSamplings',
                        filterLabel: "<s:text name="wao.ui.field.Contact.completeSampling"/>",
                        filterValuesField: 'completeSamplings'
                    }
                </s:if>
            ];

            filter = <s:property value="filter" escapeHtml="false"/>;

            contactsFilterController2 = new FilterController2(contactsFilterMappings, filter, WAO.CONTACTS_FILTER_VALUES_JSON_URL, $('#contacts-filters-form fieldset.extra-filters'));
            contactsFilterController2.init();

            $('#switch-compact-full-view').click(function () {
                $('#switch-compact-full-view').toggleClass('full-view').toggleClass('compact-view');
                $('table.contacts-list').toggleClass('full-view').toggleClass('compact-view');
            });

            $('.validation-action').click(function(e) {
                e.preventDefault();
                var $action = $(this);
                var url = $action.attr('href');
                var successCallback = function (data) {
                    var successful = data['successful'];
                    if (successful) {
                        var success = data['successMessage'];
                        WAO.notifications.success(success);
                        var $tr = $('#contacts-list').find('tr[data-contactId="' + data.contactId + '"]');
                        $tr.removeClass('accepted-by-company refused-by-company accepted-by-program refused-by-program');
                        if (data.validationCompany) {
                            $tr.addClass('accepted-by-company');
                        } else if (data.validationCompany === false) {
                            $tr.addClass('refused-by-company');
                        }
                        if (data.validationProgram) {
                            $tr.addClass('accepted-by-program');
                        } else if (data.validationProgram === false) {
                            $tr.addClass('refused-by-program');
                        }
                    } else {
                        var error = data['errorMessage'];
                        WAO.notifications.error(error);
                    }
                };
                WAO.post(url, {}, successCallback);
            });

            // Do not expose any struts internal input fields
            $('input[type="hidden"][id^="__"]').prop('disabled', true);
        });

    </script>

</head>

<content tag="mainClass">large</content>
<content tag="contactsMenuItemClass">active</content>

<s:form method="GET" id="contacts-filters-form" cssClass="filters-form">

    <fieldset>

        <s:textfield name="filter.periodFrom"
                     label="%{getText('wao.ui.form.periodFrom')}"
                     placeholder="%{getFilterPeriodFromPlaceholder()}"
                     cssClass="input-small"/>

        <s:textfield name="filter.periodTo"
                     label="%{getText('wao.ui.form.period.to')}"
                     placeholder="%{getFilterPeriodToPlaceholder()}"
                     cssClass="input-small"/>

        <div title="<s:text name="wao.ui.form.filterOnObservationBeginDate.tooltip"/>">
            <s:checkbox name="filter.filterOnObservationBeginDate"
                        label="%{getText('wao.ui.form.filterOnObservationBeginDate')}"/>
        </div>

    </fieldset>

    <fieldset class="extra-filters">

    </fieldset>

    <fieldset>

        <s:if test="obsMer">

            <s:checkbox name="filter.mammalsObservationOnly"
                        label="%{getText('wao.ui.misc.observations')}"/>

            <s:checkbox name="filter.mammalsCaptureOnly"
                        label="%{getText('wao.ui.field.Contact.mammalsCapture')}"/>

        </s:if>

        <s:checkbox name="filter.commentDefinedOnly"
                    label="%{getText('wao.ui.field.Contact.comment')}"/>

        <s:checkbox name="filter.commentCompanyDefinedOnly"
                    label="%{getText('wao.ui.field.Contact.commentCompany')}"/>

        <s:checkbox name="filter.commentAdminDefinedOnly"
                    label="%{getText('wao.ui.field.Contact.commentAdmin')}"/>

    </fieldset>

    <fieldset>

        <s:checkbox name="filter.sortedByBoardingDate"
                    label="%{getText('wao.ui.form.sortByTideBegin')}"/>

    </fieldset>

    <div class="form-actions">

        <s:submit type="button" action="contacts!applyFilter" cssClass="btn btn-primary">
            <i class="icon-filter"></i> <s:text name="wao.ui.action.filter"/>
        </s:submit>

        <s:submit type="button" action="contacts!resetFilter" cssClass="btn">
            <i class="icon-trash"></i> <s:text name="wao.ui.action.reset"/>
        </s:submit>

        <s:if test="authenticatedWaoUser.authorizedToExportContacts">
            <s:submit action="export-contacts" type="button" cssClass="btn">
                <i class="icon-download"></i> <s:text name="wao.ui.action.csvExport"/>
            </s:submit>
        </s:if>

    </div>

</s:form>

<h3>
    <s:text name="wao.ui.contacts.title">
        <s:param value="%{pagination.count}"/>
    </s:text>
</h3>

<s:set name="pagination">
    <%-- Pagination --%>
    <div class="pagination">
        <ul>
            <s:url var="fullUrl" includeParams="get"/>
            <s:set var="paginationUrl" value="%{getPaginationUrl(#fullUrl)}"/>
            <s:if test="firstRangePage > 2">
                <li>
                    <a href="${paginationUrl}0">1</a>
                </li>
                <li>
                    <a href="${paginationUrl}1">2</a>
                </li>
                <li>
                    <span>...</span>
                </li>
            </s:if>

            <s:iterator var="currentPage" begin="firstRangePage" end="lastRangePage">
                <li class="<s:if test="#currentPage - 1 == pagination.currentPage.pageNumber">active</s:if>">
                    <a href="${paginationUrl}${currentPage - 1}">
                        <s:property/>
                    </a>
                </li>
            </s:iterator>

            <s:if test="lastRangePage < pagination.pageCount - 1">
                <li>
                    <span>...</span>
                </li>
                <li>
                    <a href="${paginationUrl}${pagination.pageCount - 2}">
                        <s:property value="pagination.pageCount - 1"/>
                    </a>
                </li>
                <li>
                    <a href="${paginationUrl}${pagination.pageCount - 1}">
                        <s:property value="pagination.pageCount"/>
                    </a>
                </li>
            </s:if>
        </ul>
    </div>
</s:set>

<s:set var="fullView" value="%{fullView}"/>

<div class="sticky-buttons">
    <button type="button" id="switch-compact-full-view" class="btn <s:if test="fullView">full-view</s:if><s:else>compact-view</s:else>">
        <span class="only-in-compact-view">
            <i class="fa fa-expand"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToFullView" /></span>
        </span>
        <span class="only-in-full-view">
            <i class="fa fa-compress"></i><span class="only-on-hover"> <s:text name="wao.ui.action.switchToCompactView" /></span>
        </span>
    </button>
</div>


<s:property value="#pagination" escapeHtml="false"/>

<table id="contacts-list" class="contacts-list large-table table-striped <s:if test="fullView">full-view</s:if><s:else>compact-view</s:else>">
    <thead>
        <tr>
            <th><s:text name="wao.ui.field.Contact.creationDate"/></th>
            <th><s:text name="wao.ui.contacts.boatName"/></th>
            <th><s:text name="wao.ui.field.Contact.sampleRow"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.field.SampleRow.programName"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.field.SampleRow.professionCode"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.contacts.Profession.libelle"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.contacts.Profession.species"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.contacts.FishingZone.facadeName"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.contacts.FishingZone.sectorName"/></th>
            <th class="only-in-full-view"><s:text name="wao.ui.contacts.division"/></th>
            <s:if test="obsVente">
                <th><s:text name="wao.ui.field.Contact.terrestrialLocation"/></th>
                <th><s:text name="wao.ui.field.SampleRow.samplingStrategy"/></th>
            </s:if>
            <th class="only-in-full-view"><s:text name="wao.ui.field.SampleRow.company"/></th>
            <th><s:text name="wao.ui.contacts.observers"/></th>
            <th><s:text name="wao.ui.field.Contact.contactState"/> (<s:text name="wao.ui.field.Contact.contactStateMotif"/>)</th>
            <th class="date-time"><s:text name="wao.ui.field.Contact.beginDate"/></th>
            <th class="date-time"><s:text name="wao.ui.field.Contact.endDate"/></th>
            <s:if test="obsMer">
                <th class="date-time"><s:text name="wao.ui.field.Contact.observationTimeInDays"/></th>
            </s:if>
            <th class="date"><s:text name="wao.ui.field.Contact.dataInputDate"/></th>
            <s:if test="obsMer">
                <th><s:text name="wao.ui.field.Contact.observedDataControl"/></th>
                <th class="date"><s:text name="wao.ui.field.Contact.restitution"/></th>
                <th><s:text name="wao.ui.contacts.observations"/></th>
            </s:if>
            <s:if test="obsVente">
                <th><s:text name="wao.ui.field.Contact.samplingStrategy"/></th>
                <th><s:text name="wao.ui.field.Contact.completeSampling"/></th>
            </s:if>
            <s:if test="authenticatedWaoUser.authorizedToViewContactsComments">
                <th><s:text name="wao.ui.field.Contact.comment"/></th>
                <th><s:text name="wao.ui.field.Contact.commentCompany"/></th>
                <th><s:text name="wao.ui.field.Contact.commentAdmin"/></th>
            </s:if>
            <s:if test="obsMer">
                <th><s:text name="wao.ui.field.Contact.dataReliability"/></th>
            </s:if>
            <th><s:text name="wao.ui.contacts.validation"/></th>
            <th><s:text name="wao.ui.actions"/></th>
        </tr>
    </thead>
    <tbody>

        <s:iterator value="contacts" var="contact">
            <s:set name="trCssClasses">contact-row<s:if test="topiaId.equals(contactToHighlightId)"> highlight</s:if><s:if test="validationCompany==null"></s:if><s:elseif test="validationCompany"> accepted-by-company</s:elseif><s:else> refused-by-company</s:else><s:if test="validationProgram==null"></s:if><s:elseif test="validationProgram"> accepted-by-program</s:elseif><s:else> refused-by-program</s:else></s:set>
            <tr class="<s:property value="#trCssClasses"/>" data-contactId="<s:property value="topiaId"/>">
                <td>
                    <s:property value="creationDate"/>
                </td>
                <td>
                    <s:set name="boatTooltip">
                        <s:text name="wao.ui.boats.registrationCode"/> <s:property value="%{'' + boat.immatriculation}" escapeHtml="false"/>
                        <s:text name="wao.ui.boats.boatLength"/> <s:property value="boat.boatLength" escapeHtml="false"/> cm
                        <s:text name="wao.ui.boats.buildYear"/> <s:property value="%{'' + boat.buildYear}" escapeHtml="false"/>
                        <s:text name="wao.ui.boats.district"/> <s:property value="boat.district.districtName" escapeHtml="false"/> (<s:property value="boat.district.districtCode" escapeHtml="false"/>)
                    </s:set>
                    <span data-original-title="<s:property value="#boatTooltip"/>" data-toggle="tooltip" data-placement="right">
                        <s:property value="boat.name"/>
                    </span>
                </td>
                <td class="only-in-compact-view">
                    <s:set name="sampleRowTooltip">
                        <s:text name="wao.ui.field.SampleRow.programName"/> <s:property value="sampleRow.programName" escapeHtml="false"/>
                        <s:text name="wao.ui.field.SampleRow.professionCode"/> <s:property value="sampleRow.professionDescription" escapeHtml="false"/>
                        <s:text name="wao.ui.contacts.Profession.libelle"/> <s:property value="sampleRow.profession.libelle" escapeHtml="false"/>
                        <s:text name="wao.ui.contacts.Profession.species"/> <s:property value="sampleRow.profession.species" escapeHtml="false"/>
                        <s:text name="wao.ui.contacts.FishingZone.facadeName"/> <s:property value="sampleRow.facade" escapeHtml="false"/>
                        <s:text name="wao.ui.contacts.FishingZone.sectorName"/> <s:property value="sampleRow.sectors" escapeHtml="false"/>
                        <s:text name="wao.ui.contacts.division"/> <s:property value="%{getDivision(sampleRow)}" escapeHtml="false"/>
                    </s:set>
                    <span data-original-title="<s:property value="#sampleRowTooltip"/>" data-toggle="tooltip" data-placement="right">
                        <s:property value="sampleRow.code"/>
                    </span>
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.code"/>
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.programName"/>
                </td>
                <td class="only-in-full-view">
                    <s:iterator value="getDcf5CodesAndDescriptions(sampleRow)">
                        <abbr title="<s:property value="value"/>"><s:property value="key"/></abbr>
                    </s:iterator>
                    <s:property value="sampleRow.professionDescriptionWithoutDCF5" />
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.profession.libelle"/>
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.profession.species"/>
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.facade"/>
                </td>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.sectors"/>
                </td>
                <td class="only-in-full-view">
                    <s:property value="%{getDivision(sampleRow)}"/>
                </td>
                <s:if test="obsVente">
                    <td>
                        <s:property value="terrestrialLocation.description"/>
                    </td>
                    <td>
                        <s:if test="sampleRow.samplingStrategy != null">
                            <s:text name="%{sampleRow.samplingStrategy.i18nKey}"/>
                        </s:if>
                    </td>
                </s:if>
                <td class="only-in-full-view">
                    <s:property value="sampleRow.company.name"/>
                </td>
                <td>
                    <ul>
                        <s:iterator value="allObservers">
                            <li><s:property value="fullName"/></li>
                        </s:iterator>
                    </ul>
                </td>
                <td>
                    <s:text name="%{contactState.i18nKey}"/>
                    <s:if test="contactStateMotif != null">
                        <s:property value="contactStateMotif.name"/>
                    </s:if>
                </td>
                <td class="date-time">
                    <s:if test="observationBeginDate != null">
                        <s:property value="observationBeginDate"/>
                    </s:if>
                </td>
                <td class="date-time">
                    <s:if test="observationEndDate != null">
                        <s:property value="observationEndDate"/>
                    </s:if>
                </td>
                <s:if test="obsMer">
                    <td>
                        <s:if test="observationTimeInDays != null">
                            <s:property value="observationTimeInDays"/>
                        </s:if>
                    </td>
                </s:if>
                <td class="date">
                    <s:if test="dataInputDate != null">
                        <s:property value="dataInputDate"/>
                    </s:if>
                </td>
                <s:if test="obsMer">
                    <td>
                        <s:if test="observedDataControl != null">
                            <s:text name="%{observedDataControl.i18nKey}"/>
                        </s:if>
                    </td>
                    <td class="date">
                        <s:if test="restitution != null">
                            <s:property value="restitution"/>
                        </s:if>
                    </td>
                    <td class="align-center">
                        <s:if test="mammalsObservation">
                            <i class="fa fa-eye"
                                 title="<s:text name="wao.ui.field.Contact.mammalsObservation"/>"></i>&nbsp;
                        </s:if>
                        <s:if test="mammalsCapture">
                            <img src="<s:url value="/img/hook-22px.png"/>"
                                 alt="<s:text name="wao.ui.field.Contact.mammalsCapture"/>"
                                 title="<s:property value="mammalsInfo" escapeHtml="true"/>"/>
                        </s:if>
                    </td>
                </s:if>
                <s:if test="obsVente">
                    <td>
                        <s:if test="samplingStrategy != null">
                            <s:text name="%{samplingStrategy.i18nKey}"/>
                        </s:if>
                    </td>
                    <td>
                        <s:if test="completeSampling == null">
                        </s:if>
                        <s:elseif test="completeSampling">
                            <s:text name="wao.ui.misc.yes"/>
                        </s:elseif>
                        <s:else>
                            <s:text name="wao.ui.misc.no"/>
                        </s:else>
                    </td>
                </s:if>
                <s:if test="authenticatedWaoUser.authorizedToViewContactsComments">
                    <td class="align-center">
                        <s:if test=" ! comment.empty">
                            <i title="<s:property value="comment" escapeHtml="true"/>" class="fa fa-comment"></i>
                        </s:if>
                    </td>
                    <td class="align-center">
                        <s:if test=" ! commentCoordinator.empty">
                            <i title="<s:property value="commentCoordinator" escapeHtml="true"/>" class="fa fa-comment"></i>
                        </s:if>
                    </td>
                    <td class="align-center">
                        <s:if test=" ! commentAdmin.empty">
                            <i title="<s:property value="commentAdmin" escapeHtml="true"/>" class="fa fa-comment"></i>
                        </s:if>
                    </td>
                </s:if>
                <s:if test="obsMer">
                    <td>
                        <s:if test="isBoardingDone(#contact)">
                            <s:if test="validationCompany">
                                <s:text name="%{dataReliability.i18nKey}"/>
                            </s:if>
                        </s:if>
                    </td>
                </s:if>
                <td>
                    <span class="fa-stack fa-lg" title="<s:text name="wao.ui.misc.validated"/>">
                        <i class="fa fa-square-o fa-stack-2x"></i>
                        <i class="fa fa-check fa-stack-1x only-if-accepted-by-company"></i>
                        <i class="fa fa-times fa-stack-1x only-if-refused-by-company"></i>
                    </span>
                    <span class="fa-stack fa-lg" title="<s:text name="wao.ui.misc.validated"/>">
                        <i class="fa fa-square-o fa-stack-2x"></i>
                        <i class="fa fa-check fa-stack-1x only-if-accepted-by-program"></i>
                        <i class="fa fa-times fa-stack-1x only-if-refused-by-program"></i>
                    </span>
                </td>
                <td class="actions">
                    <div class="dropdown">
                        <a class="btn dropdown-toggle" data-toggle="dropdown" href="#">
                            <s:text name="wao.ui.actions"/>
                            <b class="caret"></b>
                        </a>
                        <ul class="dropdown-menu">
                            <li>
                                <s:if test="authenticatedWaoUser.admin">
                                    <s:set name="focusAnchor">adminFocus</s:set>
                                </s:if>
                                <s:else>
                                    <s:set name="focusAnchor">coordinatorOrObserverFocus</s:set>
                                </s:else>
                                <s:url action="edit-contact!input" id="editContactUrl" anchor='%{focusAnchor}'>
                                    <s:param name="contactId" value="topiaId"/>
                                </s:url>
                                <s:a href="%{editContactUrl}">
                                    <i class="icon-edit"></i> <s:text name="wao.ui.action.editOrDeleteContact"/>
                                </s:a>
                            </li>
                            <s:if test="authenticatedWaoUser.authorizedToChangeContactValidation">
                                <li>
                                    <s:url action="validate-contact-json" id="acceptContactUrl" escapeAmp="false">
                                        <s:param name="contactId" value="topiaId"/>
                                        <s:param name="validationState">true</s:param>
                                    </s:url>
                                    <s:set name="disabled"><s:if test="%{ ! isAcceptable(#contact)}">disabled</s:if></s:set>
                                    <s:a cssClass="validation-action" href="%{acceptContactUrl}">
                                        <s:text name="wao.ui.action.acceptContact"/>
                                    </s:a>
                                </li>
                                <li>
                                    <s:url action="validate-contact-json" id="refuseContactUrl" escapeAmp="false">
                                        <s:param name="contactId" value="topiaId"/>
                                        <s:param name="validationState">false</s:param>
                                    </s:url>
                                    <s:a cssClass="validation-action" href="%{refuseContactUrl}">
                                        <s:text name="wao.ui.action.refuseContact"/>
                                    </s:a>
                                </li>
                                <li>
                                    <s:url action="validate-contact-json" id="unvalidateContactUrl">
                                        <s:param name="contactId" value="topiaId"/>
                                    </s:url>
                                    <s:a cssClass="validation-action" href="%{unvalidateContactUrl}">
                                        <s:text name="wao.ui.action.unvalidateContact"/>
                                    </s:a>
                                </li>
                            </s:if>
                        </ul>
                    </div>
                </td>
            </tr>
        </s:iterator>
    </todby>
</table>

<s:property value="#pagination" escapeHtml="false"/>

</html>
