<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

    <head>
        <title><s:text name="wao.ui.page.ReferentialManagement.title" /></title>
        <content tag="mainClass">form</content>
    </head>


    <s:form action="import-fishing-zones" method="POST" enctype="multipart/form-data">
        
        <h1><s:text name="wao.ui.page.ReferentialManagement.title" /></h1>

        <div class="alert alert-info">
            <s:text name="wao.ui.import.disclaimer" />
        </div>

        <fieldset>
            <legend>
                <s:text name="wao.import.fishingZones.prompt" />
            </legend>

            <s:file name="csvFile" cssClass="float-left" />

            <s:submit type="button">
                <i class="icon-upload"></i> Importer
            </s:submit>
        </fieldset>

    </s:form>

    <s:form action="import-terrestrial-locations" method="POST" enctype="multipart/form-data">

        <fieldset>
            <legend>
                <s:text name="wao.import.terrestrialLocations.prompt" />
            </legend>

            <s:file name="csvFile" cssClass="float-left" />

            <s:submit type="button">
                <i class="icon-upload"></i> Importer
            </s:submit>
        </fieldset>

    </s:form>

    <s:form action="import-boats" method="POST" enctype="multipart/form-data">

        <fieldset>
            <legend>
                <s:text name="wao.import.boats.prompt" />
            </legend>

            <s:file name="csvFile" cssClass="float-left"/>

            <s:submit type="button">
                <i class="icon-upload"></i> Importer
            </s:submit>
        </fieldset>

    </s:form>

    <s:if test="obsMer">
        <s:form action="import-contact-state-motives" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>
                    <s:text name="wao.import.contactStateMotives.prompt" />
                </legend>

                <s:file name="csvFile" cssClass="float-left" />

                <s:submit type="button">
                    <i class="icon-upload"></i> Importer
                </s:submit>
            </fieldset>

        </s:form>
    </s:if>

    <s:if test="obsDeb">
        <s:form action="import-obsdeb-codes" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>
                    <s:text name="wao.import.obsDebCodes.prompt" />
                </legend>

                <s:file name="csvFile" />

                <s:submit type="button">
                    <i class="icon-upload"></i> Importer
                </s:submit>
            </fieldset>

        </s:form>

        <s:form action="import-terrestrial-divisions" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>
                    <s:text name="wao.import.terrestrialDivisions.prompt" />
                </legend>

                <s:file name="csvFile" />

                <s:submit type="button">
                    <i class="icon-upload"></i> Importer
                </s:submit>
            </fieldset>

        </s:form>

        <s:form action="import-boat-groups" method="POST" enctype="multipart/form-data">

            <fieldset>
                <legend>
                    <s:text name="wao.import.boatGroups.prompt" />
                </legend>

                <s:file name="csvFile" />

                <s:submit type="button">
                    <i class="icon-upload"></i> Importer
                </s:submit>
            </fieldset>

        </s:form>
    </s:if>

    <table class="table table-bordered">
        <tr>
            <th>
                <s:text name="fr.ifremer.wao.services.service.administration.ReferentialState.referentialName" />
            </th>
            <th>
                <s:text name="fr.ifremer.wao.services.service.administration.ReferentialState.size" />
            </th>
            <th>
                <s:text name="fr.ifremer.wao.services.service.administration.ReferentialState.lastUpdate" />
            </th>
        </tr>
        <s:iterator value="referentialStates">
            <tr>
                <td>
                    <s:property value="referentialName" />
                </td>
                <td>
                    <s:property value="size" />
                </td>
                <td>
                    <s:property value="lastUpdate" />
                </td>
            </tr>
        </s:iterator>
    </table>

</html>
