<%--
  #%L
  Wao :: Web
  %%
  Copyright (C) 2009 - 2014 Ifremer
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<%@taglib uri="/struts-tags" prefix="s" %>

<html>

    <head>
        <title><s:text name="wao.ui.page.companies.title" /></title>
        <content tag="mainClass">form</content>
    </head>

    <div class="form-wrapper">
        <h1><s:text name="wao.ui.page.companies.title" /></h1>

        <table class="table table-bordered">
            <tr>
                <th>
                    <s:text name="wao.ui.field.Company.name" />
                </th>
                <th>
                    <s:text name="wao.ui.field.Company.active" />
                </th>
                <th class="actions">
                    <s:text name="wao.ui.actions" />
                </th>
            </tr>
            <s:iterator value="companies">
                <tr>
                    <td<s:if test=" ! active"> class="inactive"</s:if>>
                        <s:property value="name" />
                    </td>
                    <td>
                        <s:if test="active">
                            <s:text name="wao.ui.misc.yes" />
                        </s:if>
                        <s:else>
                            <s:text name="wao.ui.misc.no" />
                        </s:else>
                    </td>
                    <td class="actions">
                        <s:url action="edit-company!input" id="editCompanyUrl">
                            <s:param name="companyId" value="topiaId" />
                        </s:url>
                        <s:a href="%{editCompanyUrl}">
                            <i class="icon-edit"></i> <s:text name="wao.ui.action.edit" />
                        </s:a>

                        <s:url action="delete-company" id="deleteCompanyUrl">
                            <s:param name="companyId" value="topiaId" />
                        </s:url>
                        <s:a href="%{deleteCompanyUrl}">
                            <i class="icon-trash"></i> <s:text name="wao.ui.action.delete" />
                        </s:a>

                        <s:url action="wao-users" id="waoUsersUrl">
                            <s:param name="companyId" value="topiaId" />
                        </s:url>
                        <s:a href="%{waoUsersUrl}">
                            <i class="icon-user"></i> <s:text name="wao.ui.action.viewCompanyWaoUsers" />
                        </s:a>

                        <s:url action="edit-wao-user!input" id="createWaoUserUrl">
                            <s:param name="companyId" value="topiaId" />
                        </s:url>
                        <s:a href="%{createWaoUserUrl}">
                            <i class="icon-plus"></i> <s:text name="wao.ui.action.createWaoUser" />
                        </s:a>
                    </td>
                </tr>
            </s:iterator>
        </table>

        <div class="form-actions">
            <s:url action="edit-company!input" id="createCompanyUrl" />
            <s:a href="%{createCompanyUrl}" cssClass="btn float-right">
                <i class="icon-plus"></i> <s:text name="wao.ui.action.createCompany" />
            </s:a>
        </div>
    </div>

</html>
