/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.converter;

import com.google.common.io.BaseEncoding;
import fr.ifremer.wao.WaoTechnicalException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.struts2.util.StrutsTypeConverter;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class JFreeChartToImgTagConverter
extends StrutsTypeConverter {
    public Object convertFromString(Map context, String[] values, Class toClass) {
        throw new UnsupportedOperationException();
    }

    public String convertToString(Map context, Object o) {
        if (o instanceof JFreeChart) {
            JFreeChart chart = (JFreeChart)o;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                ChartUtilities.writeChartAsPNG((OutputStream)output, (JFreeChart)chart, (int)1000, (int)600);
            }
            catch (IOException e) {
                throw new WaoTechnicalException("unable to write chart to PNG", (Throwable)e);
            }
            byte[] bytes = output.toByteArray();
            String base64code = BaseEncoding.base64().encode(bytes);
            String html = "<img alt=\"" + chart.getTitle().getText() + "\" src=\"data:image/png;base64," + base64code + "\" />";
            return html;
        }
        throw new WaoTechnicalException("unable to convert " + o);
    }
}

