/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.converter;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.conversion.TypeConversionException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;

public abstract class AbstractDateConverter
extends StrutsTypeConverter {
    private static final Log log = LogFactory.getLog(AbstractDateConverter.class);

    protected abstract Date parse(Locale var1, String var2) throws ParseException;

    protected abstract String format(Locale var1, Date var2);

    public Date convertFromString(Map map, String[] strings, Class aClass) {
        if (strings.length == 1) {
            Date parsedValue;
            String string = strings[0];
            if (StringUtils.isEmpty((CharSequence)string)) {
                parsedValue = null;
            } else {
                Locale locale = (Locale)map.get("com.opensymphony.xwork2.ActionContext.locale");
                Preconditions.checkNotNull((Object)locale, (Object)"No locale found in ActionContext");
                parsedValue = this.parseDate(locale, string, strings, true);
                if (parsedValue == null) {
                    locale = Locale.FRENCH.equals(locale) ? Locale.ENGLISH : Locale.FRENCH;
                    parsedValue = this.parseDate(locale, string, strings, false);
                }
            }
            return parsedValue;
        }
        throw new TypeConversionException("strings=" + Arrays.toString(strings));
    }

    protected Date parseDate(Locale locale, String string, String[] strings, boolean swallonError) {
        Preconditions.checkNotNull((Object)locale);
        try {
            return this.parse(locale, string);
        }
        catch (ParseException e) {
            if (swallonError) {
                return null;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("could not format parse date " + string), (Throwable)e);
            }
            throw new TypeConversionException("strings=" + Arrays.toString(strings));
        }
    }

    public String convertToString(Map map, Object o) {
        String str;
        if (o == null) {
            str = "";
        } else if (o instanceof Date) {
            Date date = (Date)o;
            Locale locale = (Locale)map.get("com.opensymphony.xwork2.ActionContext.locale");
            Preconditions.checkNotNull((Object)locale, (Object)"No locale found in ActionContext");
            str = this.format(locale, date);
        } else {
            throw new UnsupportedOperationException("cannot convert to month " + o);
        }
        return str;
    }
}

