/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web.action;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.SampleMonth;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.services.service.MissingDcf5CodesException;
import fr.ifremer.wao.services.service.MissingFishingZonesException;
import fr.ifremer.wao.services.service.MissingPeriodBeginException;
import fr.ifremer.wao.services.service.MissingPeriodEndException;
import fr.ifremer.wao.services.service.MissingProfessionSpeciesException;
import fr.ifremer.wao.services.service.MissingProgramNameException;
import fr.ifremer.wao.services.service.MissingSampleRowLogCommentException;
import fr.ifremer.wao.services.service.ObsMerSamplingPlanService;
import fr.ifremer.wao.services.service.SampleMonthWithIllegalExpectedTidesValueException;
import fr.ifremer.wao.services.service.SampleRowCodeMustBeUniqueException;
import fr.ifremer.wao.services.service.SamplingPlanService;
import fr.ifremer.wao.services.service.UpdateSampleRowCommand;
import fr.ifremer.wao.services.service.WrongSampleRowCodeFormatException;
import fr.ifremer.wao.services.service.administration.UnknownBoatImmatriculationsException;
import fr.ifremer.wao.web.WaoJspActionSupport;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

@Results(value={@Result(name="success", type="redirectAction", params={"actionName", "sampling-plan"})})
public class EditSampleRowAction
extends WaoJspActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EditSampleRowAction.class);
    protected transient SamplingPlanService service;
    protected Optional<String> optionalSampleRowId = Optional.absent();
    protected UpdateSampleRowCommand updateSampleRowCommand;

    public void setService(ObsMerSamplingPlanService service) {
        this.service = service;
    }

    public String getSampleRowId() {
        return (String)this.optionalSampleRowId.orNull();
    }

    public void setSampleRowId(String sampleRowId) {
        this.optionalSampleRowId = Optional.fromNullable((Object)Strings.emptyToNull((String)sampleRowId));
    }

    public void prepare() {
        this.updateSampleRowCommand = this.service.newUpdateSampleRowCommand(this.getAuthenticatedWaoUser(), this.optionalSampleRowId);
    }

    public void validate() {
        SampleRow sampleRow = this.updateSampleRowCommand.getSampleRow();
        try {
            this.service.preValidate(this.getAuthenticatedWaoUser(), this.updateSampleRowCommand);
            this.service.validate(this.getAuthenticatedWaoUser(), this.updateSampleRowCommand);
            if (CollectionUtils.isEmpty((Collection)sampleRow.getdCF5Code())) {
                this.addFieldError("updateSampleRowCommand.dcf5Codes", this.t("wao.ui.form.SampleRow.error.missingDcf5Codes", new Object[0]));
            }
        }
        catch (UnknownBoatImmatriculationsException e) {
            this.addFieldError("updateSampleRowCommand.elligibleBoatImmatriculations", this.t("wao.ui.unknownBoatImmatriculations", new Object[]{Joiner.on((String)", ").join((Iterable)e.getImmatriculations())}));
        }
        catch (SampleRowCodeMustBeUniqueException e) {
            this.addFieldError("updateSampleRowCommand.code", this.t("wao.ui.form.SampleRow.error.codeMustBeUnique", new Object[0]));
        }
        catch (MissingPeriodEndException e) {
            this.addFieldError("updateSampleRowCommand.sampleRow.periodEnd", this.t("wao.ui.form.SampleRow.error.missingPeriodEnd", new Object[0]));
        }
        catch (MissingPeriodBeginException e) {
            this.addFieldError("updateSampleRowCommand.sampleRow.periodBegin", this.t("wao.ui.form.SampleRow.error.missingPeriodBegin", new Object[0]));
        }
        catch (MissingFishingZonesException e) {
            this.addFieldError("updateSampleRowCommand.fishingZones", this.t("wao.ui.form.SampleRow.error.missingFishingZones", new Object[0]));
        }
        catch (WrongSampleRowCodeFormatException e) {
            this.addFieldError("updateSampleRowCommand.code", this.t("wao.import.sampleRow.failure.wrongSampleRowCodeFormat", new Object[]{sampleRow.getCode()}));
        }
        catch (MissingSampleRowLogCommentException e) {
            this.addFieldError("updateSampleRowCommand.sampleRowLog.comment", this.t("wao.ui.form.SampleRow.error.missingLogComment", new Object[0]));
        }
        catch (MissingProfessionSpeciesException e) {
            this.addFieldError("updateSampleRowCommand.sampleRow.samplingStrategy", this.t("wao.ui.form.SampleRow.error.missingProfessionSpecies", new Object[0]));
        }
        catch (SampleMonthWithIllegalExpectedTidesValueException e) {
            SampleMonth sampleMonth = e.getSampleMonth();
            this.addActionError(this.t("wao.ui.form.SampleRow.error.sampleMonthWithIllegalExpectedTidesValue", new Object[]{this.formatMonth(sampleMonth.getPeriodDate())}));
        }
        catch (MissingProgramNameException e) {
            this.addFieldError("updateSampleRowCommand.sampleRow.programName", this.t("wao.ui.form.SampleRow.error.missingProgramName", new Object[0]));
        }
        catch (MissingDcf5CodesException e) {
            this.addFieldError("updateSampleRowCommand.dcf5Codes", this.t("wao.ui.form.SampleRow.error.missingDcf5Codes", new Object[0]));
        }
    }

    public String execute() {
        this.service.save(this.updateSampleRowCommand);
        this.session.addMessage(this.t("wao.ui.form.updateSampleRowCommand.success", new Object[]{this.updateSampleRowCommand.getSampleRow().getCode()}));
        this.session.setSampleRowToHighlightId(this.updateSampleRowCommand.getSampleRow().getTopiaId());
        return "success";
    }

    public UpdateSampleRowCommand getUpdateSampleRowCommand() {
        if (this.updateSampleRowCommand == null) {
            this.prepare();
        }
        return this.updateSampleRowCommand;
    }

    public Map<String, Integer> getExpectedObservationsByMonths() {
        return this.getUpdateSampleRowCommand().getExpectedObservationsByMonths();
    }

    public void setExpectedObservationsByMonths(Map<String, Integer> expectedObservationsByMonths) {
        this.getUpdateSampleRowCommand().setExpectedObservationsByMonths(expectedObservationsByMonths);
    }
}

