/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.web;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import fr.ifremer.wao.WaoApplicationConfig;
import fr.ifremer.wao.WaoTopiaPersistenceContext;
import fr.ifremer.wao.services.WaoApplicationContext;
import fr.ifremer.wao.services.WaoService;
import fr.ifremer.wao.services.WaoServiceContext;
import fr.ifremer.wao.web.DefaultWaoApplicationContext;
import fr.ifremer.wao.web.WaoActionSupport;
import fr.ifremer.wao.web.WaoSession;
import fr.ifremer.wao.web.action.authentication.LoginAction;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;

public class WaoInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(WaoInterceptor.class);
    protected static final ImmutableSet<Class<LoginAction>> ACTIONS_ACCESSIBLE_WITHOUT_LOGIN = ImmutableSet.of(LoginAction.class);

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("init " + this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof WaoActionSupport) {
            WaoActionSupport waoAction = (WaoActionSupport)action;
            Locale locale = waoAction.getLocale();
            WaoServiceContext serviceContext = this.newServiceContext(invocation, locale);
            WaoSession waoSession = this.getWaoSession(invocation);
            if (waoSession.getAuthenticatedWaoUser() == null && !ACTIONS_ACCESSIBLE_WITHOUT_LOGIN.contains(waoAction.getClass())) {
                return "redirect-to-login";
            }
            if (CollectionUtils.isNotEmpty((Collection)waoSession.getMessages())) {
                for (String message : waoSession.getMessages()) {
                    waoAction.addActionMessage(message);
                }
                waoSession.getMessages().clear();
            }
            if (CollectionUtils.isNotEmpty((Collection)waoSession.getErrorMessages())) {
                for (String message : waoSession.getErrorMessages()) {
                    waoAction.addActionError(message);
                }
                waoSession.getErrorMessages().clear();
            }
            Set descriptors = BeanUtil.getDescriptors(action.getClass(), (Predicate)BeanUtil.IS_WRITE_DESCRIPTOR);
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                WaoService toInject = null;
                if (WaoService.class.isAssignableFrom(propertyType)) {
                    Class<?> serviceClass = propertyType;
                    toInject = serviceContext.newService(serviceClass);
                } else if (WaoSession.class.isAssignableFrom(propertyType)) {
                    toInject = waoSession;
                } else if (WaoApplicationConfig.class.isAssignableFrom(propertyType)) {
                    toInject = this.getWaoApplicationContext(invocation).getApplicationConfig();
                }
                if (toInject == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("injecting " + toInject + " in action " + action));
                }
                propertyDescriptor.getWriteMethod().invoke(action, toInject);
            }
            try {
                String string = invocation.invoke();
                return string;
            }
            finally {
                serviceContext.getPersistenceContext().rollback();
                serviceContext.getPersistenceContext().close();
            }
        }
        return invocation.invoke();
    }

    protected WaoSession getWaoSession(ActionInvocation invocation) {
        WaoSession session = (WaoSession)invocation.getInvocationContext().getSession().get("waoSession");
        if (session == null) {
            session = new WaoSession();
            invocation.getInvocationContext().getSession().put("waoSession", session);
        }
        return session;
    }

    protected WaoApplicationContext getWaoApplicationContext(ActionInvocation invocation) {
        DefaultWaoApplicationContext applicationContext = (DefaultWaoApplicationContext)invocation.getInvocationContext().getApplication().get("WaoApplicationContext");
        Preconditions.checkNotNull((Object)applicationContext, (Object)"application context must be initialized before calling an action");
        return applicationContext;
    }

    protected WaoServiceContext newServiceContext(ActionInvocation invocation, Locale locale) {
        WaoApplicationContext waoApplicationContext = this.getWaoApplicationContext(invocation);
        WaoTopiaPersistenceContext persistenceContext = waoApplicationContext.newPersistenceContext();
        WaoServiceContext serviceContext = waoApplicationContext.newServiceContext(persistenceContext, locale);
        return serviceContext;
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)("destroy " + this));
        }
    }
}

