package fr.ifremer.wao.web.converter;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.conversion.TypeConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;


/**
 * To convert a date as a month.
 * <p/>
 * FIXME-tchemit 2014-04-06 When user change his locale, we could have in parameters some date formatted with the previous
 * FIXME-tchemit 2014-04-06 locale, we need then to try with previous locale date pattern.
 *
 * @since 4.0
 */
public abstract class AbstractDateConverter extends StrutsTypeConverter {

    /** Logger. */
    private static final Log log = LogFactory.getLog(AbstractDateConverter.class);

    protected abstract Date parse(Locale locale, String string) throws ParseException;

    protected abstract String format(Locale locale, Date date);

    @Override
    public Date convertFromString(Map map, String[] strings, Class aClass) {

        if (strings.length == 1) {

            String string = strings[0];

            Date parsedValue;

            if (StringUtils.isEmpty(string)) {

                parsedValue = null;

            } else {

                Locale locale = (Locale) map.get(ActionContext.LOCALE);
                Preconditions.checkNotNull(locale, "No locale found in ActionContext");

                parsedValue = parseDate(locale, string, strings, true);

                if (parsedValue == null) {

                    //FIXME If action is changing language, then date are not in good format
                    //FIXME Let's try why other locale...
                    if (Locale.FRENCH.equals(locale)) {
                        locale = Locale.ENGLISH;
                    } else {
                        locale = Locale.FRENCH;
                    }
                    parsedValue = parseDate(locale, string, strings, false);
                }
            }

            return parsedValue;

        } else {
            throw new TypeConversionException("strings=" + Arrays.toString(strings));
        }
    }

    protected Date parseDate(Locale locale, String string, String[] strings, boolean swallonError) {
        Preconditions.checkNotNull(locale);
        try {
            return parse(locale, string);
        } catch (ParseException e) {
            if (swallonError) {
                return null;
            }
            //FIXME See why we don't see the error
            if (log.isWarnEnabled()) {
                log.warn("could not format parse date " + string, e);
            }
            throw new TypeConversionException("strings=" + Arrays.toString(strings));
        }
    }

    @Override
    public String convertToString(Map map, Object o) {

        String str;

        if (o == null) {

            str = StringUtils.EMPTY;

        } else {

            if (o instanceof Date) {

                Date date = (Date) o;

                Locale locale = (Locale) map.get(ActionContext.LOCALE);
                Preconditions.checkNotNull(locale, "No locale found in ActionContext");
                str = format(locale, date);
            } else {
                throw new UnsupportedOperationException("cannot convert to month " + o);
            }
        }

        return str;

    }
}
