package fr.ifremer.wao.web.action.administration;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.opensymphony.xwork2.Preparable;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.services.service.administration.WaoUsersService;
import fr.ifremer.wao.web.WaoJspActionSupport;

import java.util.List;

public class WaoUsersAction extends WaoJspActionSupport implements Preparable {

    private static final long serialVersionUID = 1L;

    protected transient WaoUsersService service;

    protected Optional<String> optionalCompanyId = Optional.absent();

    protected List<WaoUser> waoUsers;

    public void setService(WaoUsersService service) {
        this.service = service;
    }

    public void setCompanyId(String companyId) {
        this.optionalCompanyId = Optional.fromNullable(Strings.emptyToNull(companyId));
    }

    public String getCompanyId() {
        return optionalCompanyId.orNull();
    }

    @Override
    public void prepare() {

        Preconditions.checkState(getAuthenticatedWaoUser().isAuthorizedToViewCompanyUsers());

        if (getAuthenticatedWaoUser().isCoordinator()) {
            optionalCompanyId = Optional.of(getAuthenticatedWaoUser().getCompany().getTopiaId());
        }

        waoUsers = service.getWaoUsers(optionalCompanyId);

    }

    public List<WaoUser> getWaoUsers() {
        return waoUsers;
    }
}
