package fr.ifremer.wao.web;

/*
 * #%L
 * Wao :: Web
 * %%
 * Copyright (C) 2009 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.wao.BoatsFilter;
import fr.ifremer.wao.ContactsFilter;
import fr.ifremer.wao.SampleRowsFilter;
import fr.ifremer.wao.services.AuthenticatedWaoUser;

import java.io.Serializable;
import java.util.Collection;

public class WaoSession implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String SESSION_PARAMETER = "waoSession";

    protected Collection<String> messages;

    protected Collection<String> errorMessages;

    protected AuthenticatedWaoUser authenticatedWaoUser;

    protected String sampleRowToHighlightId;

    protected String contactToHighlightId;

    protected String startBoatSelectionForSampleRowId;

    protected SampleRowsFilter sampleRowsFilter;

    protected BoatsFilter boatsFilter;

    protected ContactsFilter contactsFilter;

    protected ContactsFilter synthesisFilter;

    public Collection<String> getMessages() {
        if (messages == null) {
            messages = Lists.newLinkedList();
        }
        return messages;
    }

    public void addMessage(String message) {
        getMessages().add(message);
    }

    public Collection<String> getErrorMessages() {
        if (errorMessages == null) {
            errorMessages = Lists.newLinkedList();
        }
        return errorMessages;
    }

    public void addErrorMessages(String errorMessage) {
        getErrorMessages().add(errorMessage);
    }

    public void logout() {
        messages = null;
        errorMessages = null;
        authenticatedWaoUser = null;
        sampleRowToHighlightId = null;
        contactToHighlightId = null;
        startBoatSelectionForSampleRowId = null;
        sampleRowsFilter = null;
        boatsFilter = null;
        contactsFilter = null;
        synthesisFilter = null;
    }

    public AuthenticatedWaoUser getAuthenticatedWaoUser() {
        return authenticatedWaoUser;
    }

    public void setAuthenticatedWaoUser(AuthenticatedWaoUser authenticatedWaoUser) {
        this.authenticatedWaoUser = authenticatedWaoUser;
    }

    public String getSampleRowToHighlightId() {
        return sampleRowToHighlightId;
    }

    public void setSampleRowToHighlightId(String sampleRowToHighlightId) {
        this.sampleRowToHighlightId = sampleRowToHighlightId;
    }

    public void setContactToHighlightId(String contactToHighlightId) {
        this.contactToHighlightId = contactToHighlightId;
    }

    public String getContactToHighlightId() {
        return contactToHighlightId;
    }

    public void setStartBoatSelectionForSampleRowId(String startBoatSelectionForSampleRowId) {
        this.startBoatSelectionForSampleRowId = startBoatSelectionForSampleRowId;
    }

    public String getStartBoatSelectionForSampleRowId() {
        return startBoatSelectionForSampleRowId;
    }

    public SampleRowsFilter getSampleRowsFilter() {
        return sampleRowsFilter;
    }

    public void setSampleRowsFilter(SampleRowsFilter sampleRowsFilter) {
        this.sampleRowsFilter = sampleRowsFilter;
    }

    public BoatsFilter getBoatsFilter() {
        return boatsFilter;
    }

    public void setBoatsFilter(BoatsFilter boatsFilter) {
        this.boatsFilter = boatsFilter;
    }

    public ContactsFilter getContactsFilter() {
        return contactsFilter;
    }

    public void setContactsFilter(ContactsFilter contactsFilter) {
        this.contactsFilter = contactsFilter;
    }

    public void setSynthesisFilter(ContactsFilter synthesisFilter) {
        this.synthesisFilter = synthesisFilter;
    }

    public ContactsFilter getSynthesisFilter() {
        return synthesisFilter;
    }
}
