/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentCode;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentId;
import fr.ifremer.adagio.core.dao.administration.user.PersonExtendDao;
import fr.ifremer.adagio.core.dao.administration.user.UserProfilId;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.vo.administration.user.PersonVO;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.persistence.service.referential.PersonPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.springframework.stereotype.Service;

@Service(value="personPersistenceService")
public class PersonPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements PersonPersistenceService {
    private static final Log log = LogFactory.getLog(PersonPersistenceServiceImpl.class);
    @Resource(name="personDao")
    protected PersonExtendDao personDao;

    @Override
    public List<Person> getAllPerson() {
        Iterator<Object[]> list = this.queryListWithStatus("allPersons", "observerProfilId", IntegerType.INSTANCE, UserProfilId.OBSERVER.getValue(), "projectMemberProfilId", IntegerType.INSTANCE, UserProfilId.PROJECT_MEMBER.getValue(), "userProfilId", IntegerType.INSTANCE, UserProfilId.USER.getValue(), "departementPrefixCode", StringType.INSTANCE, DepartmentCode.INSIDE_PREFIX.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadPersons(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Person> getAllPersonWithObsoletes() {
        Iterator<Object[]> list = this.queryListWithStatus2("allPersonsWithObsoletes", "observerProfilId", IntegerType.INSTANCE, UserProfilId.OBSERVER.getValue(), "projectMemberProfilId", IntegerType.INSTANCE, UserProfilId.PROJECT_MEMBER.getValue(), "userProfilId", IntegerType.INSTANCE, UserProfilId.USER.getValue(), "departementPrefixCode", StringType.INSTANCE, DepartmentCode.INSIDE_PREFIX.getValue());
        ArrayList result = Lists.newArrayList();
        this.loadPersons(list, result);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Person getPerson(Integer personId) {
        Object[] source = this.queryUniqueWithStatus2("personById", "personId", IntegerType.INSTANCE, personId);
        return source == null ? null : this.loadPerson(source);
    }

    @Override
    public boolean isTemporaryPersonUsed(Integer id) {
        boolean result;
        Long count = (Long)this.queryUniqueTyped("countManagerPersonInScientificCruise", "id", IntegerType.INSTANCE, id);
        boolean bl = result = count > 0L;
        if (!result) {
            count = (Long)this.queryUniqueTyped("countRecorderPersonInScientificCruise", "id", IntegerType.INSTANCE, id);
            boolean bl2 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countRecorderPersonInFishingTrip", "id", IntegerType.INSTANCE, id);
            boolean bl3 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countPersonInVesselPersonFeatures", "id", IntegerType.INSTANCE, id);
            result = count > 0L;
        }
        return result;
    }

    @Override
    public List<Person> addTemporaryPersons(List<Person> persons) {
        ArrayList result = Lists.newArrayList();
        for (Person source : persons) {
            Person added = this.addTemporaryPerson(source);
            result.add(added);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Person> updateTemporaryPersons(List<Person> persons) {
        ArrayList result = Lists.newArrayList();
        for (Person source : persons) {
            Person updated = this.updateTemporaryPerson(source);
            result.add(updated);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Person> linkTemporaryPersons(List<Person> persons) {
        ArrayList result = Lists.newArrayList();
        for (Person source : persons) {
            Person linked = this.linkTemporaryPerson(source);
            result.add(linked);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void replacePerson(Person source, Person target, boolean delete) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)Persons.isTemporary(source));
        Preconditions.checkState((!Persons.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getIdAsInt();
        Integer targetId = target.getIdAsInt();
        this.queryUpdate("replaceManagerPersonInScientificCruise", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceRecorderPersonInScientificCruise", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceRecorderPersonInFishingTrip", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replacePersonInVesselPersonFeatures", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.cacheService.clearAllCaches();
        if (delete) {
            this.deleteTemporaryPerson(sourceId);
        }
    }

    @Override
    public void deleteTemporaryPersons(Collection<Integer> ids) {
        for (Integer id : ids) {
            this.deleteTemporaryPerson(id);
        }
    }

    @Override
    public void deleteTemporaryPerson(Integer id) {
        Preconditions.checkNotNull((Object)id);
        if (id > 0) {
            throw new ApplicationBusinessException(String.format("Can't delete a Person with a positive id %d.", id));
        }
        Person person = this.getPerson(id);
        if (person == null) {
            throw new ApplicationBusinessException(String.format("Person with id %d does not exists", id));
        }
        this.personDao.remove(id);
    }

    protected Person addTemporaryPerson(Person source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Preconditions.checkArgument((source.getIdAsInt() == null || Persons.isTemporaryId(source.getIdAsInt()) ? 1 : 0) != 0);
        fr.ifremer.adagio.core.dao.administration.user.Person target = this.personDao.createAsTemporary(source.getLastName(), source.getFirstName(), DepartmentId.UNKNOWN_RECORDER_DEPARTMENT.getValue());
        Person result = Persons.newPerson();
        result.setId(target.getId());
        result.setLastName(source.getLastName());
        result.setFirstName(source.getFirstName());
        this.setStatus(StatusCode.TEMPORARY.getValue(), result);
        return result;
    }

    protected Person updateTemporaryPerson(Person source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkArgument((boolean)Persons.isTemporaryId(source.getIdAsInt()));
        Person result = this.getPerson(source.getIdAsInt());
        result.setLastName(source.getLastName());
        result.setFirstName(source.getFirstName());
        this.setStatus(StatusCode.TEMPORARY.getValue(), result);
        PersonVO toUpdate = new PersonVO();
        toUpdate.setId(source.getIdAsInt());
        toUpdate.setLastname(source.getLastName());
        toUpdate.setFirstname(source.getFirstName());
        toUpdate.setDepartmentId(DepartmentId.UNKNOWN_RECORDER_DEPARTMENT.getValue());
        toUpdate.setCreationDate(this.personDao.load(source.getIdAsInt()).getCreationDate());
        toUpdate.setStatusCode(StatusCode.TEMPORARY.getValue());
        this.personDao.save(toUpdate);
        return result;
    }

    protected Person linkTemporaryPerson(Person source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getFirstName());
        Preconditions.checkNotNull((Object)source.getLastName());
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkArgument((boolean)Persons.isTemporaryId(source.getIdAsInt()));
        Iterator<Object[]> sources = this.queryListWithStatus("personByFullName", "personFirstName", StringType.INSTANCE, source.getFirstName(), "personLastName", StringType.INSTANCE, source.getLastName());
        Object[] row = null;
        if (sources.hasNext()) {
            row = sources.next();
            if (sources.hasNext()) {
                Object[] next = sources.next();
                Person person = this.loadPerson(next);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Il existe une autre personne d'identifiant " + person.getId() + " trouv\u00e9e en pase pour la personne temporaire " + source.getFirstName() + " - " + source.getLastName()));
                }
            }
        }
        return row == null ? null : this.loadPerson(row);
    }

    protected void loadPersons(Iterator<Object[]> list, List<Person> result) {
        while (list.hasNext()) {
            Object[] source = list.next();
            Person target = this.loadPerson(source);
            result.add(target);
        }
    }

    protected Person loadPerson(Object ... source) {
        Person target = Persons.newPerson();
        target.setId(String.valueOf(source[0]));
        target.setLastName((String)source[1]);
        target.setFirstName((String)source[2]);
        target.setDepartment((String)source[3]);
        this.setStatus((String)source[4], target);
        return target;
    }
}

